/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.timeseries.operators;

import com.github.signaflo.math.operations.DoubleFunctions;
import com.github.signaflo.timeseries.TimeSeries;
import com.github.signaflo.timeseries.operators.LagOperator;
import com.github.signaflo.timeseries.operators.MovingAveragePolynomial;
import java.time.OffsetDateTime;
import java.util.Arrays;

public class LagPolynomial {
    final double[] parameters;
    private final double[] coefficients;
    private final int degree;

    LagPolynomial(double ... parameters) {
        this.parameters = (double[])parameters.clone();
        this.coefficients = new double[parameters.length + 1];
        this.coefficients[0] = 1.0;
        System.arraycopy(parameters, 0, this.coefficients, 1, parameters.length);
        this.degree = parameters.length;
    }

    public static LagPolynomial firstDifference() {
        return new LagPolynomial(-1.0);
    }

    private static LagPolynomial firstSeasonalDifference(int seasonalLag) {
        double[] poly = new double[seasonalLag];
        poly[seasonalLag - 1] = -1.0;
        return new LagPolynomial(poly);
    }

    public static LagPolynomial seasonalDifferences(int seasonalLag, int D) {
        if (D < 0) {
            throw new IllegalArgumentException("The degree of differencing must be greater than or equal to 0, but was " + D);
        }
        if (D > 0) {
            LagPolynomial diff = LagPolynomial.firstSeasonalDifference(seasonalLag);
            for (int i = 1; i < D; ++i) {
                diff = diff.times(diff);
            }
            return diff;
        }
        return new LagPolynomial(new double[0]);
    }

    public static LagPolynomial differences(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("The degree of differencing must be greater than or equal to 0, but was " + d);
        }
        if (d > 0) {
            LagPolynomial diff = LagPolynomial.firstDifference();
            for (int i = 1; i < d; ++i) {
                diff = diff.times(diff);
            }
            return diff;
        }
        return new LagPolynomial(new double[0]);
    }

    public static LagPolynomial movingAverage(double ... parameters) {
        return new MovingAveragePolynomial(parameters);
    }

    public static LagPolynomial autoRegressive(double ... parameters) {
        double[] inverseParams = new double[parameters.length];
        for (int i = 0; i < inverseParams.length; ++i) {
            inverseParams[i] = -parameters[i];
        }
        return new LagPolynomial(inverseParams);
    }

    public final LagPolynomial times(LagPolynomial other) {
        double[] newParams = new double[this.degree + other.degree + 1];
        for (int i = 0; i < this.coefficients.length; ++i) {
            for (int j = 0; j < other.coefficients.length; ++j) {
                int n = i + j;
                newParams[n] = newParams[n] + this.coefficients[i] * other.coefficients[j];
            }
        }
        return new LagPolynomial(DoubleFunctions.slice((double[])newParams, (int)1, (int)newParams.length));
    }

    public final double apply(TimeSeries timeSeries, int index) {
        double value = 0.0;
        for (int i = 0; i < this.coefficients.length; ++i) {
            value += this.coefficients[i] * LagOperator.apply(timeSeries, index, i);
        }
        return value;
    }

    public final double apply(TimeSeries timeSeries, OffsetDateTime dateTime) {
        double value = 0.0;
        for (int i = 0; i < this.coefficients.length; ++i) {
            value += this.coefficients[i] * LagOperator.apply(timeSeries, dateTime, i);
        }
        return value;
    }

    public double solve(TimeSeries timeSeries, int index) {
        double value = 0.0;
        for (int i = 0; i < this.parameters.length; ++i) {
            value -= this.parameters[i] * LagOperator.apply(timeSeries, index, i + 1);
        }
        return value;
    }

    public double solve(TimeSeries timeSeries, OffsetDateTime dateTime) {
        double value = 0.0;
        for (int i = 0; i < this.parameters.length; ++i) {
            value -= this.parameters[i] * LagOperator.apply(timeSeries, dateTime, i + 1);
        }
        return value;
    }

    public double solve(double[] timeSeries, int index) {
        double value = 0.0;
        for (int i = 0; i < Math.min(this.parameters.length, timeSeries.length); ++i) {
            value -= this.parameters[i] * LagOperator.apply(timeSeries, index, i + 1);
        }
        return value;
    }

    public final double[] parameters() {
        return (double[])this.parameters.clone();
    }

    public final double[] inverseParams() {
        double[] invParams = new double[this.parameters.length];
        for (int i = 0; i < invParams.length; ++i) {
            invParams[i] = -this.parameters[i];
        }
        return invParams;
    }

    final double[] coefficients() {
        return (double[])this.coefficients.clone();
    }

    public String toString() {
        double epsilon = Math.ulp(1.0);
        StringBuilder builder = new StringBuilder();
        builder.append("1");
        for (int i = 1; i < this.coefficients.length - 1; ++i) {
            if (!(Math.abs(this.coefficients[i]) > epsilon)) continue;
            if (this.coefficients[i] < 0.0) {
                builder.append(" - ");
            } else {
                builder.append(" + ");
            }
            if (Math.abs(this.coefficients[i] - 1.0) > epsilon) {
                builder.append(Double.toString(Math.abs(this.coefficients[i])));
            }
            builder.append("L");
            if (i <= 1) continue;
            builder.append("^").append(i);
        }
        int lastIndex = this.coefficients.length - 1;
        if (this.coefficients[lastIndex] < 0.0) {
            builder.append(" - ");
        } else {
            builder.append(" + ");
        }
        if (this.coefficients.length > 1) {
            if (this.coefficients[lastIndex] != 1.0) {
                builder.append(Double.toString(Math.abs(this.coefficients[lastIndex])));
            }
            builder.append("L");
        }
        if (this.coefficients.length > 2) {
            builder.append("^").append(lastIndex);
        }
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.coefficients);
        result = 31 * result + this.degree;
        result = 31 * result + Arrays.hashCode(this.parameters);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LagPolynomial other = (LagPolynomial)obj;
        if (!Arrays.equals(this.coefficients, other.coefficients)) {
            return false;
        }
        return this.degree == other.degree && Arrays.equals(this.parameters, other.parameters);
    }
}

