/*
 * Decompiled with CFR 0.152.
 */
package com.github.silaev.mongodb.replicaset.converter.impl;

import com.github.silaev.mongodb.replicaset.converter.Converter;
import com.github.silaev.mongodb.replicaset.converter.YmlConverter;
import com.github.silaev.mongodb.replicaset.converter.impl.VersionConverter;
import com.github.silaev.mongodb.replicaset.converter.impl.YmlConverterImpl;
import com.github.silaev.mongodb.replicaset.model.MongoNode;
import com.github.silaev.mongodb.replicaset.model.MongoNodeMutable;
import com.github.silaev.mongodb.replicaset.model.MongoRsStatus;
import com.github.silaev.mongodb.replicaset.model.MongoRsStatusMutable;
import com.github.silaev.mongodb.replicaset.model.ReplicaSetMemberState;
import com.github.silaev.mongodb.replicaset.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringToMongoRsStatusConverter
implements Converter<String, MongoRsStatus> {
    private static final Logger log = LoggerFactory.getLogger(StringToMongoRsStatusConverter.class);
    private static final String MONGO_VERSION_MARKER = "MongoDB server version:";
    private static final String OK = "\"ok\" : ";
    private static final Pattern OK_PATTERN = Pattern.compile("(?i).*\"ok\" : ");
    private final YmlConverter yamlConverter;
    private final VersionConverter versionConverter;

    public StringToMongoRsStatusConverter() {
        this.yamlConverter = new YmlConverterImpl();
        this.versionConverter = new VersionConverter();
    }

    @Override
    public MongoRsStatus convert(String source) {
        MongoRsStatusMutable mongoRsStatusMutable;
        ByteArrayInputStream io = new ByteArrayInputStream(this.extractJsonPayloadFromMongoDBShell(source).getBytes(StandardCharsets.UTF_8));
        try {
            mongoRsStatusMutable = this.yamlConverter.unmarshal(MongoRsStatusMutable.class, io);
        }
        catch (Exception e) {
            log.error("Cannot convert to yaml format: \n{}", (Object)source);
            throw e;
        }
        if (Objects.isNull(mongoRsStatusMutable)) {
            return MongoRsStatus.of(0, null, Collections.emptyList());
        }
        return MongoRsStatus.of(mongoRsStatusMutable.getStatus(), this.versionConverter.convert(mongoRsStatusMutable.getVersion()), this.getImmutableMembers(mongoRsStatusMutable));
    }

    private List<MongoNode> getImmutableMembers(MongoRsStatusMutable mongoRsStatusMutable) {
        return Optional.ofNullable(mongoRsStatusMutable.getMembers()).map(m -> mongoRsStatusMutable.getMembers().stream().map(this::mongoNodeMapping).sorted(Comparator.comparing(MongoNode::getPort)).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList))).orElseGet(Collections::emptyList);
    }

    private MongoNode mongoNodeMapping(MongoNodeMutable node) {
        String[] address = StringUtils.getArrayByDelimiter(node.getName());
        return MongoNode.of(address[0], Integer.parseInt(address[1]), node.getHealth(), ReplicaSetMemberState.getByValue(node.getState()));
    }

    public String extractRawPayloadFromMongoDBShell(String mongoDbReply) {
        return this.extractRawPayloadFromMongoDBShell(mongoDbReply, false);
    }

    private String extractJsonPayloadFromMongoDBShell(String mongoDbReply) {
        return this.extractRawPayloadFromMongoDBShell(mongoDbReply, true);
    }

    private String extractRawPayloadFromMongoDBShell(String mongoDbReply, boolean formatJson) {
        String version = null;
        String[] lines = mongoDbReply.replace("\t", "").split("\n");
        int length = lines.length;
        for (int idx = 0; idx < length; ++idx) {
            String currentLine = lines[idx];
            if (currentLine.isEmpty() || !currentLine.contains(MONGO_VERSION_MARKER)) continue;
            version = currentLine.substring(currentLine.indexOf(58) + 1).trim();
            ++idx;
            break;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = idx; i < length; ++i) {
            sb.append(lines[i].replaceAll("\\s\\s", ""));
        }
        if (formatJson) {
            int endIndexOk;
            Matcher matcher = OK_PATTERN.matcher(sb);
            int n = endIndexOk = matcher.find() ? matcher.end() : 0;
            if (endIndexOk > 0) {
                String status = sb.substring(endIndexOk, endIndexOk + 1);
                sb.delete(endIndexOk - OK.length(), sb.length());
                String strExtra = String.format("\"version\" : \"%s\",", version) + String.format("\"status\" : \"%s\"}", status);
                sb.append(strExtra);
            }
        }
        return sb.toString();
    }

    public StringToMongoRsStatusConverter(YmlConverter yamlConverter, VersionConverter versionConverter) {
        this.yamlConverter = yamlConverter;
        this.versionConverter = versionConverter;
    }
}

