/*
 * Decompiled with CFR 0.152.
 */
package com.github.silaev.mongodb.replicaset.model;

public final class MongoDbVersion {
    private final int major;
    private final int minor;
    private final int patch;

    private MongoDbVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public static MongoDbVersion of(int major, int minor, int patch) {
        return new MongoDbVersion(major, minor, patch);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MongoDbVersion)) {
            return false;
        }
        MongoDbVersion other = (MongoDbVersion)o;
        if (this.getMajor() != other.getMajor()) {
            return false;
        }
        if (this.getMinor() != other.getMinor()) {
            return false;
        }
        return this.getPatch() == other.getPatch();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMajor();
        result = result * 59 + this.getMinor();
        result = result * 59 + this.getPatch();
        return result;
    }

    public String toString() {
        return "MongoDbVersion(major=" + this.getMajor() + ", minor=" + this.getMinor() + ", patch=" + this.getPatch() + ")";
    }
}

