/*
 * Decompiled with CFR 0.152.
 */
package config;

import java.util.Properties;
import org.jetbrains.annotations.Nullable;
import util.Log;

public class Config {
    private static final String DEFAULT_PATH = "/config.properties";
    private static Properties properties = null;
    private static ClassLoader classLoader = null;

    public static void setClassLoader(Class pClass) {
        classLoader = pClass.getClassLoader();
        properties = Config._load(DEFAULT_PATH);
    }

    @Nullable
    public static String get(String pProperty) {
        if (classLoader == null) {
            throw new RuntimeException("Config-Classloader must not be null");
        }
        return properties.getProperty(pProperty);
    }

    @Nullable
    public static String get(String pProperty, String pResourcePath) {
        return Config._load(pResourcePath).getProperty(pProperty);
    }

    private static Properties _load(String pPath) {
        try {
            Properties props = new Properties();
            props.load(classLoader.getResourceAsStream(pPath));
            return props;
        }
        catch (Exception e) {
            Log.error("Config-file could not be loaded. Path: " + pPath);
            throw new RuntimeException(e);
        }
    }
}

