/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.time.DateUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import util.Log;

public class CommonUtil {
    private CommonUtil() {
    }

    public static String toJSON(Object pToConvert) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        mapper.setVisibilityChecker(mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        try {
            return mapper.writeValueAsString(pToConvert);
        }
        catch (JsonProcessingException pE) {
            throw new RuntimeException(pE);
        }
    }

    public static Document parseXMLResult(String pResult) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            InputSource source = new InputSource();
            source.setCharacterStream(new StringReader(pResult));
            Document doc = dBuilder.parse(source);
            doc.getDocumentElement().normalize();
            return doc;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Log.error("Unexpected error while parsing XML-result");
            throw new RuntimeException(e);
        }
    }

    public static long toLongDate(String pDate) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
        return format.parse(pDate).getTime();
    }

    public static String toStringDate(Long pDate) {
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy HH:mm");
        return format.format(new Date(pDate));
    }

    public static long getTodayCertainTime(String pCertainTime) {
        Date todayStart = DateUtils.truncate((Date)new Date(), (int)5);
        String[] parts = pCertainTime.split(":");
        int minutes = Integer.valueOf(parts[0]) * 60 + Integer.valueOf(parts[1]);
        return todayStart.getTime() + (long)(minutes * 60 * 1000);
    }

    public static boolean areTimePeriodsClashing(long pStartDate1, long pEndDate1, long pStartDate2, long pEndDate2) {
        return pStartDate1 < pEndDate2 && pStartDate2 < pEndDate1;
    }

    public static long getStartOfDay(long pTimeStamp) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(pTimeStamp));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public static long getEndOfDay(long pTimeStamp) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(pTimeStamp));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTimeInMillis();
    }
}

