/*
 * Decompiled with CFR 0.152.
 */
package com.iconloop.score.token.irc2;

import com.iconloop.score.token.irc2.IRC2;
import java.math.BigInteger;
import score.Address;
import score.Context;
import score.DictDB;
import score.VarDB;
import score.annotation.EventLog;
import score.annotation.External;
import score.annotation.Optional;

public abstract class IRC2Basic
implements IRC2 {
    protected static final Address ZERO_ADDRESS = new Address(new byte[21]);
    private final VarDB<String> name = Context.newVarDB((String)"token_name", String.class);
    private final VarDB<String> symbol = Context.newVarDB((String)"token_symbol", String.class);
    private final VarDB<BigInteger> decimals = Context.newVarDB((String)"decimals", BigInteger.class);
    private final VarDB<BigInteger> totalSupply = Context.newVarDB((String)"total_supply", BigInteger.class);
    private final DictDB<Address, BigInteger> balances = Context.newDictDB((String)"balances", BigInteger.class);

    public IRC2Basic(String _name, String _symbol, int _decimals) {
        if (this.name.get() == null) {
            this.name.set((Object)this.ensureNotEmpty(_name));
            this.symbol.set((Object)this.ensureNotEmpty(_symbol));
            Context.require((_decimals >= 0 ? 1 : 0) != 0, (String)"decimals needs to be positive");
            Context.require((_decimals <= 21 ? 1 : 0) != 0, (String)"decimals needs to be equal or lower than 21");
            this.decimals.set((Object)BigInteger.valueOf(_decimals));
        }
    }

    private String ensureNotEmpty(String str) {
        Context.require((str != null && !str.trim().isEmpty() ? 1 : 0) != 0, (String)"str is null or empty");
        assert (str != null);
        return str.trim();
    }

    @Override
    @External(readonly=true)
    public String name() {
        return (String)this.name.get();
    }

    @Override
    @External(readonly=true)
    public String symbol() {
        return (String)this.symbol.get();
    }

    @Override
    @External(readonly=true)
    public BigInteger decimals() {
        return (BigInteger)this.decimals.get();
    }

    @Override
    @External(readonly=true)
    public BigInteger totalSupply() {
        return (BigInteger)this.totalSupply.getOrDefault((Object)BigInteger.ZERO);
    }

    @Override
    @External(readonly=true)
    public BigInteger balanceOf(Address _owner) {
        return (BigInteger)this.balances.getOrDefault((Object)_owner, (Object)BigInteger.ZERO);
    }

    private void safeSetBalance(Address owner, BigInteger amount) {
        this.balances.set((Object)owner, (Object)amount);
    }

    @Override
    @External
    public void transfer(Address _to, BigInteger _value, @Optional byte[] _data) {
        Address _from = Context.getCaller();
        Context.require((_value.compareTo(BigInteger.ZERO) >= 0 ? 1 : 0) != 0, (String)"_value needs to be positive");
        Context.require((this.balanceOf(_from).compareTo(_value) >= 0 ? 1 : 0) != 0, (String)"Insufficient balance");
        this.safeSetBalance(_from, this.balanceOf(_from).subtract(_value));
        this.safeSetBalance(_to, this.balanceOf(_to).add(_value));
        byte[] dataBytes = _data == null ? new byte[]{} : _data;
        this.Transfer(_from, _to, _value, dataBytes);
        if (_to.isContract()) {
            Context.call((Address)_to, (String)"tokenFallback", (Object[])new Object[]{_from, _value, dataBytes});
        }
    }

    protected void _mint(Address owner, BigInteger amount) {
        Context.require((!ZERO_ADDRESS.equals((Object)owner) ? 1 : 0) != 0, (String)"Owner address cannot be zero address");
        Context.require((amount.compareTo(BigInteger.ZERO) >= 0 ? 1 : 0) != 0, (String)"amount needs to be positive");
        this.totalSupply.set((Object)this.totalSupply().add(amount));
        this.safeSetBalance(owner, this.balanceOf(owner).add(amount));
        this.Transfer(ZERO_ADDRESS, owner, amount, "mint".getBytes());
    }

    protected void _burn(Address owner, BigInteger amount) {
        Context.require((!ZERO_ADDRESS.equals((Object)owner) ? 1 : 0) != 0, (String)"Owner address cannot be zero address");
        Context.require((amount.compareTo(BigInteger.ZERO) >= 0 ? 1 : 0) != 0, (String)"amount needs to be positive");
        Context.require((this.balanceOf(owner).compareTo(amount) >= 0 ? 1 : 0) != 0, (String)"Insufficient balance");
        this.safeSetBalance(owner, this.balanceOf(owner).subtract(amount));
        this.totalSupply.set((Object)this.totalSupply().subtract(amount));
        this.Transfer(owner, ZERO_ADDRESS, amount, "burn".getBytes());
    }

    @Override
    @EventLog(indexed=3)
    public void Transfer(Address _from, Address _to, BigInteger _value, byte[] _data) {
    }
}

