/*
 * Decompiled with CFR 0.152.
 */
package com.iconloop.score.token.irc3;

import com.iconloop.score.token.irc3.IRC3;
import com.iconloop.score.util.EnumerableMap;
import com.iconloop.score.util.IntSet;
import java.math.BigInteger;
import score.Address;
import score.Context;
import score.DictDB;
import score.VarDB;
import score.annotation.EventLog;
import score.annotation.External;

public abstract class IRC3Basic
implements IRC3 {
    protected static final Address ZERO_ADDRESS = new Address(new byte[21]);
    private final VarDB<String> name = Context.newVarDB((String)"name", String.class);
    private final VarDB<String> symbol = Context.newVarDB((String)"symbol", String.class);
    private final DictDB<Address, IntSet> holderTokens = Context.newDictDB((String)"holders", IntSet.class);
    private final EnumerableMap<BigInteger, Address> tokenOwners = new EnumerableMap<BigInteger, Address>("owners", BigInteger.class, Address.class);
    private final DictDB<BigInteger, Address> tokenApprovals = Context.newDictDB((String)"approvals", Address.class);

    public IRC3Basic(String _name, String _symbol) {
        if (this.name.get() == null) {
            this.name.set((Object)_name);
            this.symbol.set((Object)_symbol);
        }
    }

    @Override
    @External(readonly=true)
    public String name() {
        return (String)this.name.get();
    }

    @Override
    @External(readonly=true)
    public String symbol() {
        return (String)this.symbol.get();
    }

    @Override
    @External(readonly=true)
    public int balanceOf(Address _owner) {
        Context.require((!ZERO_ADDRESS.equals((Object)_owner) ? 1 : 0) != 0, (String)"Owner address cannot be zero address");
        IntSet tokens = (IntSet)this.holderTokens.get((Object)_owner);
        return tokens != null ? tokens.length() : 0;
    }

    @Override
    @External(readonly=true)
    public Address ownerOf(BigInteger _tokenId) {
        return this.tokenOwners.getOrThrow(_tokenId, "Non-existent token");
    }

    @Override
    @External(readonly=true)
    public Address getApproved(BigInteger _tokenId) {
        return (Address)this.tokenApprovals.getOrDefault((Object)_tokenId, (Object)ZERO_ADDRESS);
    }

    @Override
    @External
    public void approve(Address _to, BigInteger _tokenId) {
        Address owner = this.ownerOf(_tokenId);
        Context.require((!owner.equals((Object)_to) ? 1 : 0) != 0, (String)"Cannot approve owner");
        Context.require((boolean)owner.equals((Object)Context.getCaller()), (String)"Only owner can call this method");
        this._approve(_to, _tokenId);
    }

    private void _approve(Address to, BigInteger tokenId) {
        this.tokenApprovals.set((Object)tokenId, (Object)to);
        this.Approval(this.ownerOf(tokenId), to, tokenId);
    }

    @Override
    @External
    public void transfer(Address _to, BigInteger _tokenId) {
        Address owner = this.ownerOf(_tokenId);
        Context.require((boolean)owner.equals((Object)Context.getCaller()), (String)"Only owner can call this method");
        this._transfer(owner, _to, _tokenId);
    }

    @Override
    @External
    public void transferFrom(Address _from, Address _to, BigInteger _tokenId) {
        Address spender;
        Address owner = this.ownerOf(_tokenId);
        Context.require((owner.equals((Object)(spender = Context.getCaller())) || this.getApproved(_tokenId).equals((Object)spender) ? 1 : 0) != 0, (String)"Spender is not authorized to transfer tokens");
        this._transfer(_from, _to, _tokenId);
    }

    private void _transfer(Address from, Address to, BigInteger tokenId) {
        Context.require((boolean)this.ownerOf(tokenId).equals((Object)from), (String)"from address is not owner");
        Context.require((!to.equals((Object)ZERO_ADDRESS) ? 1 : 0) != 0, (String)"destination address cannot be zero address");
        this._approve(ZERO_ADDRESS, tokenId);
        this._removeTokenFrom(tokenId, from);
        this._addTokenTo(tokenId, to);
        this.tokenOwners.set(tokenId, to);
        this.Transfer(from, to, tokenId);
    }

    @External(readonly=true)
    public int totalSupply() {
        return this.tokenOwners.length();
    }

    @External(readonly=true)
    public BigInteger tokenByIndex(int _index) {
        return this.tokenOwners.getKey(_index);
    }

    @External(readonly=true)
    public BigInteger tokenOfOwnerByIndex(Address _owner, int _index) {
        IntSet tokens = (IntSet)this.holderTokens.get((Object)_owner);
        return tokens != null ? tokens.at(_index) : BigInteger.ZERO;
    }

    protected void _mint(Address to, BigInteger tokenId) {
        Context.require((!ZERO_ADDRESS.equals((Object)to) ? 1 : 0) != 0, (String)"Destination address cannot be zero address");
        Context.require((!this._tokenExists(tokenId) ? 1 : 0) != 0, (String)"Token already exists");
        this._addTokenTo(tokenId, to);
        this.tokenOwners.set(tokenId, to);
        this.Transfer(ZERO_ADDRESS, to, tokenId);
    }

    protected void _burn(BigInteger tokenId) {
        Address owner = this.ownerOf(tokenId);
        this._approve(ZERO_ADDRESS, tokenId);
        this._removeTokenFrom(tokenId, owner);
        this.tokenOwners.remove(tokenId);
        this.Transfer(owner, ZERO_ADDRESS, tokenId);
    }

    protected boolean _tokenExists(BigInteger tokenId) {
        return this.tokenOwners.contains(tokenId);
    }

    private void _addTokenTo(BigInteger tokenId, Address to) {
        IntSet tokens = (IntSet)this.holderTokens.get((Object)to);
        if (tokens == null) {
            tokens = new IntSet(to.toString());
            this.holderTokens.set((Object)to, (Object)tokens);
        }
        tokens.add(tokenId);
    }

    private void _removeTokenFrom(BigInteger tokenId, Address from) {
        IntSet tokens = (IntSet)this.holderTokens.get((Object)from);
        Context.require((tokens != null ? 1 : 0) != 0, (String)"tokens don't exist for this address");
        tokens.remove(tokenId);
        if (tokens.length() == 0) {
            this.holderTokens.set((Object)from, null);
        }
    }

    @Override
    @EventLog(indexed=3)
    public void Transfer(Address _from, Address _to, BigInteger _tokenId) {
    }

    @Override
    @EventLog(indexed=3)
    public void Approval(Address _owner, Address _approved, BigInteger _tokenId) {
    }
}

