/*
 * Decompiled with CFR 0.152.
 */
package com.iconloop.score.token.irc31;

import com.iconloop.score.token.irc31.IRC31;
import java.math.BigInteger;
import score.Address;
import score.BranchDB;
import score.ByteArrayObjectWriter;
import score.Context;
import score.DictDB;
import score.annotation.EventLog;
import score.annotation.External;
import score.annotation.Optional;

public abstract class IRC31Basic
implements IRC31 {
    public static final Address ZERO_ADDRESS = new Address(new byte[21]);
    private final BranchDB<BigInteger, DictDB<Address, BigInteger>> balances = Context.newBranchDB((String)"balances", BigInteger.class);
    private final BranchDB<Address, DictDB<Address, Boolean>> operatorApproval = Context.newBranchDB((String)"approval", Boolean.class);
    private final DictDB<BigInteger, String> tokenURIs = Context.newDictDB((String)"token_uri", String.class);

    @Override
    @External(readonly=true)
    public BigInteger balanceOf(Address _owner, BigInteger _id) {
        return (BigInteger)((DictDB)this.balances.at((Object)_id)).getOrDefault((Object)_owner, (Object)BigInteger.ZERO);
    }

    @Override
    @External(readonly=true)
    public BigInteger[] balanceOfBatch(Address[] _owners, BigInteger[] _ids) {
        Context.require((_owners.length == _ids.length ? 1 : 0) != 0, (String)"_owners array size must match with _ids array size");
        BigInteger[] balances = new BigInteger[_owners.length];
        for (int i = 0; i < _owners.length; ++i) {
            balances[i] = this.balanceOf(_owners[i], _ids[i]);
        }
        return balances;
    }

    @Override
    @External(readonly=true)
    public String tokenURI(BigInteger _id) {
        return (String)this.tokenURIs.get((Object)_id);
    }

    @Override
    @External
    public void transferFrom(Address _from, Address _to, BigInteger _id, BigInteger _value, @Optional byte[] _data) {
        Address caller = Context.getCaller();
        Context.require((!_to.equals((Object)ZERO_ADDRESS) ? 1 : 0) != 0, (String)"_to must be non-zero");
        Context.require((_from.equals((Object)caller) || this.isApprovedForAll(_from, caller) ? 1 : 0) != 0, (String)"Need operator approval for 3rd party transfers");
        Context.require((_value.signum() >= 0 && this.balanceOf(_from, _id).compareTo(_value) >= 0 ? 1 : 0) != 0, (String)"Insufficient funds");
        DictDB balance = (DictDB)this.balances.at((Object)_id);
        balance.set((Object)_from, (Object)this.balanceOf(_from, _id).subtract(_value));
        balance.set((Object)_to, (Object)this.balanceOf(_to, _id).add(_value));
        this.TransferSingle(caller, _from, _to, _id, _value);
        if (_to.isContract()) {
            Context.call((Address)_to, (String)"onIRC31Received", (Object[])new Object[]{caller, _from, _id, _value, _data == null ? new byte[]{} : _data});
        }
    }

    @Override
    @External
    public void transferFromBatch(Address _from, Address _to, BigInteger[] _ids, BigInteger[] _values, @Optional byte[] _data) {
        Address caller = Context.getCaller();
        Context.require((!_to.equals((Object)ZERO_ADDRESS) ? 1 : 0) != 0, (String)"_to must be non-zero");
        Context.require((_ids.length == _values.length ? 1 : 0) != 0, (String)"id/value pairs mismatch");
        Context.require((_from.equals((Object)caller) || this.isApprovedForAll(_from, caller) ? 1 : 0) != 0, (String)"Need operator approval for 3rd party transfers");
        for (int i = 0; i < _ids.length; ++i) {
            BigInteger _id = _ids[i];
            BigInteger _value = _values[i];
            Context.require((_value.signum() >= 0 && this.balanceOf(_from, _id).compareTo(_value) >= 0 ? 1 : 0) != 0, (String)"Insufficient funds");
            DictDB balance = (DictDB)this.balances.at((Object)_id);
            balance.set((Object)_from, (Object)this.balanceOf(_from, _id).subtract(_value));
            balance.set((Object)_to, (Object)this.balanceOf(_to, _id).add(_value));
        }
        this.TransferBatch(caller, _from, _to, IRC31Basic.rlpEncode(_ids), IRC31Basic.rlpEncode(_values));
        if (_to.isContract()) {
            Context.call((Address)_to, (String)"onIRC31BatchReceived", (Object[])new Object[]{caller, _from, _ids, _values, _data == null ? new byte[]{} : _data});
        }
    }

    @Override
    @External
    public void setApprovalForAll(Address _operator, boolean _approved) {
        Address caller = Context.getCaller();
        ((DictDB)this.operatorApproval.at((Object)caller)).set((Object)_operator, (Object)_approved);
        this.ApprovalForAll(caller, _operator, _approved);
    }

    @Override
    @External(readonly=true)
    public boolean isApprovedForAll(Address _owner, Address _operator) {
        return (Boolean)((DictDB)this.operatorApproval.at((Object)_owner)).getOrDefault((Object)_operator, (Object)false);
    }

    @Override
    @EventLog(indexed=3)
    public void TransferSingle(Address _operator, Address _from, Address _to, BigInteger _id, BigInteger _value) {
    }

    @Override
    @EventLog(indexed=3)
    public void TransferBatch(Address _operator, Address _from, Address _to, byte[] _ids, byte[] _values) {
    }

    @Override
    @EventLog(indexed=2)
    public void ApprovalForAll(Address _owner, Address _operator, boolean _approved) {
    }

    @Override
    @EventLog(indexed=1)
    public void URI(BigInteger _id, String _value) {
    }

    protected static byte[] rlpEncode(BigInteger[] ids) {
        Context.require((ids != null ? 1 : 0) != 0);
        ByteArrayObjectWriter writer = Context.newByteArrayObjectWriter((String)"RLPn");
        writer.beginList(ids.length);
        for (BigInteger v : ids) {
            writer.write(v);
        }
        writer.end();
        return writer.toByteArray();
    }

    protected void _setTokenURI(BigInteger _id, String _uri) {
        Context.require((_uri.length() > 0 ? 1 : 0) != 0, (String)"Uri should be set");
        this.tokenURIs.set((Object)_id, (Object)_uri);
        this.URI(_id, _uri);
    }

    private void _mintInternal(Address owner, BigInteger id, BigInteger amount) {
        Context.require((amount.compareTo(BigInteger.ZERO) > 0 ? 1 : 0) != 0, (String)"Invalid amount");
        BigInteger balance = this.balanceOf(owner, id);
        ((DictDB)this.balances.at((Object)id)).set((Object)owner, (Object)balance.add(amount));
    }

    protected void _mint(Address owner, BigInteger id, BigInteger amount) {
        this._mintInternal(owner, id, amount);
        this.TransferSingle(owner, ZERO_ADDRESS, owner, id, amount);
    }

    protected void _mintBatch(Address owner, BigInteger[] ids, BigInteger[] amounts) {
        Context.require((ids.length == amounts.length ? 1 : 0) != 0, (String)"id/amount pairs mismatch");
        for (int i = 0; i < ids.length; ++i) {
            BigInteger id = ids[i];
            BigInteger amount = amounts[i];
            this._mintInternal(owner, id, amount);
        }
        this.TransferBatch(owner, ZERO_ADDRESS, owner, IRC31Basic.rlpEncode(ids), IRC31Basic.rlpEncode(amounts));
    }

    private void _burnInternal(Address owner, BigInteger id, BigInteger amount) {
        Context.require((amount.compareTo(BigInteger.ZERO) > 0 ? 1 : 0) != 0, (String)"Invalid amount");
        BigInteger balance = this.balanceOf(owner, id);
        Context.require((balance.compareTo(amount) >= 0 ? 1 : 0) != 0, (String)"Insufficient funds");
        ((DictDB)this.balances.at((Object)id)).set((Object)owner, (Object)balance.subtract(amount));
    }

    protected void _burn(Address owner, BigInteger id, BigInteger amount) {
        this._burnInternal(owner, id, amount);
        this.TransferSingle(owner, owner, ZERO_ADDRESS, id, amount);
    }

    protected void _burnBatch(Address owner, BigInteger[] ids, BigInteger[] amounts) {
        Context.require((ids.length == amounts.length ? 1 : 0) != 0, (String)"id/amount pairs mismatch");
        for (int i = 0; i < ids.length; ++i) {
            BigInteger id = ids[i];
            BigInteger amount = amounts[i];
            this._burnInternal(owner, id, amount);
        }
        this.TransferBatch(owner, owner, ZERO_ADDRESS, IRC31Basic.rlpEncode(ids), IRC31Basic.rlpEncode(amounts));
    }
}

