/*
 * Decompiled with CFR 0.152.
 */
package com.iconloop.score.token.irc31;

import com.iconloop.score.token.irc31.IRC31Basic;
import java.math.BigInteger;
import score.Address;
import score.Context;
import score.DictDB;
import score.annotation.External;

public abstract class IRC31MintBurn
extends IRC31Basic {
    private final DictDB<BigInteger, Address> creators = Context.newDictDB((String)"creators", Address.class);

    @External
    public void mint(BigInteger _id, BigInteger _supply, String _uri) {
        Context.require((this.creators.get((Object)_id) == null ? 1 : 0) != 0, (String)"Token is already minted");
        Context.require((_supply.compareTo(BigInteger.ZERO) > 0 ? 1 : 0) != 0, (String)"Supply should be positive");
        Address caller = Context.getCaller();
        this.creators.set((Object)_id, (Object)caller);
        super._mint(caller, _id, _supply);
        super._setTokenURI(_id, _uri);
    }

    @External
    public void burn(BigInteger _id, BigInteger _amount) {
        Context.require((this.creators.get((Object)_id) != null ? 1 : 0) != 0, (String)"Invalid token id");
        Context.require((_amount.compareTo(BigInteger.ZERO) > 0 ? 1 : 0) != 0, (String)"Amount should be positive");
        super._burn(Context.getCaller(), _id, _amount);
    }

    @External
    public void setTokenURI(BigInteger _id, String _uri) {
        Context.require((boolean)Context.getCaller().equals(this.creators.get((Object)_id)), (String)"Not token creator");
        super._setTokenURI(_id, _uri);
    }
}

