/*
 * Decompiled with CFR 0.152.
 */
package com.iconloop.score.util;

import com.iconloop.score.util.EnumerableSet;
import score.Context;
import score.DictDB;

public class EnumerableMap<K, V> {
    private final EnumerableSet<K> keys;
    private final DictDB<K, V> values;

    public EnumerableMap(String id, Class<K> keyClass, Class<V> valueClass) {
        this.keys = new EnumerableSet<K>(id + "_keys", keyClass);
        this.values = Context.newDictDB((String)(id + "_values"), valueClass);
    }

    public int length() {
        return this.keys.length();
    }

    public boolean contains(K key) {
        return this.keys.contains(key);
    }

    public K getKey(int index) {
        return this.keys.at(index);
    }

    public V get(K key) {
        return (V)this.values.get(key);
    }

    public V getOrThrow(K key, String msg) {
        V entry = this.get(key);
        if (entry != null) {
            return entry;
        }
        Context.revert((String)msg);
        return null;
    }

    public void set(K key, V value) {
        this.values.set(key, value);
        this.keys.add(key);
    }

    public void remove(K key) {
        this.values.set(key, null);
        this.keys.remove(key);
    }
}

