/*
 * Decompiled with CFR 0.152.
 */
package com.iconloop.score.util;

import score.ArrayDB;
import score.Context;
import score.DictDB;

public class EnumerableSet<V> {
    private final ArrayDB<V> entries;
    private final DictDB<V, Integer> indexes;

    public EnumerableSet(String id, Class<V> valueClass) {
        this.entries = Context.newArrayDB((String)(id + "_entries"), valueClass);
        this.indexes = Context.newDictDB((String)(id + "_indexes"), Integer.class);
    }

    public int length() {
        return this.entries.size();
    }

    public V at(int index) {
        return (V)this.entries.get(index);
    }

    public boolean contains(V value) {
        return this.indexes.get(value) != null;
    }

    public Integer indexOf(V value) {
        Integer result = (Integer)this.indexes.get(value);
        if (result != null) {
            return result - 1;
        }
        return null;
    }

    public void add(V value) {
        if (!this.contains(value)) {
            this.entries.add(value);
            this.indexes.set(value, (Object)this.entries.size());
        }
    }

    public void remove(V value) {
        Integer valueIndex = (Integer)this.indexes.get(value);
        if (valueIndex != null) {
            int lastIndex = this.entries.size();
            Object lastValue = this.entries.pop();
            this.indexes.set(value, null);
            if (lastIndex != valueIndex) {
                this.entries.set(valueIndex - 1, lastValue);
                this.indexes.set(lastValue, (Object)valueIndex);
            }
        }
    }
}

