/*
 * Decompiled with CFR 0.152.
 */
package japicmp.maven;

import com.google.common.base.Optional;
import japicmp.cmp.JarArchiveComparator;
import japicmp.cmp.JarArchiveComparatorOptions;
import japicmp.config.Options;
import japicmp.maven.ConfigurationFile;
import japicmp.maven.Dependency;
import japicmp.maven.Parameter;
import japicmp.maven.Version;
import japicmp.model.AccessModifier;
import japicmp.model.JApiChangeStatus;
import japicmp.model.JApiClass;
import japicmp.output.stdout.StdoutOutputGenerator;
import japicmp.output.xml.XmlOutputGenerator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.settings.Settings;

public class JApiCmpMojo
extends AbstractMojo {
    private Version oldVersion;
    private Version newVersion;
    private Parameter parameter;
    private File projectBuildDir;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    private ArtifactRepository localRepository;
    private List<ArtifactRepository> artifactRepositories;
    private Settings settings;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File newVersionFile = this.retrieveFileFromConfiguration(this.newVersion, "newVersion");
        File oldVersionFile = this.retrieveFileFromConfiguration(this.oldVersion, "oldVersion");
        List<JApiClass> jApiClasses = this.compareArchives(newVersionFile, oldVersionFile);
        if (this.projectBuildDir != null && this.projectBuildDir.exists()) {
            try {
                File jApiCmpBuildDir = this.createJapiCmpBaseDir();
                Options options = this.createOptions();
                String diffOutput = this.generateDiffOutput(newVersionFile, oldVersionFile, jApiClasses, options);
                this.createFileAndWriteTo(diffOutput, jApiCmpBuildDir);
                this.generateXmlOutput(newVersionFile, oldVersionFile, jApiClasses, jApiCmpBuildDir, options);
                this.breakBuildIfNecessary(jApiClasses);
            }
            catch (IOException e) {
                throw new MojoFailureException(String.format("Failed to construct output directory: %s", e.getMessage()), (Throwable)e);
            }
        } else {
            throw new MojoFailureException("Could not determine the location of the build directory.");
        }
    }

    private void breakBuildIfNecessary(List<JApiClass> jApiClasses) throws MojoFailureException {
        if (this.breakBuildOnModificationsParameter()) {
            for (JApiClass jApiClass : jApiClasses) {
                if (jApiClass.getChangeStatus() == JApiChangeStatus.UNCHANGED) continue;
                throw new MojoFailureException(String.format("Breaking the build because there is at least one modified class: %s", jApiClass.getFullyQualifiedName()));
            }
        }
        if (this.breakBuildOnBinaryIncompatibleModifications()) {
            for (JApiClass jApiClass : jApiClasses) {
                if (jApiClass.getChangeStatus() == JApiChangeStatus.UNCHANGED || jApiClass.isBinaryCompatible()) continue;
                throw new MojoFailureException(String.format("Breaking the build because there is at least one modified class: %s", jApiClass.getFullyQualifiedName()));
            }
        }
    }

    private Options createOptions() throws MojoFailureException {
        Options options = new Options();
        if (this.parameter != null) {
            String packagesToInclude;
            String packagesToExclude;
            String onlyModified;
            String accessModifierArg = this.parameter.getAccessModifier();
            if (accessModifierArg != null) {
                try {
                    AccessModifier accessModifier = AccessModifier.valueOf((String)accessModifierArg.toUpperCase());
                    options.setAccessModifier(accessModifier);
                }
                catch (IllegalArgumentException e) {
                    throw new MojoFailureException(String.format("Invalid value for option accessModifier: %s. Possible values are: %s.", accessModifierArg, AccessModifier.listOfAccessModifier()));
                }
            }
            if ((onlyModified = this.parameter.getOnlyModified()) != null) {
                Boolean booleanOnlyModified = Boolean.valueOf(onlyModified);
                options.setOutputOnlyModifications(booleanOnlyModified.booleanValue());
            }
            if ((packagesToExclude = this.parameter.getPackagesToExclude()) != null) {
                try {
                    options.addPackagesExcludeFromArgument(packagesToExclude);
                }
                catch (Exception e) {
                    throw new MojoFailureException(e.getMessage());
                }
            }
            if ((packagesToInclude = this.parameter.getPackagesToInclude()) != null) {
                try {
                    options.addPackageIncludeFromArgument(packagesToInclude);
                }
                catch (Exception e) {
                    throw new MojoFailureException(e.getMessage());
                }
            }
        }
        return options;
    }

    private boolean breakBuildOnModificationsParameter() {
        boolean retVal = false;
        if (this.parameter != null) {
            retVal = Boolean.valueOf(this.parameter.getBreakBuildOnModifications());
        }
        return retVal;
    }

    private boolean breakBuildOnBinaryIncompatibleModifications() {
        boolean retVal = false;
        if (this.parameter != null) {
            retVal = Boolean.valueOf(this.parameter.getBreakBuildOnBinaryIncompatibleModifications());
        }
        return retVal;
    }

    private void createFileAndWriteTo(String diffOutput, File jApiCmpBuildDir) throws IOException, MojoFailureException {
        File outputfile = new File(jApiCmpBuildDir.getCanonicalPath() + File.separator + "japicmp.diff");
        this.writeToFile(diffOutput, outputfile);
    }

    private File createJapiCmpBaseDir() throws IOException {
        File jApiCmpBuildDir = new File(this.projectBuildDir.getCanonicalPath() + File.separator + "japicmp");
        jApiCmpBuildDir.mkdirs();
        return jApiCmpBuildDir;
    }

    private String generateDiffOutput(File newVersionFile, File oldVersionFile, List<JApiClass> jApiClasses, Options options) {
        StdoutOutputGenerator stdoutOutputGenerator = new StdoutOutputGenerator(options);
        String diffOutput = stdoutOutputGenerator.generate(oldVersionFile, newVersionFile, jApiClasses);
        this.getLog().info((CharSequence)diffOutput);
        return diffOutput;
    }

    private void generateXmlOutput(File newVersionFile, File oldVersionFile, List<JApiClass> jApiClasses, File jApiCmpBuildDir, Options options) throws IOException {
        XmlOutputGenerator xmlGenerator = new XmlOutputGenerator();
        options.setXmlOutputFile(Optional.of((Object)(jApiCmpBuildDir.getCanonicalPath() + File.separator + "japicmp.xml")));
        xmlGenerator.generate(oldVersionFile, newVersionFile, jApiClasses, options);
    }

    private List<JApiClass> compareArchives(File newVersionFile, File oldVersionFile) {
        JarArchiveComparatorOptions comparatorOptions = new JarArchiveComparatorOptions();
        JarArchiveComparator jarArchiveComparator = new JarArchiveComparator(comparatorOptions);
        return jarArchiveComparator.compare(oldVersionFile, newVersionFile);
    }

    private File retrieveFileFromConfiguration(Version version, String parameterName) throws MojoFailureException {
        if (version != null) {
            Dependency dependency = version.getDependency();
            if (dependency != null) {
                String descriptor = dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion();
                this.getLog().debug((CharSequence)(parameterName + ": " + descriptor));
                File file = this.resolveArtifact(dependency);
                if (file == null) {
                    throw new MojoFailureException(String.format("Could not resolve dependency with descriptor '%s'.", descriptor));
                }
                return file;
            }
            if (version.getFile() != null) {
                ConfigurationFile configurationFile = version.getFile();
                String path = configurationFile.getPath();
                if (path == null) {
                    throw new MojoFailureException(String.format("The path element in the configuration of the plugin is missing for %s.", parameterName));
                }
                File file = new File(path);
                if (!file.exists()) {
                    throw new MojoFailureException(String.format("The path '%s' does not point to an existing file.", path));
                }
                if (!file.isFile() || !file.canRead()) {
                    throw new MojoFailureException(String.format("The file given by path '%s' is either not a file or is not readable.", path));
                }
                return file;
            }
            throw new MojoFailureException(String.format("Missing configuration parameter 'dependency'.", new Object[0]));
        }
        throw new MojoFailureException(String.format("Missing configuration parameter: %s", parameterName));
    }

    private void writeToFile(String output, File outputfile) throws MojoFailureException, IOException {
        try (FileWriter fileWriter = null;){
            fileWriter = new FileWriter(outputfile);
            fileWriter.write(output);
        }
    }

    private File resolveArtifact(Dependency dependency) throws MojoFailureException {
        JApiCmpMojo.notNull(this.artifactRepositories, "Maven parameter artifactRepositories should be provided by maven container.");
        JApiCmpMojo.notNull(this.artifactResolver, "Maven parameter artifactResolver should be provided by maven container.");
        JApiCmpMojo.notNull(this.localRepository, "Maven parameter localRepository should be provided by maven container.");
        JApiCmpMojo.notNull(this.artifactRepositories, "Maven parameter artifactRepositories should be provided by maven container.");
        Artifact artifact = this.artifactFactory.createBuildArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), "jar");
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        request.setLocalRepository(this.localRepository);
        request.setRemoteRepositories(this.artifactRepositories);
        this.artifactResolver.resolve(request);
        return artifact.getFile();
    }

    private static <T> T notNull(T value, String msg) throws MojoFailureException {
        if (value == null) {
            throw new MojoFailureException(msg);
        }
        return value;
    }
}

