/*
 * Decompiled with CFR 0.152.
 */
package japicmp.maven;

import com.google.common.base.Joiner;
import japicmp.cli.JApiCli;
import japicmp.cmp.JApiCmpArchive;
import japicmp.cmp.JarArchiveComparator;
import japicmp.cmp.JarArchiveComparatorOptions;
import japicmp.config.Options;
import japicmp.exception.JApiCmpException;
import japicmp.maven.ConfigurationFile;
import japicmp.maven.Dependency;
import japicmp.maven.DependencyDescriptor;
import japicmp.maven.MavenParameters;
import japicmp.maven.Parameter;
import japicmp.maven.PluginParameters;
import japicmp.maven.PostAnalysisScriptExecutor;
import japicmp.maven.SkipModuleStrategy;
import japicmp.maven.Version;
import japicmp.model.AccessModifier;
import japicmp.model.JApiClass;
import japicmp.model.JApiCompatibilityChangeType;
import japicmp.model.JApiSemanticVersionLevel;
import japicmp.output.html.HtmlOutput;
import japicmp.output.html.HtmlOutputGenerator;
import japicmp.output.html.HtmlOutputGeneratorOptions;
import japicmp.output.incompatible.IncompatibleErrorOutput;
import japicmp.output.markdown.MarkdownOutputGenerator;
import japicmp.output.markdown.config.MarkdownOptions;
import japicmp.output.semver.SemverOut;
import japicmp.output.stdout.StdoutOutputGenerator;
import japicmp.output.xml.XmlOutput;
import japicmp.output.xml.XmlOutputGenerator;
import japicmp.output.xml.XmlOutputGeneratorOptions;
import japicmp.versioning.SemanticVersion;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;

@Mojo(name="cmp", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class JApiCmpMojo
extends AbstractMojo {
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private Version oldVersion;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private List<DependencyDescriptor> oldVersions;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private Version newVersion;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private List<DependencyDescriptor> newVersions;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private Parameter parameter;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private List<Dependency> dependencies;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private List<Dependency> oldClassPathDependencies;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private List<Dependency> newClassPathDependencies;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="false")
    private boolean skip;
    @org.apache.maven.plugins.annotations.Parameter(property="japicmp.skip", defaultValue="false")
    private boolean skipExec;
    @org.apache.maven.plugins.annotations.Parameter(property="japicmp.skipMarkdownReport", required=false)
    private boolean skipMarkdownReport;
    @org.apache.maven.plugins.annotations.Parameter(property="japicmp.skipXmlReport", required=false)
    private boolean skipXmlReport;
    @org.apache.maven.plugins.annotations.Parameter(property="japicmp.skipHtmlReport", required=false)
    private boolean skipHtmlReport;
    @org.apache.maven.plugins.annotations.Parameter(property="japicmp.breakBuildOnModifications", required=false)
    private boolean breakBuildOnModifications;
    @org.apache.maven.plugins.annotations.Parameter(property="japicmp.breakBuildOnBinaryIncompatibleModifications", required=false)
    private boolean breakBuildOnBinaryIncompatibleModifications;
    @org.apache.maven.plugins.annotations.Parameter(property="japicmp.breakBuildOnSourceIncompatibleModifications", required=false)
    private boolean breakBuildOnSourceIncompatibleModifications;
    @org.apache.maven.plugins.annotations.Parameter(property="japicmp.breakBuildBasedOnSemanticVersioning", required=false)
    private boolean breakBuildBasedOnSemanticVersioning;
    @org.apache.maven.plugins.annotations.Parameter(property="japicmp.breakBuildBasedOnSemanticVersioningForMajorVersionZero", required=false)
    private boolean breakBuildBasedOnSemanticVersioningForMajorVersionZero;
    @org.apache.maven.plugins.annotations.Parameter(property="project.build.directory", required=true)
    private File projectBuildDir;
    @Component
    private RepositorySystem repoSystem;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${project.remoteArtifactRepositories}")
    private List<ArtifactRepository> artifactRepositories;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${project}")
    private MavenProject mavenProject;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${mojoExecution}", readonly=true)
    private MojoExecution mojoExecution;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="(,${project.version})", readonly=true)
    private String versionRangeWithProjectVersion;
    private Options options;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenParameters mavenParameters = new MavenParameters(this.artifactRepositories, this.mavenProject, this.mojoExecution, this.versionRangeWithProjectVersion, this.repoSystem, this.repoSession, this.remoteRepos);
        PluginParameters pluginParameters = new PluginParameters(this.skipExec || this.skip, this.newVersion, this.oldVersion, this.parameter, this.dependencies, Optional.of(this.projectBuildDir), Optional.empty(), true, this.oldVersions, this.newVersions, this.oldClassPathDependencies, this.newClassPathDependencies);
        this.executeWithParameters(pluginParameters, mavenParameters);
    }

    Optional<HtmlOutput> executeWithParameters(PluginParameters pluginParameters, MavenParameters mavenParameters) throws MojoFailureException, MojoExecutionException {
        if (pluginParameters.getSkipParam()) {
            this.getLog().info((CharSequence)"Skipping execution because parameter 'skip' was set to true.");
            return Optional.empty();
        }
        if (this.isPomModuleNeedingSkip(pluginParameters, mavenParameters)) {
            this.getLog().info((CharSequence)"Skipping execution because parameter 'skipPomModules' was set to true and this is artifact is of type pom.");
            return Optional.empty();
        }
        if (this.skipModule(pluginParameters, mavenParameters)) {
            return Optional.empty();
        }
        Options options = this.getOptions(pluginParameters, mavenParameters);
        JarArchiveComparatorOptions comparatorOptions = JarArchiveComparatorOptions.of((Options)options);
        this.setUpClassPath(comparatorOptions, pluginParameters, mavenParameters);
        this.setUpOverrideCompatibilityChanges(comparatorOptions, pluginParameters);
        JarArchiveComparator jarArchiveComparator = new JarArchiveComparator(comparatorOptions);
        if (options.getNewArchives().isEmpty()) {
            this.getLog().warn((CharSequence)"Skipping execution because no new version could be resolved/found.");
            return Optional.empty();
        }
        List<JApiClass> jApiClasses = jarArchiveComparator.compare(options.getOldArchives(), options.getNewArchives());
        try {
            PostAnalysisScriptExecutor postAnalysisScriptExecutor = new PostAnalysisScriptExecutor();
            jApiClasses = postAnalysisScriptExecutor.apply(pluginParameters.getParameterParam(), jApiClasses, this.getLog());
            File jApiCmpBuildDir = this.createJapiCmpBaseDir(pluginParameters);
            SemverOut semverOut = new SemverOut(options, jApiClasses);
            String semanticVersioningInformation = semverOut.generate();
            this.generateDiffOutput(mavenParameters, pluginParameters, options, jApiClasses, jApiCmpBuildDir, semanticVersioningInformation);
            if (!this.skipMarkdownReport(pluginParameters)) {
                this.generateMarkdownOutput(mavenParameters, pluginParameters, options, jApiClasses, jApiCmpBuildDir);
            }
            if (!this.skipXmlReport(pluginParameters)) {
                XmlOutput xmlOutput = this.generateXmlOutput(jApiClasses, jApiCmpBuildDir, options, mavenParameters, pluginParameters, semanticVersioningInformation);
                if (pluginParameters.isWriteToFiles()) {
                    List filesWritten = XmlOutputGenerator.writeToFiles((Options)options, (XmlOutput)xmlOutput);
                    for (File file : filesWritten) {
                        this.getLog().info((CharSequence)("Written file '" + file.getAbsolutePath() + "'."));
                    }
                }
            }
            Optional<HtmlOutput> retVal = Optional.empty();
            if (!this.skipHtmlReport(pluginParameters)) {
                HtmlOutput htmlOutput = this.generateHtmlOutput(jApiClasses, jApiCmpBuildDir, options, mavenParameters, pluginParameters, semanticVersioningInformation);
                retVal = Optional.of(htmlOutput);
                if (pluginParameters.isWriteToFiles() && options.getHtmlOutputFile().isPresent()) {
                    Path path = Paths.get((String)options.getHtmlOutputFile().get(), new String[0]);
                    Files.write(path, htmlOutput.getHtml().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    this.getLog().info((CharSequence)("Written file '" + path + "'."));
                }
            }
            this.breakBuildIfNecessary(jApiClasses, pluginParameters.getParameterParam(), options, jarArchiveComparator);
            return retVal;
        }
        catch (IOException e) {
            throw new MojoFailureException(String.format("Failed to construct output directory: %s", e.getMessage()), (Throwable)e);
        }
    }

    private void setUpOverrideCompatibilityChanges(JarArchiveComparatorOptions comparatorOptions, PluginParameters pluginParameters) throws MojoFailureException {
        if (pluginParameters.getParameterParam() != null && pluginParameters.getParameterParam().getOverrideCompatibilityChangeParameters() != null) {
            List<Parameter.OverrideCompatibilityChangeParameter> overrideCompatibilityChangeParameters = pluginParameters.getParameterParam().getOverrideCompatibilityChangeParameters();
            for (Parameter.OverrideCompatibilityChangeParameter configChange : overrideCompatibilityChangeParameters) {
                String compatibilityChange = configChange.getCompatibilityChange();
                JApiCompatibilityChangeType foundChange = null;
                for (JApiCompatibilityChangeType change : JApiCompatibilityChangeType.values()) {
                    if (!change.name().equalsIgnoreCase(compatibilityChange)) continue;
                    foundChange = change;
                    break;
                }
                if (foundChange == null) {
                    throw new MojoFailureException("Unknown compatibility change '" + compatibilityChange + "'. Supported values: " + Joiner.on((char)',').join((Object[])JApiCompatibilityChangeType.values()));
                }
                JApiSemanticVersionLevel foundSemanticVersionLevel = foundChange.getSemanticVersionLevel();
                String semanticVersionLevel = configChange.getSemanticVersionLevel();
                for (JApiSemanticVersionLevel level : JApiSemanticVersionLevel.values()) {
                    if (!level.name().equalsIgnoreCase(semanticVersionLevel)) continue;
                    foundSemanticVersionLevel = level;
                    break;
                }
                if (foundSemanticVersionLevel == null) {
                    throw new MojoFailureException("Unknown semantic version level '" + semanticVersionLevel + "'. Supported values: " + Joiner.on((char)',').join((Object[])JApiSemanticVersionLevel.values()));
                }
                comparatorOptions.addOverrideCompatibilityChange(new JarArchiveComparatorOptions.OverrideCompatibilityChange(foundChange, configChange.isBinaryCompatible(), configChange.isSourceCompatible(), foundSemanticVersionLevel));
            }
        }
    }

    private boolean skipModule(PluginParameters pluginParameters, MavenParameters mavenParameters) {
        SkipModuleStrategy skipModuleStrategy = new SkipModuleStrategy(pluginParameters, mavenParameters, this.getLog());
        return skipModuleStrategy.skip();
    }

    private static DefaultArtifact createDefaultArtifact(MavenProject mavenProject, String version) {
        Artifact artifact = mavenProject.getArtifact();
        return JApiCmpMojo.createDefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getType(), version);
    }

    private static DefaultArtifact createDefaultArtifact(String groupId, String artifactId, String classifier, String type, String version) {
        String mappedType = type;
        if ("bundle".equals(type) || "ejb".equals(type)) {
            mappedType = "jar";
        }
        DefaultArtifact artifactVersion = new DefaultArtifact(groupId, artifactId, classifier, mappedType, version);
        return artifactVersion;
    }

    private org.eclipse.aether.artifact.Artifact getComparisonArtifact(MavenParameters mavenParameters, PluginParameters pluginParameters, ConfigurationVersion configurationVersion) throws MojoFailureException, MojoExecutionException {
        MavenProject mavenProject = mavenParameters.getMavenProject();
        DefaultArtifact artifactVersionRange = JApiCmpMojo.createDefaultArtifact(mavenProject, mavenParameters.getVersionRangeWithProjectVersion());
        VersionRangeRequest versionRangeRequest = new VersionRangeRequest((org.eclipse.aether.artifact.Artifact)artifactVersionRange, mavenParameters.getRemoteRepos(), null);
        try {
            VersionRangeResult versionRangeResult = mavenParameters.getRepoSystem().resolveVersionRange(mavenParameters.getRepoSession(), versionRangeRequest);
            List versions = versionRangeResult.getVersions();
            this.filterSnapshots(versions, pluginParameters);
            this.filterVersionPattern(versions, pluginParameters);
            if (!versions.isEmpty()) {
                DefaultArtifact artifactVersion = JApiCmpMojo.createDefaultArtifact(mavenProject, ((org.eclipse.aether.version.Version)versions.get(versions.size() - 1)).toString());
                ArtifactRequest artifactRequest = new ArtifactRequest((org.eclipse.aether.artifact.Artifact)artifactVersion, mavenParameters.getRemoteRepos(), null);
                ArtifactResult artifactResult = mavenParameters.getRepoSystem().resolveArtifact(mavenParameters.getRepoSession(), artifactRequest);
                this.processArtifactResult(artifactVersion, artifactResult, pluginParameters, configurationVersion);
                return artifactResult.getArtifact();
            }
            if (this.ignoreMissingOldVersion(pluginParameters, configurationVersion)) {
                this.getLog().warn((CharSequence)("Ignoring missing old artifact version: " + artifactVersionRange.getGroupId() + ":" + artifactVersionRange.getArtifactId()));
                return null;
            }
            throw new MojoFailureException("Could not find previous version for artifact: " + artifactVersionRange.getGroupId() + ":" + artifactVersionRange.getArtifactId());
        }
        catch (ArtifactResolutionException | VersionRangeResolutionException e) {
            this.getLog().error((CharSequence)("Failed to retrieve comparison artifact: " + e.getMessage()), e);
            throw new MojoFailureException(e.getMessage(), e);
        }
    }

    private void processArtifactResult(DefaultArtifact artifactVersion, ArtifactResult artifactResult, PluginParameters pluginParameters, ConfigurationVersion configurationVersion) throws MojoFailureException {
        if (artifactResult.getExceptions() != null && !artifactResult.getExceptions().isEmpty()) {
            List exceptions = artifactResult.getExceptions();
            for (Exception exception : exceptions) {
                this.getLog().debug((CharSequence)exception.getMessage(), (Throwable)exception);
            }
        }
        if (artifactResult.isMissing()) {
            if (this.ignoreMissingArtifact(pluginParameters, configurationVersion)) {
                this.getLog().warn((CharSequence)("Ignoring missing artifact: " + artifactResult.getArtifact()));
            } else {
                throw new MojoFailureException("Could not resolve artifact: " + artifactVersion);
            }
        }
    }

    private void filterVersionPattern(List<org.eclipse.aether.version.Version> availableVersions, PluginParameters pluginParameters) throws MojoFailureException {
        if (pluginParameters.getParameterParam() != null && pluginParameters.getParameterParam().getOldVersionPattern() != null) {
            Pattern pattern;
            String versionPattern = pluginParameters.getParameterParam().getOldVersionPattern();
            try {
                pattern = Pattern.compile(versionPattern);
            }
            catch (PatternSyntaxException e) {
                throw new MojoFailureException("Could not compile provided versionPattern '" + versionPattern + "' as regular expression: " + e.getMessage(), (Throwable)e);
            }
            Iterator<org.eclipse.aether.version.Version> versionIterator = availableVersions.iterator();
            while (versionIterator.hasNext()) {
                org.eclipse.aether.version.Version version = versionIterator.next();
                Matcher matcher = pattern.matcher(version.toString());
                if (matcher.matches()) continue;
                versionIterator.remove();
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Filtering version '" + version.toString() + "' because it does not match configured versionPattern '" + versionPattern + "'."));
            }
        } else {
            this.getLog().debug((CharSequence)"Parameter <oldVersionPattern> not configured, i.e. no version filtered.");
        }
    }

    private void filterSnapshots(List<org.eclipse.aether.version.Version> versions, PluginParameters pluginParameters) {
        if (pluginParameters.getParameterParam() != null && !pluginParameters.getParameterParam().isIncludeSnapshots()) {
            versions.removeIf(version -> version.toString() != null && version.toString().endsWith("SNAPSHOT"));
        }
    }

    private void populateArchivesListsFromParameters(PluginParameters pluginParameters, MavenParameters mavenParameters, List<JApiCmpArchive> oldArchives, List<JApiCmpArchive> newArchives) throws MojoFailureException {
        String message;
        MavenProject mavenProject;
        if (pluginParameters.getOldVersionParam() != null) {
            oldArchives.addAll(this.retrieveFileFromConfiguration(pluginParameters.getOldVersionParam(), "oldVersion", mavenParameters, pluginParameters, ConfigurationVersion.OLD));
        }
        if (pluginParameters.getOldVersionsParam() != null) {
            for (DependencyDescriptor dependencyDescriptor : pluginParameters.getOldVersionsParam()) {
                if (dependencyDescriptor == null) continue;
                oldArchives.addAll(this.retrieveFileFromConfiguration(dependencyDescriptor, "oldVersions", mavenParameters, pluginParameters, ConfigurationVersion.OLD));
            }
        }
        if (pluginParameters.getOldVersionParam() == null && pluginParameters.getOldVersionsParam() == null) {
            try {
                org.eclipse.aether.artifact.Artifact comparisonArtifact = this.getComparisonArtifact(mavenParameters, pluginParameters, ConfigurationVersion.OLD);
                if (comparisonArtifact != null && comparisonArtifact.getVersion() != null) {
                    Set<org.eclipse.aether.artifact.Artifact> artifacts = this.resolveArtifact(comparisonArtifact, mavenParameters, pluginParameters, ConfigurationVersion.OLD);
                    for (org.eclipse.aether.artifact.Artifact artifact : artifacts) {
                        File file = artifact.getFile();
                        if (file != null) {
                            oldArchives.add(new JApiCmpArchive(file, this.guessVersion(file)));
                            continue;
                        }
                        this.handleMissingArtifactFile(pluginParameters, artifact);
                    }
                }
            }
            catch (MojoExecutionException e) {
                throw new MojoFailureException("Computing and resolving comparison artifact failed: " + e.getMessage(), (Throwable)e);
            }
        }
        if (pluginParameters.getNewVersionParam() != null) {
            newArchives.addAll(this.retrieveFileFromConfiguration(pluginParameters.getNewVersionParam(), "newVersion", mavenParameters, pluginParameters, ConfigurationVersion.NEW));
        }
        if (pluginParameters.getNewVersionsParam() != null) {
            for (DependencyDescriptor dependencyDescriptor : pluginParameters.getNewVersionsParam()) {
                if (dependencyDescriptor == null) continue;
                newArchives.addAll(this.retrieveFileFromConfiguration(dependencyDescriptor, "newVersions", mavenParameters, pluginParameters, ConfigurationVersion.NEW));
            }
        }
        if (pluginParameters.getNewVersionParam() == null && pluginParameters.getNewVersionsParam() == null && (mavenProject = mavenParameters.getMavenProject()) != null && mavenProject.getArtifact() != null) {
            DefaultArtifact defaultArtifact = JApiCmpMojo.createDefaultArtifact(mavenProject, mavenProject.getVersion());
            Set<org.eclipse.aether.artifact.Artifact> artifacts = this.resolveArtifact((org.eclipse.aether.artifact.Artifact)defaultArtifact, mavenParameters, pluginParameters, ConfigurationVersion.NEW);
            for (org.eclipse.aether.artifact.Artifact artifact : artifacts) {
                File file = artifact.getFile();
                if (file != null) {
                    try (JarFile jarFile = new JarFile(file);){
                        this.getLog().debug((CharSequence)("Could open file '" + file.getAbsolutePath() + "' of artifact as jar archive: " + jarFile.getName()));
                        newArchives.add(new JApiCmpArchive(file, this.guessVersion(file)));
                    }
                    catch (IOException e) {
                        this.getLog().warn((CharSequence)("No new version specified and file '" + file.getAbsolutePath() + "' of artifact could not be opened as jar archive: " + e.getMessage()), (Throwable)e);
                    }
                    continue;
                }
                this.getLog().warn((CharSequence)("Artifact " + artifact + " does not have a file. Cannot resolve artifact automatically."));
            }
        }
        if (oldArchives.isEmpty()) {
            message = "Please provide at least one resolvable old version using one of the configuration elements <oldVersion/> or <oldVersions/>.";
            if (this.ignoreMissingArtifact(pluginParameters, ConfigurationVersion.OLD)) {
                this.getLog().warn((CharSequence)message);
            } else {
                throw new MojoFailureException(message);
            }
        }
        if (newArchives.isEmpty()) {
            message = "Please provide at least one resolvable new version using one of the configuration elements <newVersion/> or <newVersions/>.";
            if (this.ignoreMissingArtifact(pluginParameters, ConfigurationVersion.NEW)) {
                this.getLog().warn((CharSequence)message);
            } else {
                throw new MojoFailureException(message);
            }
        }
    }

    void breakBuildIfNecessary(List<JApiClass> jApiClasses, Parameter parameterParam, Options options, JarArchiveComparator jarArchiveComparator) throws MojoFailureException, MojoExecutionException {
        if (this.breakBuildBasedOnSemanticVersioning(parameterParam)) {
            options.setErrorOnSemanticIncompatibility(true);
        }
        if (this.breakBuildBasedOnSemanticVersioningForMajorVersionZero(parameterParam)) {
            options.setErrorOnSemanticIncompatibilityForMajorVersionZero(true);
        }
        if (this.breakBuildOnBinaryIncompatibleModifications(parameterParam)) {
            options.setErrorOnBinaryIncompatibility(true);
        }
        if (this.breakBuildOnSourceIncompatibleModifications(parameterParam)) {
            options.setErrorOnSourceIncompatibility(true);
        }
        if (this.breakBuildOnModificationsParameter(parameterParam)) {
            options.setErrorOnModifications(true);
        }
        if (!parameterParam.isBreakBuildIfCausedByExclusion()) {
            options.setErrorOnExclusionIncompatibility(false);
        }
        if (this.parameter != null && this.parameter.getIgnoreMissingOldVersion()) {
            options.setIgnoreMissingOldVersion(true);
        }
        if (this.parameter != null && this.parameter.getIgnoreMissingNewVersion()) {
            options.setIgnoreMissingNewVersion(true);
        }
        IncompatibleErrorOutput errorOutput = new IncompatibleErrorOutput(options, jApiClasses, jarArchiveComparator){

            protected void warn(String msg, Throwable error) {
                JApiCmpMojo.this.getLog().warn((CharSequence)msg, error);
            }
        };
        try {
            errorOutput.generate();
        }
        catch (JApiCmpException e) {
            if (e.getReason() == JApiCmpException.Reason.IncompatibleChange) {
                throw new MojoFailureException(e.getMessage());
            }
            throw new MojoExecutionException("Error while checking for incompatible changes", (Exception)((Object)e));
        }
    }

    private boolean breakBuildBasedOnSemanticVersioningForMajorVersionZero(Parameter parameterParam) {
        boolean retVal = false;
        if (this.parameter != null) {
            retVal = this.parameter.isBreakBuildBasedOnSemanticVersioningForMajorVersionZero();
        }
        return retVal || this.breakBuildBasedOnSemanticVersioningForMajorVersionZero;
    }

    Options getOptions(PluginParameters pluginParameters, MavenParameters mavenParameters) throws MojoFailureException {
        if (this.options != null) {
            return this.options;
        }
        this.options = Options.newDefault();
        this.populateArchivesListsFromParameters(pluginParameters, mavenParameters, this.options.getOldArchives(), this.options.getNewArchives());
        Parameter parameterParam = pluginParameters.getParameterParam();
        if (parameterParam != null) {
            String string;
            List<String> includes;
            String accessModifierArg = parameterParam.getAccessModifier();
            if (accessModifierArg != null) {
                try {
                    AccessModifier accessModifier = AccessModifier.valueOf((String)accessModifierArg.toUpperCase());
                    this.options.setAccessModifier(accessModifier);
                }
                catch (IllegalArgumentException e) {
                    throw new MojoFailureException(String.format("Invalid value for option accessModifier: %s. Possible values are: %s.", accessModifierArg, AccessModifier.listOfAccessModifier()), (Throwable)e);
                }
            }
            this.options.setOutputOnlyBinaryIncompatibleModifications(parameterParam.getOnlyBinaryIncompatible());
            this.options.setOutputOnlyModifications(parameterParam.getOnlyModified());
            List<String> excludes = parameterParam.getExcludes();
            if (excludes != null) {
                for (String string2 : excludes) {
                    this.options.addExcludeFromArgument(Optional.ofNullable(string2), parameterParam.isExcludeExclusively());
                }
            }
            if ((includes = parameterParam.getIncludes()) != null) {
                for (String string3 : includes) {
                    this.options.addIncludeFromArgument(Optional.ofNullable(string3), parameterParam.isIncludeExlusively());
                }
            }
            this.options.setIncludeSynthetic(parameterParam.getIncludeSynthetic());
            this.options.setIgnoreMissingClasses(parameterParam.getIgnoreMissingClasses());
            List<String> list = parameterParam.getIgnoreMissingClassesByRegularExpressions();
            if (list != null) {
                for (String ignoreMissingClassRegularExpression : list) {
                    this.options.addIgnoreMissingClassRegularExpression(ignoreMissingClassRegularExpression);
                }
            }
            if ((string = parameterParam.getHtmlStylesheet()) != null) {
                this.options.setHtmlStylesheet(Optional.of(string));
            }
            this.options.setNoAnnotations(parameterParam.getNoAnnotations());
            this.options.setReportOnlyFilename(parameterParam.isReportOnlyFilename());
            this.options.setReportOnlySummary(parameterParam.isReportOnlySummary());
        }
        return this.options;
    }

    private boolean breakBuildOnModificationsParameter(Parameter parameterParam) {
        boolean retVal = false;
        if (parameterParam != null) {
            retVal = parameterParam.getBreakBuildOnModifications();
        }
        return retVal || this.breakBuildOnModifications;
    }

    private boolean breakBuildOnBinaryIncompatibleModifications(Parameter parameterParam) {
        boolean retVal = false;
        if (parameterParam != null) {
            retVal = parameterParam.getBreakBuildOnBinaryIncompatibleModifications();
        }
        return retVal || this.breakBuildOnBinaryIncompatibleModifications;
    }

    private boolean breakBuildOnSourceIncompatibleModifications(Parameter parameter) {
        boolean retVal = false;
        if (parameter != null) {
            retVal = parameter.getBreakBuildOnSourceIncompatibleModifications();
        }
        return retVal || this.breakBuildOnSourceIncompatibleModifications;
    }

    private boolean breakBuildBasedOnSemanticVersioning(Parameter parameter) {
        boolean retVal = false;
        if (parameter != null) {
            retVal = parameter.getBreakBuildBasedOnSemanticVersioning();
        }
        return retVal || this.breakBuildBasedOnSemanticVersioning;
    }

    private File createJapiCmpBaseDir(PluginParameters pluginParameters) throws MojoFailureException {
        if (pluginParameters.getProjectBuildDirParam().isPresent()) {
            try {
                File projectBuildDirParam = pluginParameters.getProjectBuildDirParam().get();
                if (projectBuildDirParam != null) {
                    File jApiCmpBuildDir = new File(projectBuildDirParam.getCanonicalPath() + File.separator + "japicmp");
                    boolean mkdirs = jApiCmpBuildDir.mkdirs();
                    if (mkdirs || jApiCmpBuildDir.isDirectory() && jApiCmpBuildDir.canWrite()) {
                        return jApiCmpBuildDir;
                    }
                    throw new MojoFailureException(String.format("Failed to create directory '%s'.", jApiCmpBuildDir.getAbsolutePath()));
                }
                throw new MojoFailureException("Maven parameter projectBuildDir is not set.");
            }
            catch (IOException e) {
                throw new MojoFailureException("Failed to create output directory: " + e.getMessage(), (Throwable)e);
            }
        }
        if (pluginParameters.getOutputDirectory().isPresent()) {
            String outputDirectory = pluginParameters.getOutputDirectory().get();
            if (outputDirectory != null) {
                File outputDirFile = new File(outputDirectory);
                boolean mkdirs = outputDirFile.mkdirs();
                if (mkdirs || outputDirFile.isDirectory() && outputDirFile.canWrite()) {
                    return outputDirFile;
                }
                throw new MojoFailureException(String.format("Failed to create directory '%s'.", outputDirFile.getAbsolutePath()));
            }
            throw new MojoFailureException("Maven parameter outputDirectory is not set.");
        }
        throw new MojoFailureException("None of the two parameters projectBuildDir and outputDirectory are present");
    }

    private void generateDiffOutput(MavenParameters mavenParameters, PluginParameters pluginParameters, Options options, List<JApiClass> jApiClasses, File jApiCmpBuildDir, String semanticVersioningInformation) throws IOException, MojoFailureException {
        boolean skipDiffReport = false;
        if (pluginParameters.getParameterParam() != null) {
            skipDiffReport = pluginParameters.getParameterParam().isSkipDiffReport();
        }
        if (!skipDiffReport) {
            StdoutOutputGenerator stdoutOutputGenerator = new StdoutOutputGenerator(options, jApiClasses);
            String diffOutput = stdoutOutputGenerator.generate();
            diffOutput = diffOutput + "\nSemantic versioning suggestion: " + semanticVersioningInformation;
            File output = new File(jApiCmpBuildDir.getCanonicalPath() + File.separator + this.createFilename(mavenParameters) + ".diff");
            this.writeToFile(diffOutput, output);
        }
    }

    private void generateMarkdownOutput(MavenParameters mavenParameters, PluginParameters pluginParameters, Options options, List<JApiClass> jApiClasses, File jApiCmpBuildDir) throws IOException, MojoFailureException {
        MarkdownOptions mdOptions = MarkdownOptions.newDefault((Options)options);
        if (pluginParameters.getParameterParam() != null && pluginParameters.getParameterParam().getMarkdownTitle() != null) {
            mdOptions.title.report = pluginParameters.getParameterParam().getMarkdownTitle();
        }
        MarkdownOutputGenerator mdOut = new MarkdownOutputGenerator(mdOptions, jApiClasses);
        String markdown = mdOut.generate();
        File output = new File(jApiCmpBuildDir.getCanonicalPath() + File.separator + this.createFilename(mavenParameters) + ".md");
        this.writeToFile(markdown, output);
    }

    private XmlOutput generateXmlOutput(List<JApiClass> jApiClasses, File jApiCmpBuildDir, Options options, MavenParameters mavenParameters, PluginParameters pluginParameters, String semanticVersioningInformation) throws IOException {
        String filename = this.createFilename(mavenParameters);
        options.setXmlOutputFile(Optional.of(jApiCmpBuildDir.getCanonicalPath() + File.separator + filename + ".xml"));
        XmlOutputGeneratorOptions xmlOutputGeneratorOptions = new XmlOutputGeneratorOptions();
        xmlOutputGeneratorOptions.setCreateSchemaFile(true);
        xmlOutputGeneratorOptions.setSemanticVersioningInformation(semanticVersioningInformation);
        if (pluginParameters.getParameterParam() != null) {
            String optionalTitle = pluginParameters.getParameterParam().getHtmlTitle();
            xmlOutputGeneratorOptions.setTitle(optionalTitle != null ? optionalTitle : options.getDifferenceDescription());
        }
        XmlOutputGenerator xmlGenerator = new XmlOutputGenerator(jApiClasses, options, xmlOutputGeneratorOptions);
        return xmlGenerator.generate();
    }

    private HtmlOutput generateHtmlOutput(List<JApiClass> jApiClasses, File jApiCmpBuildDir, Options options, MavenParameters mavenParameters, PluginParameters pluginParameters, String semanticVersioningInformation) throws IOException {
        String filename = this.createFilename(mavenParameters);
        options.setHtmlOutputFile(Optional.of(jApiCmpBuildDir.getCanonicalPath() + File.separator + filename + ".html"));
        HtmlOutputGeneratorOptions htmlOutputGeneratorOptions = new HtmlOutputGeneratorOptions();
        htmlOutputGeneratorOptions.setSemanticVersioningInformation(semanticVersioningInformation);
        if (pluginParameters.getParameterParam() != null) {
            String title = pluginParameters.getParameterParam().getHtmlTitle();
            htmlOutputGeneratorOptions.setTitle(title != null ? title : options.getDifferenceDescription());
        }
        HtmlOutputGenerator htmlOutputGenerator = new HtmlOutputGenerator(jApiClasses, options, htmlOutputGeneratorOptions);
        return htmlOutputGenerator.generate();
    }

    private boolean skipHtmlReport(PluginParameters pluginParameters) {
        boolean skipReport = false;
        if (pluginParameters.getParameterParam() != null) {
            skipReport = pluginParameters.getParameterParam().getSkipHtmlReport();
        }
        return skipReport || this.skipHtmlReport;
    }

    private boolean skipXmlReport(PluginParameters pluginParameters) {
        boolean skipReport = false;
        if (pluginParameters.getParameterParam() != null) {
            skipReport = pluginParameters.getParameterParam().getSkipXmlReport();
        }
        return skipReport || this.skipXmlReport;
    }

    private boolean skipMarkdownReport(PluginParameters pluginParameters) {
        boolean skipReport = false;
        if (pluginParameters.getParameterParam() != null) {
            skipReport = pluginParameters.getParameterParam().getSkipMarkdownReport();
        }
        return skipReport || this.skipMarkdownReport;
    }

    private String createFilename(MavenParameters mavenParameters) {
        String filename = "japicmp";
        String executionId = mavenParameters.getMojoExecution().getExecutionId();
        if (executionId != null && !"default".equals(executionId)) {
            filename = executionId;
        }
        StringBuilder sb = new StringBuilder();
        for (char c : filename.toCharArray()) {
            if (c != '.' && !Character.isJavaIdentifierPart(c) && c != '-') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private void setUpClassPath(JarArchiveComparatorOptions comparatorOptions, PluginParameters pluginParameters, MavenParameters mavenParameters) throws MojoFailureException {
        if (pluginParameters != null) {
            if (pluginParameters.getDependenciesParam() != null) {
                if (pluginParameters.getOldClassPathDependencies() != null || pluginParameters.getNewClassPathDependencies() != null) {
                    throw new MojoFailureException("Please specify either a <dependencies/> element or the two elements <oldClassPathDependencies/> and <newClassPathDependencies/>. With <dependencies/> you can specify one common classpath for both versions and with <oldClassPathDependencies/> and <newClassPathDependencies/> a separate classpath for the new and old version.");
                }
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Element <dependencies/> found. Using " + JApiCli.ClassPathMode.ONE_COMMON_CLASSPATH));
                }
                for (Dependency dependency : pluginParameters.getDependenciesParam()) {
                    List<JApiCmpArchive> jApiCmpArchives = this.resolveDependencyToFile("dependencies", dependency, mavenParameters, true, pluginParameters, ConfigurationVersion.NEW);
                    for (JApiCmpArchive jApiCmpArchive : jApiCmpArchives) {
                        comparatorOptions.getClassPathEntries().add(jApiCmpArchive.getFile().getAbsolutePath());
                    }
                    comparatorOptions.setClassPathMode(JarArchiveComparatorOptions.ClassPathMode.ONE_COMMON_CLASSPATH);
                }
            } else if (pluginParameters.getOldClassPathDependencies() != null || pluginParameters.getNewClassPathDependencies() != null) {
                List<JApiCmpArchive> jApiCmpArchives;
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("At least one of the elements <oldClassPathDependencies/> or <newClassPathDependencies/> found. Using " + JApiCli.ClassPathMode.TWO_SEPARATE_CLASSPATHS));
                }
                if (pluginParameters.getOldClassPathDependencies() != null) {
                    for (Dependency dependency : pluginParameters.getOldClassPathDependencies()) {
                        jApiCmpArchives = this.resolveDependencyToFile("oldClassPathDependencies", dependency, mavenParameters, true, pluginParameters, ConfigurationVersion.OLD);
                        for (JApiCmpArchive archive : jApiCmpArchives) {
                            comparatorOptions.getOldClassPath().add(archive.getFile().getAbsolutePath());
                        }
                    }
                }
                if (pluginParameters.getNewClassPathDependencies() != null) {
                    for (Dependency dependency : pluginParameters.getNewClassPathDependencies()) {
                        jApiCmpArchives = this.resolveDependencyToFile("newClassPathDependencies", dependency, mavenParameters, true, pluginParameters, ConfigurationVersion.NEW);
                        for (JApiCmpArchive archive : jApiCmpArchives) {
                            comparatorOptions.getNewClassPath().add(archive.getFile().getAbsolutePath());
                        }
                    }
                }
                comparatorOptions.setClassPathMode(JarArchiveComparatorOptions.ClassPathMode.TWO_SEPARATE_CLASSPATHS);
            } else {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("None of the elements <oldClassPathDependencies/>, <newClassPathDependencies/> or <dependencies/> found. Using " + JApiCli.ClassPathMode.ONE_COMMON_CLASSPATH));
                }
                comparatorOptions.setClassPathMode(JarArchiveComparatorOptions.ClassPathMode.ONE_COMMON_CLASSPATH);
            }
        }
        this.setUpClassPathUsingMavenProject(comparatorOptions, mavenParameters, pluginParameters, ConfigurationVersion.NEW);
    }

    private void setUpClassPathUsingMavenProject(JarArchiveComparatorOptions comparatorOptions, MavenParameters mavenParameters, PluginParameters pluginParameters, ConfigurationVersion configurationVersion) throws MojoFailureException {
        MavenProject mavenProject = mavenParameters.getMavenProject();
        JApiCmpMojo.notNull(mavenProject, "Maven parameter mavenProject should be provided by maven container.");
        HashSet<String> classPathEntries = new HashSet<String>();
        for (org.eclipse.aether.artifact.Artifact artifact : this.getCompileArtifacts(mavenProject)) {
            File resolvedFile = artifact.getFile();
            if (resolvedFile != null) {
                String absolutePath = resolvedFile.getAbsolutePath();
                if (!classPathEntries.add(absolutePath) || !this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Adding to classpath: " + absolutePath));
                continue;
            }
            this.handleMissingArtifactFile(pluginParameters, artifact);
        }
        comparatorOptions.getClassPathEntries().addAll(classPathEntries);
    }

    private Set<org.eclipse.aether.artifact.Artifact> getCompileArtifacts(MavenProject mavenProject) {
        Set projectDependencies = mavenProject.getArtifacts();
        HashSet<org.eclipse.aether.artifact.Artifact> result = new HashSet<org.eclipse.aether.artifact.Artifact>(1 + projectDependencies.size());
        result.add(RepositoryUtils.toArtifact((Artifact)mavenProject.getArtifact()));
        for (Artifact dep : projectDependencies) {
            if (!dep.getArtifactHandler().isAddedToClasspath() || !"compile".equals(dep.getScope()) && !"provided".equals(dep.getScope()) && !"system".equals(dep.getScope())) continue;
            result.add(RepositoryUtils.toArtifact((Artifact)dep));
        }
        return result;
    }

    private void handleMissingArtifactFile(PluginParameters pluginParameters, org.eclipse.aether.artifact.Artifact artifact) {
        if (pluginParameters.getParameterParam().isIgnoreMissingOptionalDependency()) {
            this.getLog().info((CharSequence)("Ignoring missing optional dependency: " + this.toDescriptor(artifact)));
        } else {
            this.getLog().warn((CharSequence)("Could not resolve optional artifact: " + this.toDescriptor(artifact)));
        }
    }

    private String toDescriptor(org.eclipse.aether.artifact.Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion();
    }

    private List<JApiCmpArchive> retrieveFileFromConfiguration(DependencyDescriptor dependencyDescriptor, String parameterName, MavenParameters mavenParameters, PluginParameters pluginParameters, ConfigurationVersion configurationVersion) throws MojoFailureException {
        List<JApiCmpArchive> jApiCmpArchives;
        if (dependencyDescriptor instanceof Dependency) {
            Dependency dependency = (Dependency)dependencyDescriptor;
            jApiCmpArchives = this.resolveDependencyToFile(parameterName, dependency, mavenParameters, false, pluginParameters, configurationVersion);
        } else if (dependencyDescriptor instanceof ConfigurationFile) {
            ConfigurationFile configurationFile = (ConfigurationFile)dependencyDescriptor;
            jApiCmpArchives = this.resolveConfigurationFileToFile(parameterName, configurationFile, configurationVersion, pluginParameters);
        } else {
            throw new MojoFailureException("DependencyDescriptor is not of type <dependency/> nor of type <configurationFile/>.");
        }
        return jApiCmpArchives;
    }

    private List<JApiCmpArchive> retrieveFileFromConfiguration(Version version, String parameterName, MavenParameters mavenParameters, PluginParameters pluginParameters, ConfigurationVersion configurationVersion) throws MojoFailureException {
        if (version != null) {
            Dependency dependency = version.getDependency();
            if (dependency != null) {
                return this.resolveDependencyToFile(parameterName, dependency, mavenParameters, false, pluginParameters, configurationVersion);
            }
            if (version.getFile() != null) {
                ConfigurationFile configurationFile = version.getFile();
                return this.resolveConfigurationFileToFile(parameterName, configurationFile, configurationVersion, pluginParameters);
            }
            throw new MojoFailureException("Missing configuration parameter 'dependency'.");
        }
        throw new MojoFailureException(String.format("Missing configuration parameter: %s", parameterName));
    }

    private List<JApiCmpArchive> resolveConfigurationFileToFile(String parameterName, ConfigurationFile configurationFile, ConfigurationVersion configurationVersion, PluginParameters pluginParameters) throws MojoFailureException {
        String path = configurationFile.getPath();
        if (path == null) {
            throw new MojoFailureException(String.format("The path element in the configuration of the plugin is missing for %s.", parameterName));
        }
        File file = new File(path);
        if (!file.exists()) {
            if (!this.ignoreMissingArtifact(pluginParameters, configurationVersion)) {
                throw new MojoFailureException(String.format("The path '%s' does not point to an existing file.", path));
            }
            this.getLog().warn((CharSequence)("The file given by path '" + file.getAbsolutePath() + "' does not exist."));
        }
        if (!file.isFile() || !file.canRead()) {
            if (!this.ignoreMissingArtifact(pluginParameters, configurationVersion)) {
                throw new MojoFailureException(String.format("The file given by path '%s' is either not a file or is not readable.", path));
            }
            this.getLog().warn((CharSequence)("The file given by path '" + file.getAbsolutePath() + "' is either not a file or is not readable."));
        }
        return Collections.singletonList(new JApiCmpArchive(file, this.guessVersion(file)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<JApiCmpArchive> resolveDependencyToFile(String parameterName, Dependency dependency, MavenParameters mavenParameters, boolean transitively, PluginParameters pluginParameters, ConfigurationVersion configurationVersion) throws MojoFailureException {
        ArrayList<JApiCmpArchive> jApiCmpArchives = new ArrayList<JApiCmpArchive>();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Trying to resolve dependency '" + dependency + "' to file."));
        }
        MavenProject mavenProject = mavenParameters.getMavenProject();
        if (dependency.getSystemPath() == null) {
            String descriptor = dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion();
            this.getLog().debug((CharSequence)(parameterName + ": " + descriptor));
            String projectDescriptor = mavenProject.getGroupId() + ":" + mavenProject.getArtifactId() + ":" + mavenProject.getVersion();
            Set<org.eclipse.aether.artifact.Artifact> artifacts = descriptor.equals(projectDescriptor) ? this.getCompileArtifacts(mavenProject) : this.resolveArtifact(dependency, mavenParameters, transitively, pluginParameters, configurationVersion);
            for (org.eclipse.aether.artifact.Artifact artifact : artifacts) {
                File file = artifact.getFile();
                if (file != null) {
                    jApiCmpArchives.add(new JApiCmpArchive(file, artifact.getVersion()));
                    continue;
                }
                this.handleMissingArtifactFile(pluginParameters, artifact);
            }
            if (!jApiCmpArchives.isEmpty()) return jApiCmpArchives;
            String message = String.format("Could not resolve dependency with descriptor '%s'.", descriptor);
            if (!this.ignoreMissingArtifact(pluginParameters, configurationVersion)) throw new MojoFailureException(message);
            this.getLog().warn((CharSequence)message);
            return jApiCmpArchives;
        } else {
            String systemPath = dependency.getSystemPath();
            Pattern pattern = Pattern.compile("\\$\\{([^\\}])");
            Matcher matcher = pattern.matcher(systemPath);
            if (matcher.matches()) {
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    String property = matcher.group(i);
                    String propertyResolved = mavenParameters.getMavenProject().getProperties().getProperty(property);
                    if (propertyResolved == null) {
                        throw new MojoFailureException("Could not resolve property '" + property + "'.");
                    }
                    systemPath = systemPath.replaceAll("${" + property + "}", propertyResolved);
                }
            }
            File file = new File(systemPath);
            boolean addFile = true;
            if (!file.exists()) {
                if (!this.ignoreMissingArtifact(pluginParameters, configurationVersion)) {
                    throw new MojoFailureException("File '" + file.getAbsolutePath() + "' does not exist.");
                }
                this.getLog().warn((CharSequence)("Could not find file, but ignoreMissingOldVersion is set tot true: " + file.getAbsolutePath()));
                addFile = false;
            }
            if (!file.canRead()) {
                if (!this.ignoreMissingArtifact(pluginParameters, configurationVersion)) {
                    throw new MojoFailureException("File '" + file.getAbsolutePath() + "' is not readable.");
                }
                this.getLog().warn((CharSequence)("File is not readable, but ignoreMissingOldVersion is set tot true: " + file.getAbsolutePath()));
                addFile = false;
            }
            String version = this.guessVersion(file);
            if (!addFile) return jApiCmpArchives;
            jApiCmpArchives.add(new JApiCmpArchive(file, version));
        }
        return jApiCmpArchives;
    }

    private String guessVersion(File file) {
        String version;
        String name = file.getName();
        Optional semanticVersion = japicmp.versioning.Version.getSemanticVersion((String)name);
        String string = version = semanticVersion.isPresent() ? ((SemanticVersion)semanticVersion.get()).toString() : "n.a.";
        if (name.contains("SNAPSHOT")) {
            version = version + "-SNAPSHOT";
        }
        return version;
    }

    private boolean ignoreMissingArtifact(PluginParameters pluginParameters, ConfigurationVersion configurationVersion) {
        return this.ignoreNonResolvableArtifacts(pluginParameters) || this.ignoreMissingOldVersion(pluginParameters, configurationVersion) || this.ignoreMissingNewVersion(pluginParameters, configurationVersion);
    }

    private boolean ignoreNonResolvableArtifacts(PluginParameters pluginParameters) {
        boolean ignoreNonResolvableArtifacts = false;
        Parameter parameterParam = pluginParameters.getParameterParam();
        if (parameterParam != null) {
            String ignoreNonResolvableArtifactsAsString = parameterParam.getIgnoreNonResolvableArtifacts();
            if (Boolean.TRUE.toString().equalsIgnoreCase(ignoreNonResolvableArtifactsAsString)) {
                ignoreNonResolvableArtifacts = true;
            }
        }
        return ignoreNonResolvableArtifacts;
    }

    private boolean ignoreMissingOldVersion(PluginParameters pluginParameters, ConfigurationVersion configurationVersion) {
        return configurationVersion == ConfigurationVersion.OLD && this.ignoreMissingOldVersion(pluginParameters);
    }

    private boolean ignoreMissingNewVersion(PluginParameters pluginParameters, ConfigurationVersion configurationVersion) {
        return configurationVersion == ConfigurationVersion.NEW && this.ignoreMissingNewVersion(pluginParameters);
    }

    private boolean ignoreMissingOldVersion(PluginParameters pluginParameters) {
        boolean ignoreMissingOldVersion = false;
        if (pluginParameters.getParameterParam() != null) {
            ignoreMissingOldVersion = pluginParameters.getParameterParam().getIgnoreMissingOldVersion();
        }
        return ignoreMissingOldVersion;
    }

    private boolean ignoreMissingNewVersion(PluginParameters pluginParameters) {
        boolean ignoreMissingNewVersion = false;
        if (pluginParameters.getParameterParam() != null) {
            ignoreMissingNewVersion = pluginParameters.getParameterParam().getIgnoreMissingNewVersion();
        }
        return ignoreMissingNewVersion;
    }

    private void writeToFile(String output, File outputfile) throws MojoFailureException, IOException {
        try (OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(outputfile), Charset.forName("UTF-8"));){
            fileWriter.write(output);
            this.getLog().info((CharSequence)("Written file '" + outputfile.getAbsolutePath() + "'."));
        }
        catch (Exception e) {
            throw new MojoFailureException(String.format("Failed to write diff file: %s", e.getMessage()), (Throwable)e);
        }
    }

    private Set<org.eclipse.aether.artifact.Artifact> resolveArtifact(Dependency dependency, MavenParameters mavenParameters, boolean transitively, PluginParameters pluginParameters, ConfigurationVersion configurationVersion) throws MojoFailureException {
        JApiCmpMojo.notNull(mavenParameters.getArtifactRepositories(), "Maven parameter artifactRepositories should be provided by maven container.");
        DefaultArtifact artifact = JApiCmpMojo.createDefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), dependency.getType(), dependency.getVersion());
        return this.resolveArtifact((org.eclipse.aether.artifact.Artifact)artifact, mavenParameters, pluginParameters, configurationVersion);
    }

    private Set<org.eclipse.aether.artifact.Artifact> resolveArtifact(org.eclipse.aether.artifact.Artifact artifact, MavenParameters mavenParameters, PluginParameters pluginParameters, ConfigurationVersion configurationVersion) throws MojoFailureException {
        JApiCmpMojo.notNull(mavenParameters.getRepoSystem(), "Maven parameter repoSystem should be provided by maven container.");
        JApiCmpMojo.notNull(mavenParameters.getRepoSession(), "Maven parameter repoSession should be provided by maven container.");
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact(artifact);
        request.setRepositories(mavenParameters.getRemoteRepos());
        ArtifactResult resolutionResult = null;
        try {
            resolutionResult = mavenParameters.getRepoSystem().resolveArtifact(mavenParameters.getRepoSession(), request);
            if (resolutionResult != null) {
                if (resolutionResult.getExceptions() != null && !resolutionResult.getExceptions().isEmpty()) {
                    List exceptions = resolutionResult.getExceptions();
                    for (Exception exception : exceptions) {
                        this.getLog().debug((CharSequence)exception.getMessage(), (Throwable)exception);
                    }
                }
                if (resolutionResult.isMissing()) {
                    if (!this.ignoreMissingArtifact(pluginParameters, configurationVersion)) {
                        throw new MojoFailureException("Could not resolve artifact " + request.getArtifact());
                    }
                    this.getLog().warn((CharSequence)("Ignoring missing artifact " + request.getArtifact()));
                    return new HashSet<org.eclipse.aether.artifact.Artifact>();
                }
                return new HashSet<org.eclipse.aether.artifact.Artifact>(Collections.singletonList(resolutionResult.getArtifact()));
            }
        }
        catch (ArtifactResolutionException e) {
            if (this.ignoreMissingArtifact(pluginParameters, configurationVersion)) {
                this.getLog().warn((CharSequence)e.getMessage());
            }
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        return new HashSet<org.eclipse.aether.artifact.Artifact>();
    }

    private boolean isPomModuleNeedingSkip(PluginParameters pluginParameters, MavenParameters mavenParameters) {
        return pluginParameters.getParameterParam().getSkipPomModules() && "pom".equalsIgnoreCase(mavenParameters.getMavenProject().getArtifact().getType());
    }

    private static <T> T notNull(T value, String msg) throws MojoFailureException {
        if (value == null) {
            throw new MojoFailureException(msg);
        }
        return value;
    }

    private static enum ConfigurationVersion {
        OLD,
        NEW;

    }
}

