/*
 * Decompiled with CFR 0.152.
 */
package japicmp.maven;

import japicmp.config.Options;
import japicmp.maven.Dependency;
import japicmp.maven.DependencyDescriptor;
import japicmp.maven.JApiCmpMojo;
import japicmp.maven.MavenParameters;
import japicmp.maven.Parameter;
import japicmp.maven.PluginParameters;
import japicmp.maven.Version;
import japicmp.output.html.HtmlOutput;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="cmp-report", defaultPhase=LifecyclePhase.SITE)
public class JApiCmpReport
extends AbstractMavenReport {
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private Version oldVersion;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private List<DependencyDescriptor> oldVersions;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private Version newVersion;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private List<DependencyDescriptor> newVersions;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private Parameter parameter;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private List<Dependency> dependencies;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private List<Dependency> oldClassPathDependencies;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private List<Dependency> newClassPathDependencies;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private boolean skip;
    @org.apache.maven.plugins.annotations.Parameter(required=true, readonly=true, property="project.reporting.outputDirectory")
    private String outputDirectory;
    @Component
    private RepositorySystem repoSystem;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos;
    @org.apache.maven.plugins.annotations.Parameter(required=true, defaultValue="${localRepository}")
    private ArtifactRepository localRepository;
    @org.apache.maven.plugins.annotations.Parameter(required=true, defaultValue="${project.remoteArtifactRepositories}")
    private List<ArtifactRepository> artifactRepositories;
    @org.apache.maven.plugins.annotations.Parameter(required=true, defaultValue="${project}")
    private MavenProject mavenProject;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${mojoExecution}", readonly=true)
    private MojoExecution mojoExecution;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="(,${project.version})", readonly=true)
    private String versionRangeWithProjectVersion;
    private JApiCmpMojo mojo;
    private MavenParameters mavenParameters;
    private PluginParameters pluginParameters;

    protected void executeReport(Locale locale) throws MavenReportException {
        try {
            JApiCmpMojo mojo = this.getMojo();
            if (this.skip || this.isPomModuleNeedingSkip()) {
                this.getLog().info((CharSequence)"japicmp module set to skip");
                return;
            }
            Optional<HtmlOutput> htmlOutputOptional = mojo.executeWithParameters(this.pluginParameters, this.mavenParameters);
            if (htmlOutputOptional.isPresent()) {
                HtmlOutput htmlOutput = htmlOutputOptional.get();
                String htmlString = htmlOutput.getHtml();
                htmlString = JApiCmpReport.replaceHtmlTags(htmlString);
                this.writeToSink(htmlString);
            }
        }
        catch (Exception e) {
            String msg = "Failed to generate report: " + e.getMessage();
            Sink sink = this.getSink();
            sink.text(msg);
            sink.close();
            throw new MavenReportException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToSink(String htmlString) {
        try (Sink sink = this.getSink();){
            String htmlTitle = this.getHtmlTitle();
            if (htmlTitle != null) {
                sink.head();
                sink.title();
                sink.text(this.pluginParameters.getParameterParam().getHtmlTitle());
                sink.title_();
                sink.head_();
            }
            sink.rawText(htmlString);
        }
    }

    private static String replaceHtmlTags(String html) {
        html = html.replaceAll("</?html>", "");
        html = html.replaceAll("</?body>", "");
        html = html.replaceAll("</?head>", "");
        html = html.replaceAll("<title>[^<]*</title>", "");
        html = html.replaceAll("<META[^>]*>", "");
        return html;
    }

    private JApiCmpMojo getMojo() {
        if (this.mojo != null) {
            return this.mojo;
        }
        this.mojo = new JApiCmpMojo();
        this.mavenParameters = new MavenParameters(this.artifactRepositories, this.mavenProject, this.mojoExecution, this.versionRangeWithProjectVersion, this.repoSystem, this.repoSession, this.remoteRepos);
        this.pluginParameters = new PluginParameters(this.skip, this.newVersion, this.oldVersion, this.parameter, this.dependencies, Optional.empty(), Optional.of(this.outputDirectory), false, this.oldVersions, this.newVersions, this.oldClassPathDependencies, this.newClassPathDependencies);
        return this.mojo;
    }

    private Options getOptions() {
        try {
            return this.getMojo().getOptions(this.pluginParameters, this.mavenParameters);
        }
        catch (MojoFailureException e) {
            this.getLog().debug((CharSequence)("Failed to retrieve options: " + e.getLocalizedMessage()), (Throwable)e);
            return null;
        }
    }

    private String getHtmlTitle() {
        if (this.pluginParameters.getParameterParam() != null && this.pluginParameters.getParameterParam().getHtmlTitle() != null) {
            return this.pluginParameters.getParameterParam().getHtmlTitle();
        }
        return null;
    }

    public String getOutputName() {
        if (this.parameter != null && this.parameter.getReportLinkName() != null) {
            return this.parameter.getReportLinkName();
        }
        return "japicmp";
    }

    public String getName(Locale locale) {
        if (this.parameter != null && this.parameter.getReportLinkName() != null) {
            return this.parameter.getReportLinkName();
        }
        return "japicmp";
    }

    public String getDescription(Locale locale) {
        this.getMojo();
        if (this.skip || this.isPomModuleNeedingSkip()) {
            return "skipping report";
        }
        Options options = this.getOptions();
        if (options == null) {
            return "failed report";
        }
        return options.getDifferenceDescription();
    }

    private boolean isPomModuleNeedingSkip() {
        return this.pluginParameters.getParameterParam().getSkipPomModules() && "pom".equalsIgnoreCase(this.mavenProject.getArtifact().getType());
    }
}

