/*
 * Decompiled with CFR 0.152.
 */
package japicmp.maven;

import com.google.common.base.Joiner;
import japicmp.cli.JApiCli;
import japicmp.cmp.JApiCmpArchive;
import japicmp.cmp.JarArchiveComparator;
import japicmp.cmp.JarArchiveComparatorOptions;
import japicmp.config.Options;
import japicmp.exception.JApiCmpException;
import japicmp.maven.ConfigParameters;
import japicmp.maven.ConfigurationFile;
import japicmp.maven.Dependency;
import japicmp.maven.DependencyDescriptor;
import japicmp.maven.MavenParameters;
import japicmp.maven.PluginParameters;
import japicmp.maven.PostAnalysisScriptExecutor;
import japicmp.maven.SkipModuleStrategy;
import japicmp.maven.Version;
import japicmp.model.AccessModifier;
import japicmp.model.JApiClass;
import japicmp.model.JApiCompatibilityChangeType;
import japicmp.model.JApiSemanticVersionLevel;
import japicmp.output.html.HtmlOutput;
import japicmp.output.html.HtmlOutputGenerator;
import japicmp.output.html.HtmlOutputGeneratorOptions;
import japicmp.output.incompatible.IncompatibleErrorOutput;
import japicmp.output.markdown.MarkdownOutputGenerator;
import japicmp.output.markdown.config.MarkdownOptions;
import japicmp.output.semver.SemverOut;
import japicmp.output.stdout.StdoutOutputGenerator;
import japicmp.output.xml.XmlOutput;
import japicmp.output.xml.XmlOutputGenerator;
import japicmp.output.xml.XmlOutputGeneratorOptions;
import japicmp.util.FileHelper;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;

public class JApiCmpProcessor {
    final MavenParameters mavenParameters;
    final PluginParameters pluginParameters;
    final Log log;
    private Options options;

    public JApiCmpProcessor(PluginParameters pluginParameters, MavenParameters mavenParameters, Log log) {
        this.pluginParameters = pluginParameters;
        this.mavenParameters = mavenParameters;
        this.log = log;
    }

    public Optional<HtmlOutput> execute() throws MojoExecutionException, MojoFailureException {
        if (this.pluginParameters.skip()) {
            this.log.info((CharSequence)"japicmp skipped.");
            return Optional.empty();
        }
        if (this.skipModule()) {
            return Optional.empty();
        }
        Options options = this.getOptions();
        JarArchiveComparatorOptions comparatorOptions = JarArchiveComparatorOptions.of((Options)options);
        this.setUpClassPath(comparatorOptions);
        this.setUpOverrideCompatibilityChanges(comparatorOptions);
        JarArchiveComparator jarArchiveComparator = new JarArchiveComparator(comparatorOptions);
        if (options.getNewArchives().isEmpty()) {
            this.log.warn((CharSequence)"Skipping execution because no new version could be resolved/found.");
            return Optional.empty();
        }
        List jApiClasses = jarArchiveComparator.compare(options.getOldArchives(), options.getNewArchives());
        try {
            PostAnalysisScriptExecutor postAnalysisScriptExecutor = new PostAnalysisScriptExecutor();
            postAnalysisScriptExecutor.apply(this.pluginParameters.parameter(), jApiClasses, this.log);
            File jApiCmpBuildDir = this.createJApiCmpBaseDir();
            SemverOut semverOut = new SemverOut(options, jApiClasses);
            String semanticVersioningInformation = semverOut.generate();
            if (!this.skipDiffReport()) {
                this.generateDiffOutput(options, jApiClasses, jApiCmpBuildDir, semanticVersioningInformation);
            }
            if (!this.skipMarkdownReport()) {
                this.generateMarkdownOutput(jApiClasses, jApiCmpBuildDir);
            }
            if (!this.skipXmlReport()) {
                this.generateXmlOutput(jApiClasses, jApiCmpBuildDir, semanticVersioningInformation);
            }
            Optional<HtmlOutput> retVal = Optional.empty();
            if (!this.skipHtmlReport()) {
                retVal = Optional.of(this.generateHtmlOutput(jApiClasses, jApiCmpBuildDir, semanticVersioningInformation));
            }
            this.breakBuildIfNecessary(jApiClasses, this.pluginParameters.parameter(), options, jarArchiveComparator);
            return retVal;
        }
        catch (IOException e) {
            throw new MojoFailureException(String.format("Failed to construct output directory: %s", e.getMessage()), (Throwable)e);
        }
    }

    private void setUpOverrideCompatibilityChanges(JarArchiveComparatorOptions comparatorOptions) throws MojoFailureException {
        if (this.pluginParameters.parameter().getOverrideCompatibilityChangeParameters() != null) {
            List<ConfigParameters.OverrideCompatibilityChangeParameter> overrideCompatibilityChangeParameters = this.pluginParameters.parameter().getOverrideCompatibilityChangeParameters();
            for (ConfigParameters.OverrideCompatibilityChangeParameter configChange : overrideCompatibilityChangeParameters) {
                String compatibilityChange = configChange.getCompatibilityChange();
                JApiCompatibilityChangeType foundChange = null;
                for (JApiCompatibilityChangeType change : JApiCompatibilityChangeType.values()) {
                    if (!change.name().equalsIgnoreCase(compatibilityChange)) continue;
                    foundChange = change;
                    break;
                }
                if (foundChange == null) {
                    throw new MojoFailureException("Unknown compatibility change '" + compatibilityChange + "'. Supported values: " + Joiner.on((char)',').join((Object[])JApiCompatibilityChangeType.values()));
                }
                String semanticVersionLevel = configChange.getSemanticVersionLevel();
                JApiSemanticVersionLevel foundSemanticVersionLevel = foundChange.getSemanticVersionLevel();
                for (JApiSemanticVersionLevel level : JApiSemanticVersionLevel.values()) {
                    if (!level.name().equalsIgnoreCase(semanticVersionLevel)) continue;
                    foundSemanticVersionLevel = level;
                    break;
                }
                if (foundSemanticVersionLevel == null) {
                    throw new MojoFailureException("Unknown semantic version level '" + semanticVersionLevel + "'. Supported values: " + Joiner.on((char)',').join((Object[])JApiSemanticVersionLevel.values()));
                }
                comparatorOptions.addOverrideCompatibilityChange(new JarArchiveComparatorOptions.OverrideCompatibilityChange(foundChange, configChange.isBinaryCompatible(), configChange.isSourceCompatible(), foundSemanticVersionLevel));
            }
        }
    }

    private DefaultArtifact createDefaultArtifact(MavenProject mavenProject, String version) {
        Artifact artifact = mavenProject.getArtifact();
        return this.createDefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getType(), version);
    }

    private DefaultArtifact createDefaultArtifact(String groupId, String artifactId, String classifier, String type, String version) {
        String mappedType = type;
        if ("bundle".equals(type) || "ejb".equals(type)) {
            mappedType = "jar";
        }
        return new DefaultArtifact(groupId, artifactId, classifier, mappedType, version);
    }

    private org.eclipse.aether.artifact.Artifact getComparisonArtifact() throws MojoFailureException, MojoExecutionException {
        MavenProject mavenProject = this.mavenParameters.mavenProject();
        DefaultArtifact artifactVersionRange = this.createDefaultArtifact(mavenProject, this.mavenParameters.versionRangeWithProjectVersion());
        VersionRangeRequest versionRangeRequest = new VersionRangeRequest((org.eclipse.aether.artifact.Artifact)artifactVersionRange, this.mavenParameters.remoteRepos(), null);
        try {
            this.log.debug((CharSequence)("Trying version range: " + versionRangeRequest));
            VersionRangeResult versionRangeResult = this.mavenParameters.repoSystem().resolveVersionRange(this.mavenParameters.repoSession(), versionRangeRequest);
            this.log.debug((CharSequence)("Version range result: " + versionRangeRequest));
            List versions = versionRangeResult.getVersions();
            this.filterSnapshots(versions);
            this.filterVersionPattern(versions);
            this.log.debug((CharSequence)("Version range after filtering: " + versions));
            if (!versions.isEmpty()) {
                DefaultArtifact artifactVersion = this.createDefaultArtifact(mavenProject, ((org.eclipse.aether.version.Version)versions.get(versions.size() - 1)).toString());
                ArtifactRequest artifactRequest = new ArtifactRequest((org.eclipse.aether.artifact.Artifact)artifactVersion, this.mavenParameters.remoteRepos(), null);
                ArtifactResult artifactResult = this.mavenParameters.repoSystem().resolveArtifact(this.mavenParameters.repoSession(), artifactRequest);
                this.processArtifactResult(artifactVersion, artifactResult);
                return artifactResult.getArtifact();
            }
            if (this.ignoreMissingOldVersion(ConfigurationVersion.OLD)) {
                this.log.warn((CharSequence)("Ignoring missing old artifact version: " + artifactVersionRange.getGroupId() + ":" + artifactVersionRange.getArtifactId()));
                return null;
            }
            throw new MojoFailureException("Could not find previous version for artifact: " + artifactVersionRange.getGroupId() + ":" + artifactVersionRange.getArtifactId());
        }
        catch (ArtifactResolutionException | VersionRangeResolutionException e) {
            this.log.error((CharSequence)("Failed to retrieve comparison artifact: " + e.getMessage()), e);
            throw new MojoFailureException(e.getMessage(), e);
        }
    }

    private void processArtifactResult(DefaultArtifact artifactVersion, ArtifactResult artifactResult) throws MojoFailureException {
        if (artifactResult.getExceptions() != null && !artifactResult.getExceptions().isEmpty()) {
            List exceptions = artifactResult.getExceptions();
            for (Exception exception : exceptions) {
                this.log.debug((CharSequence)exception.getMessage(), (Throwable)exception);
            }
        }
        if (artifactResult.isMissing()) {
            if (this.ignoreMissingArtifact(ConfigurationVersion.OLD)) {
                this.log.warn((CharSequence)("Ignoring missing artifact: " + artifactResult.getArtifact()));
            } else {
                throw new MojoFailureException("Could not resolve artifact: " + artifactVersion);
            }
        }
    }

    private void filterVersionPattern(List<org.eclipse.aether.version.Version> availableVersions) throws MojoFailureException {
        if (this.pluginParameters.parameter().getOldVersionPattern() != null) {
            Pattern pattern;
            String versionPattern = this.pluginParameters.parameter().getOldVersionPattern();
            try {
                pattern = Pattern.compile(versionPattern);
            }
            catch (PatternSyntaxException e) {
                throw new MojoFailureException("Could not compile provided versionPattern '" + versionPattern + "' as regular expression: " + e.getMessage(), (Throwable)e);
            }
            Iterator<org.eclipse.aether.version.Version> versionIterator = availableVersions.iterator();
            while (versionIterator.hasNext()) {
                org.eclipse.aether.version.Version version = versionIterator.next();
                Matcher matcher = pattern.matcher(version.toString());
                if (matcher.matches()) continue;
                versionIterator.remove();
                this.log.debug((CharSequence)("Filtering version '" + version + "' because it does not match configured versionPattern '" + versionPattern + "'."));
            }
        } else {
            this.log.debug((CharSequence)"Parameter <oldVersionPattern> not configured, i.e. no version filtered.");
        }
    }

    private void filterSnapshots(List<org.eclipse.aether.version.Version> versions) {
        if (!this.pluginParameters.parameter().isIncludeSnapshots()) {
            versions.removeIf(version -> version.toString() != null && version.toString().endsWith("SNAPSHOT"));
        }
    }

    private void populateArchivesListsFromParameters(List<JApiCmpArchive> oldArchives, List<JApiCmpArchive> newArchives) throws MojoFailureException {
        String message;
        MavenProject mavenProject;
        if (this.pluginParameters.oldVersion() != null) {
            oldArchives.addAll(this.retrieveFileFromConfiguration(this.pluginParameters.oldVersion(), "oldVersion", ConfigurationVersion.OLD));
        }
        if (this.pluginParameters.oldVersions() != null) {
            for (DependencyDescriptor dependencyDescriptor : this.pluginParameters.oldVersions()) {
                if (dependencyDescriptor == null) continue;
                oldArchives.addAll(this.retrieveFileFromConfiguration(dependencyDescriptor, "oldVersions", ConfigurationVersion.OLD));
            }
        }
        if (this.pluginParameters.oldVersion() == null && this.pluginParameters.oldVersions() == null) {
            try {
                org.eclipse.aether.artifact.Artifact comparisonArtifact = this.getComparisonArtifact();
                if (comparisonArtifact != null && comparisonArtifact.getVersion() != null) {
                    Set<org.eclipse.aether.artifact.Artifact> artifacts = this.resolveArtifact(comparisonArtifact, ConfigurationVersion.OLD);
                    for (org.eclipse.aether.artifact.Artifact artifact : artifacts) {
                        File file = artifact.getFile();
                        if (file != null) {
                            oldArchives.add(new JApiCmpArchive(file, FileHelper.guessVersion((File)file)));
                            continue;
                        }
                        this.handleMissingArtifactFile(artifact);
                    }
                }
            }
            catch (MojoExecutionException e) {
                throw new MojoFailureException("Computing and resolving comparison artifact failed: " + e.getMessage(), (Throwable)e);
            }
        }
        if (this.pluginParameters.newVersion() != null) {
            newArchives.addAll(this.retrieveFileFromConfiguration(this.pluginParameters.newVersion(), "newVersion", ConfigurationVersion.NEW));
        }
        if (this.pluginParameters.newVersions() != null) {
            for (DependencyDescriptor dependencyDescriptor : this.pluginParameters.newVersions()) {
                if (dependencyDescriptor == null) continue;
                newArchives.addAll(this.retrieveFileFromConfiguration(dependencyDescriptor, "newVersions", ConfigurationVersion.NEW));
            }
        }
        if (this.pluginParameters.newVersion() == null && this.pluginParameters.newVersions() == null && (mavenProject = this.mavenParameters.mavenProject()) != null && mavenProject.getArtifact() != null) {
            DefaultArtifact defaultArtifact = this.createDefaultArtifact(mavenProject, mavenProject.getVersion());
            Set<org.eclipse.aether.artifact.Artifact> artifacts = this.resolveArtifact((org.eclipse.aether.artifact.Artifact)defaultArtifact, ConfigurationVersion.NEW);
            for (org.eclipse.aether.artifact.Artifact artifact : artifacts) {
                File file = artifact.getFile();
                if (file != null) {
                    try (JarFile jarFile = new JarFile(file);){
                        this.log.debug((CharSequence)("Could open file '" + file.getAbsolutePath() + "' of artifact as jar archive: " + jarFile.getName()));
                        newArchives.add(new JApiCmpArchive(file, FileHelper.guessVersion((File)file)));
                    }
                    catch (IOException e) {
                        this.log.warn((CharSequence)("No new version specified and file '" + file.getAbsolutePath() + "' of artifact could not be opened as jar archive: " + e.getMessage()), (Throwable)e);
                    }
                    continue;
                }
                this.log.warn((CharSequence)("Artifact " + artifact + " does not have a file. Cannot resolve artifact automatically."));
            }
        }
        if (oldArchives.isEmpty()) {
            message = "Please provide at least one resolvable old version using one of the configuration elements <oldVersion/> or <oldVersions/>.";
            if (this.ignoreMissingArtifact(ConfigurationVersion.OLD)) {
                this.log.warn((CharSequence)message);
            } else {
                throw new MojoFailureException(message);
            }
        }
        if (newArchives.isEmpty()) {
            message = "Please provide at least one resolvable new version using one of the configuration elements <newVersion/> or <newVersions/>.";
            if (this.ignoreMissingArtifact(ConfigurationVersion.NEW)) {
                this.log.warn((CharSequence)message);
            } else {
                throw new MojoFailureException(message);
            }
        }
    }

    void breakBuildIfNecessary(List<JApiClass> jApiClasses, ConfigParameters parameterParam, Options options, JarArchiveComparator jarArchiveComparator) throws MojoFailureException, MojoExecutionException {
        if (this.breakBuildBasedOnSemanticVersioning(parameterParam)) {
            options.setErrorOnSemanticIncompatibility(true);
        }
        if (this.breakBuildBasedOnSemanticVersioningForMajorVersionZero(parameterParam)) {
            options.setErrorOnSemanticIncompatibilityForMajorVersionZero(true);
        }
        if (this.breakBuildOnBinaryIncompatibleModifications(parameterParam)) {
            options.setErrorOnBinaryIncompatibility(true);
        }
        if (this.breakBuildOnSourceIncompatibleModifications(parameterParam)) {
            options.setErrorOnSourceIncompatibility(true);
        }
        if (this.breakBuildOnModifications(parameterParam)) {
            options.setErrorOnModifications(true);
        }
        if (!parameterParam.isBreakBuildIfCausedByExclusion()) {
            options.setErrorOnExclusionIncompatibility(false);
        }
        if (this.pluginParameters.parameter().getIgnoreMissingOldVersion()) {
            options.setIgnoreMissingOldVersion(true);
        }
        if (this.pluginParameters.parameter().getIgnoreMissingNewVersion()) {
            options.setIgnoreMissingNewVersion(true);
        }
        IncompatibleErrorOutput errorOutput = new IncompatibleErrorOutput(options, jApiClasses, jarArchiveComparator){

            protected void warn(String msg, Throwable error) {
                JApiCmpProcessor.this.log.warn((CharSequence)msg, error);
            }
        };
        try {
            errorOutput.generate();
        }
        catch (JApiCmpException e) {
            if (e.getReason() == JApiCmpException.Reason.IncompatibleChange) {
                throw new MojoFailureException(e.getMessage());
            }
            throw new MojoExecutionException("Error while checking for incompatible changes", (Exception)((Object)e));
        }
    }

    Options getOptions() throws MojoFailureException {
        if (this.options != null) {
            return this.options;
        }
        this.options = Options.newDefault();
        this.populateArchivesListsFromParameters(this.options.getOldArchives(), this.options.getNewArchives());
        ConfigParameters parameterParam = this.pluginParameters.parameter();
        if (parameterParam != null) {
            String string;
            List<String> includes;
            String accessModifierArg = parameterParam.getAccessModifier();
            if (accessModifierArg != null) {
                try {
                    AccessModifier accessModifier = AccessModifier.valueOf((String)accessModifierArg.toUpperCase());
                    this.options.setAccessModifier(accessModifier);
                }
                catch (IllegalArgumentException e) {
                    throw new MojoFailureException(String.format("Invalid value for option accessModifier: %s. Possible values are: %s.", accessModifierArg, AccessModifier.listOfAccessModifier()), (Throwable)e);
                }
            }
            this.options.setOutputOnlyBinaryIncompatibleModifications(parameterParam.getOnlyBinaryIncompatible());
            this.options.setOutputOnlyModifications(parameterParam.getOnlyModified());
            List<String> excludes = parameterParam.getExcludes();
            if (excludes != null) {
                for (String string2 : excludes) {
                    this.options.addExcludeFromArgument(Optional.ofNullable(string2), parameterParam.isExcludeExclusively());
                }
            }
            if ((includes = parameterParam.getIncludes()) != null) {
                for (String string3 : includes) {
                    this.options.addIncludeFromArgument(Optional.ofNullable(string3), parameterParam.isIncludeExlusively());
                }
            }
            this.options.setIncludeSynthetic(parameterParam.getIncludeSynthetic());
            this.options.setIgnoreMissingClasses(parameterParam.getIgnoreMissingClasses());
            List<String> list = parameterParam.getIgnoreMissingClassesByRegularExpressions();
            if (list != null) {
                for (String ignoreMissingClassRegularExpression : list) {
                    this.options.addIgnoreMissingClassRegularExpression(ignoreMissingClassRegularExpression);
                }
            }
            if ((string = parameterParam.getHtmlStylesheet()) != null) {
                this.options.setHtmlStylesheet(Optional.of(string));
            }
            this.options.setNoAnnotations(parameterParam.getNoAnnotations());
            this.options.setReportOnlyFilename(parameterParam.isReportOnlyFilename());
            this.options.setReportOnlySummary(parameterParam.isReportOnlySummary());
        }
        return this.options;
    }

    boolean breakBuildOnModifications(ConfigParameters params) {
        return this.pluginParameters.breakBuild().onModifications() | params.getBreakBuildOnModifications();
    }

    boolean breakBuildOnBinaryIncompatibleModifications(ConfigParameters params) {
        return this.pluginParameters.breakBuild().onBinaryIncompatibleModifications() | params.getBreakBuildOnBinaryIncompatibleModifications();
    }

    boolean breakBuildOnSourceIncompatibleModifications(ConfigParameters params) {
        return this.pluginParameters.breakBuild().onSourceIncompatibleModifications() | params.getBreakBuildOnSourceIncompatibleModifications();
    }

    boolean breakBuildBasedOnSemanticVersioning(ConfigParameters params) {
        return this.pluginParameters.breakBuild().onSemanticVersioning() | params.getBreakBuildBasedOnSemanticVersioning();
    }

    boolean breakBuildBasedOnSemanticVersioningForMajorVersionZero(ConfigParameters params) {
        return this.pluginParameters.breakBuild().onSemanticVersioningForMajorVersionZero() | params.isBreakBuildBasedOnSemanticVersioningForMajorVersionZero();
    }

    File createJApiCmpBaseDir() throws MojoFailureException {
        File baseDir;
        try {
            if (this.pluginParameters.outputDirectory() != null) {
                baseDir = this.pluginParameters.outputDirectory();
            } else {
                File projectBuildDirParam = this.pluginParameters.projectBuildDir();
                baseDir = new File(projectBuildDirParam.getCanonicalPath() + File.separator + "japicmp");
            }
            boolean madeDir = true;
            if (!baseDir.exists()) {
                madeDir = baseDir.mkdirs();
            }
            if (!(madeDir && baseDir.isDirectory() && baseDir.canWrite())) {
                throw new IOException("mkDirs failed");
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to create output directory: " + e.getMessage(), (Throwable)e);
        }
        return baseDir;
    }

    private void generateDiffOutput(Options options, List<JApiClass> jApiClasses, File jApiCmpBuildDir, String semanticVersioningInformation) throws IOException, MojoFailureException {
        StdoutOutputGenerator stdoutOutputGenerator = new StdoutOutputGenerator(options, jApiClasses);
        String diffOutput = stdoutOutputGenerator.generate();
        diffOutput = diffOutput + "\nSemantic versioning suggestion: " + semanticVersioningInformation;
        File output = new File(jApiCmpBuildDir.getCanonicalPath() + File.separator + this.createFilename() + ".diff");
        this.writeToFile(diffOutput, output);
    }

    private void generateMarkdownOutput(List<JApiClass> jApiClasses, File jApiCmpBuildDir) throws IOException, MojoFailureException {
        if (this.pluginParameters.isWriteToFiles()) {
            MarkdownOptions mdOptions = MarkdownOptions.newDefault((Options)this.options);
            if (this.pluginParameters.parameter().getMarkdownTitle() != null) {
                mdOptions.title.report = this.pluginParameters.parameter().getMarkdownTitle();
            }
            MarkdownOutputGenerator mdOut = new MarkdownOutputGenerator(mdOptions, jApiClasses);
            String markdown = mdOut.generate();
            File output = new File(jApiCmpBuildDir.getCanonicalPath() + File.separator + this.createFilename() + ".md");
            this.writeToFile(markdown, output);
        }
    }

    private void generateXmlOutput(List<JApiClass> jApiClasses, File jApiCmpBuildDir, String semanticVersioningInformation) throws IOException {
        if (this.pluginParameters.isWriteToFiles()) {
            XmlOutput xmlOutput = this.createXmlOutput(jApiClasses, jApiCmpBuildDir, semanticVersioningInformation);
            List filesWritten = XmlOutputGenerator.writeToFiles((Options)this.options, (XmlOutput)xmlOutput);
            for (File file : filesWritten) {
                this.log.info((CharSequence)("Created file '" + file.getAbsolutePath() + "'."));
            }
        }
    }

    private XmlOutput createXmlOutput(List<JApiClass> jApiClasses, File jApiCmpBuildDir, String semanticVersioningInformation) throws IOException {
        String filename = this.createFilename();
        this.options.setXmlOutputFile(Optional.of(jApiCmpBuildDir.getCanonicalPath() + File.separator + filename + ".xml"));
        XmlOutputGeneratorOptions xmlOutputGeneratorOptions = new XmlOutputGeneratorOptions();
        xmlOutputGeneratorOptions.setCreateSchemaFile(true);
        xmlOutputGeneratorOptions.setSemanticVersioningInformation(semanticVersioningInformation);
        String optionalTitle = this.pluginParameters.parameter().getHtmlTitle();
        xmlOutputGeneratorOptions.setTitle(optionalTitle != null ? optionalTitle : this.options.getDifferenceDescription());
        XmlOutputGenerator xmlGenerator = new XmlOutputGenerator(jApiClasses, this.options, xmlOutputGeneratorOptions);
        return xmlGenerator.generate();
    }

    private HtmlOutput generateHtmlOutput(List<JApiClass> jApiClasses, File jApiCmpBuildDir, String semanticVersioningInformation) throws IOException {
        HtmlOutput htmlOutput = this.createHtmlOutput(jApiClasses, jApiCmpBuildDir, semanticVersioningInformation);
        if (this.pluginParameters.isWriteToFiles() && this.options.getHtmlOutputFile().isPresent()) {
            Path path = Paths.get((String)this.options.getHtmlOutputFile().get(), new String[0]);
            Files.write(path, htmlOutput.getHtml().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            this.log.info((CharSequence)("Written file '" + path + "'."));
        }
        return htmlOutput;
    }

    private HtmlOutput createHtmlOutput(List<JApiClass> jApiClasses, File jApiCmpBuildDir, String semanticVersioningInformation) throws IOException {
        String filename = this.createFilename();
        this.options.setHtmlOutputFile(Optional.of(jApiCmpBuildDir.getCanonicalPath() + File.separator + filename + ".html"));
        HtmlOutputGeneratorOptions htmlOutputGeneratorOptions = new HtmlOutputGeneratorOptions();
        htmlOutputGeneratorOptions.setSemanticVersioningInformation(semanticVersioningInformation);
        String title = this.pluginParameters.parameter().getHtmlTitle();
        htmlOutputGeneratorOptions.setTitle(title != null ? title : this.options.getDifferenceDescription());
        HtmlOutputGenerator htmlOutputGenerator = new HtmlOutputGenerator(jApiClasses, this.options, htmlOutputGeneratorOptions);
        return htmlOutputGenerator.generate();
    }

    boolean skipModule() {
        SkipModuleStrategy skipModuleStrategy = new SkipModuleStrategy(this.pluginParameters, this.mavenParameters, this.log);
        return skipModuleStrategy.skip();
    }

    boolean skipDiffReport() {
        return this.pluginParameters.skipReport().diffReport() | this.pluginParameters.parameter().skipDiffReport();
    }

    boolean skipHtmlReport() {
        return this.pluginParameters.skipReport().htmlReport() | this.pluginParameters.parameter().skipHtmlReport();
    }

    boolean skipMarkdownReport() {
        return this.pluginParameters.skipReport().markdownReport() | this.pluginParameters.parameter().skipMarkdownReport();
    }

    boolean skipXmlReport() {
        return this.pluginParameters.skipReport().xmlReport() | this.pluginParameters.parameter().skipXmlReport();
    }

    private String createFilename() {
        String filename = "japicmp";
        String executionId = this.mavenParameters.mojoExecution().getExecutionId();
        if (executionId != null && !"default".equals(executionId)) {
            filename = executionId;
        }
        StringBuilder sb = new StringBuilder();
        for (char c : filename.toCharArray()) {
            if (c != '.' && !Character.isJavaIdentifierPart(c) && c != '-') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private void setUpClassPath(JarArchiveComparatorOptions comparatorOptions) throws MojoFailureException {
        if (this.pluginParameters != null) {
            if (this.pluginParameters.dependencies() != null) {
                if (this.pluginParameters.oldClassPathDependencies() != null || this.pluginParameters.newClassPathDependencies() != null) {
                    throw new MojoFailureException("Please specify either a <dependencies/> element or the two elements <oldClassPathDependencies/> and <newClassPathDependencies/>. With <dependencies/> you can specify one common classpath for both versions and with <oldClassPathDependencies/> and <newClassPathDependencies/> a separate classpath for the new and old version.");
                }
                this.log.debug((CharSequence)("Element <dependencies/> found. Using " + JApiCli.ClassPathMode.ONE_COMMON_CLASSPATH));
                for (Dependency dependency : this.pluginParameters.dependencies()) {
                    List<JApiCmpArchive> jApiCmpArchives = this.resolveDependencyToFile("dependencies", dependency, ConfigurationVersion.NEW);
                    for (JApiCmpArchive jApiCmpArchive : jApiCmpArchives) {
                        comparatorOptions.getClassPathEntries().add(jApiCmpArchive.getFile().getAbsolutePath());
                    }
                    comparatorOptions.setClassPathMode(JarArchiveComparatorOptions.ClassPathMode.ONE_COMMON_CLASSPATH);
                }
            } else if (this.pluginParameters.oldClassPathDependencies() != null || this.pluginParameters.newClassPathDependencies() != null) {
                List<JApiCmpArchive> jApiCmpArchives;
                this.log.debug((CharSequence)("At least one of the elements <oldClassPathDependencies/> or <newClassPathDependencies/> found. Using " + JApiCli.ClassPathMode.TWO_SEPARATE_CLASSPATHS));
                if (this.pluginParameters.oldClassPathDependencies() != null) {
                    for (Dependency dependency : this.pluginParameters.oldClassPathDependencies()) {
                        jApiCmpArchives = this.resolveDependencyToFile("oldClassPathDependencies", dependency, ConfigurationVersion.OLD);
                        for (JApiCmpArchive archive : jApiCmpArchives) {
                            comparatorOptions.getOldClassPath().add(archive.getFile().getAbsolutePath());
                        }
                    }
                }
                if (this.pluginParameters.newClassPathDependencies() != null) {
                    for (Dependency dependency : this.pluginParameters.newClassPathDependencies()) {
                        jApiCmpArchives = this.resolveDependencyToFile("newClassPathDependencies", dependency, ConfigurationVersion.NEW);
                        for (JApiCmpArchive archive : jApiCmpArchives) {
                            comparatorOptions.getNewClassPath().add(archive.getFile().getAbsolutePath());
                        }
                    }
                }
                comparatorOptions.setClassPathMode(JarArchiveComparatorOptions.ClassPathMode.TWO_SEPARATE_CLASSPATHS);
            } else {
                this.log.debug((CharSequence)("None of the elements <oldClassPathDependencies/>, <newClassPathDependencies/> or <dependencies/> found. Using " + JApiCli.ClassPathMode.ONE_COMMON_CLASSPATH));
                comparatorOptions.setClassPathMode(JarArchiveComparatorOptions.ClassPathMode.ONE_COMMON_CLASSPATH);
            }
        }
        this.setUpClassPathUsingMavenProject(comparatorOptions);
    }

    private void setUpClassPathUsingMavenProject(JarArchiveComparatorOptions comparatorOptions) throws MojoFailureException {
        MavenProject mavenProject = this.mavenParameters.mavenProject();
        this.notNull(mavenProject, "Maven parameter mavenProject should be provided by maven container.");
        HashSet<String> classPathEntries = new HashSet<String>();
        for (org.eclipse.aether.artifact.Artifact artifact : this.getCompileArtifacts(mavenProject)) {
            File resolvedFile = artifact.getFile();
            if (resolvedFile != null) {
                String absolutePath = resolvedFile.getAbsolutePath();
                if (!classPathEntries.add(absolutePath)) continue;
                this.log.debug((CharSequence)("Adding to classpath: " + absolutePath));
                continue;
            }
            this.handleMissingArtifactFile(artifact);
        }
        comparatorOptions.getClassPathEntries().addAll(classPathEntries);
    }

    private Set<org.eclipse.aether.artifact.Artifact> getCompileArtifacts(MavenProject mavenProject) {
        Set projectDependencies = mavenProject.getArtifacts();
        HashSet<org.eclipse.aether.artifact.Artifact> result = new HashSet<org.eclipse.aether.artifact.Artifact>(1 + projectDependencies.size());
        result.add(RepositoryUtils.toArtifact((Artifact)mavenProject.getArtifact()));
        for (Artifact dep : projectDependencies) {
            if (!dep.getArtifactHandler().isAddedToClasspath() || !"compile".equals(dep.getScope()) && !"provided".equals(dep.getScope()) && !"system".equals(dep.getScope())) continue;
            result.add(RepositoryUtils.toArtifact((Artifact)dep));
        }
        return result;
    }

    private void handleMissingArtifactFile(org.eclipse.aether.artifact.Artifact artifact) {
        if (this.pluginParameters.parameter().isIgnoreMissingOptionalDependency()) {
            this.log.info((CharSequence)("Ignoring missing optional dependency: " + this.toDescriptor(artifact)));
        } else {
            this.log.warn((CharSequence)("Could not resolve optional artifact: " + this.toDescriptor(artifact)));
        }
    }

    private String toDescriptor(org.eclipse.aether.artifact.Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion();
    }

    private List<JApiCmpArchive> retrieveFileFromConfiguration(DependencyDescriptor dependencyDescriptor, String parameterName, ConfigurationVersion configurationVersion) throws MojoFailureException {
        List<JApiCmpArchive> jApiCmpArchives;
        if (dependencyDescriptor instanceof Dependency) {
            Dependency dependency = (Dependency)dependencyDescriptor;
            jApiCmpArchives = this.resolveDependencyToFile(parameterName, dependency, configurationVersion);
        } else if (dependencyDescriptor instanceof ConfigurationFile) {
            ConfigurationFile configurationFile = (ConfigurationFile)dependencyDescriptor;
            jApiCmpArchives = this.resolveConfigurationFileToFile(parameterName, configurationFile, configurationVersion);
        } else {
            throw new MojoFailureException("DependencyDescriptor is not of type <dependency/> nor of type <configurationFile/>.");
        }
        return jApiCmpArchives;
    }

    private List<JApiCmpArchive> retrieveFileFromConfiguration(Version version, String parameterName, ConfigurationVersion configurationVersion) throws MojoFailureException {
        if (version != null) {
            Dependency dependency = version.getDependency();
            if (dependency != null) {
                return this.resolveDependencyToFile(parameterName, dependency, configurationVersion);
            }
            if (version.getFile() != null) {
                ConfigurationFile configurationFile = version.getFile();
                return this.resolveConfigurationFileToFile(parameterName, configurationFile, configurationVersion);
            }
            throw new MojoFailureException("Missing configuration parameter 'dependency'.");
        }
        throw new MojoFailureException(String.format("Missing configuration parameter: %s", parameterName));
    }

    private List<JApiCmpArchive> resolveConfigurationFileToFile(String parameterName, ConfigurationFile configurationFile, ConfigurationVersion configurationVersion) throws MojoFailureException {
        String path = configurationFile.getPath();
        if (path == null) {
            throw new MojoFailureException(String.format("The path element in the configuration of the plugin is missing for %s.", parameterName));
        }
        File file = new File(path);
        if (!file.exists()) {
            if (!this.ignoreMissingArtifact(configurationVersion)) {
                throw new MojoFailureException(String.format("The path '%s' does not point to an existing file.", path));
            }
            this.log.warn((CharSequence)("The file given by path '" + file.getAbsolutePath() + "' does not exist."));
        }
        if (!file.isFile() || !file.canRead()) {
            if (!this.ignoreMissingArtifact(configurationVersion)) {
                throw new MojoFailureException(String.format("The file given by path '%s' is either not a file or is not readable.", path));
            }
            this.log.warn((CharSequence)("The file given by path '" + file.getAbsolutePath() + "' is either not a file or is not readable."));
        }
        return Collections.singletonList(new JApiCmpArchive(file, FileHelper.guessVersion((File)file)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    List<JApiCmpArchive> resolveDependencyToFile(String parameterName, Dependency dependency, ConfigurationVersion configurationVersion) throws MojoFailureException {
        ArrayList<JApiCmpArchive> jApiCmpArchives = new ArrayList<JApiCmpArchive>();
        this.log.debug((CharSequence)("Trying to resolve dependency '" + dependency + "' to file."));
        MavenProject mavenProject = this.mavenParameters.mavenProject();
        if (dependency.getSystemPath() == null) {
            String descriptor = dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion();
            this.log.debug((CharSequence)(parameterName + ": " + descriptor));
            String projectDescriptor = mavenProject.getGroupId() + ":" + mavenProject.getArtifactId() + ":" + mavenProject.getVersion();
            Set<org.eclipse.aether.artifact.Artifact> artifacts = descriptor.equals(projectDescriptor) ? this.getCompileArtifacts(mavenProject) : this.resolveArtifact(dependency, configurationVersion);
            for (org.eclipse.aether.artifact.Artifact artifact : artifacts) {
                File file = artifact.getFile();
                if (file != null) {
                    jApiCmpArchives.add(new JApiCmpArchive(file, artifact.getVersion()));
                    continue;
                }
                this.handleMissingArtifactFile(artifact);
            }
            if (!jApiCmpArchives.isEmpty()) return jApiCmpArchives;
            String message = String.format("Could not resolve dependency with descriptor '%s'.", descriptor);
            if (!this.ignoreMissingArtifact(configurationVersion)) throw new MojoFailureException(message);
            this.log.warn((CharSequence)message);
            return jApiCmpArchives;
        } else {
            String systemPath = dependency.getSystemPath();
            Pattern pattern = Pattern.compile("\\$\\{([^}])");
            Matcher matcher = pattern.matcher(systemPath);
            if (matcher.matches()) {
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    String property = matcher.group(i);
                    String propertyResolved = this.mavenParameters.mavenProject().getProperties().getProperty(property);
                    if (propertyResolved == null) {
                        throw new MojoFailureException("Could not resolve property '" + property + "'.");
                    }
                    systemPath = systemPath.replaceAll("${" + property + "}", propertyResolved);
                }
            }
            File file = new File(systemPath);
            boolean addFile = true;
            if (!file.exists()) {
                if (!this.ignoreMissingArtifact(configurationVersion)) {
                    throw new MojoFailureException("File '" + file.getAbsolutePath() + "' does not exist.");
                }
                this.log.warn((CharSequence)("Could not find file, but ignoreMissingOldVersion is set to true: " + file.getAbsolutePath()));
                addFile = false;
            }
            if (!file.canRead()) {
                if (!this.ignoreMissingArtifact(configurationVersion)) {
                    throw new MojoFailureException("File '" + file.getAbsolutePath() + "' is not readable.");
                }
                this.log.warn((CharSequence)("File is not readable, but ignoreMissingOldVersion is set tot true: " + file.getAbsolutePath()));
                addFile = false;
            }
            String version = FileHelper.guessVersion((File)file);
            if (!addFile) return jApiCmpArchives;
            jApiCmpArchives.add(new JApiCmpArchive(file, version));
        }
        return jApiCmpArchives;
    }

    private boolean ignoreMissingArtifact(ConfigurationVersion configurationVersion) {
        return this.ignoreNonResolvableArtifacts() || this.ignoreMissingOldVersion(configurationVersion) || this.ignoreMissingNewVersion(configurationVersion);
    }

    private boolean ignoreNonResolvableArtifacts() {
        boolean ignoreNonResolvableArtifacts = false;
        ConfigParameters parameterParam = this.pluginParameters.parameter();
        if (parameterParam != null) {
            String ignoreNonResolvableArtifactsAsString = parameterParam.getIgnoreNonResolvableArtifacts();
            if (Boolean.TRUE.toString().equalsIgnoreCase(ignoreNonResolvableArtifactsAsString)) {
                ignoreNonResolvableArtifacts = true;
            }
        }
        return ignoreNonResolvableArtifacts;
    }

    private boolean ignoreMissingOldVersion(ConfigurationVersion configurationVersion) {
        return configurationVersion == ConfigurationVersion.OLD && this.pluginParameters.parameter().getIgnoreMissingOldVersion();
    }

    private boolean ignoreMissingNewVersion(ConfigurationVersion configurationVersion) {
        return configurationVersion == ConfigurationVersion.NEW && this.pluginParameters.parameter().getIgnoreMissingNewVersion();
    }

    private void writeToFile(String output, File outputFile) throws MojoFailureException {
        try (OutputStreamWriter fileWriter = new OutputStreamWriter(Files.newOutputStream(outputFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            fileWriter.write(output);
            this.log.info((CharSequence)("Written file '" + outputFile.getAbsolutePath() + "'."));
        }
        catch (IOException e) {
            throw new MojoFailureException(String.format("Failed to write file: %s", e.getMessage()), (Throwable)e);
        }
    }

    private Set<org.eclipse.aether.artifact.Artifact> resolveArtifact(Dependency dependency, ConfigurationVersion configurationVersion) throws MojoFailureException {
        this.notNull(this.mavenParameters.artifactRepositories(), "Maven parameter artifactRepositories should be provided by maven container.");
        DefaultArtifact artifact = this.createDefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), dependency.getType(), dependency.getVersion());
        return this.resolveArtifact((org.eclipse.aether.artifact.Artifact)artifact, configurationVersion);
    }

    private Set<org.eclipse.aether.artifact.Artifact> resolveArtifact(org.eclipse.aether.artifact.Artifact artifact, ConfigurationVersion configurationVersion) throws MojoFailureException {
        this.notNull(this.mavenParameters.repoSystem(), "Maven parameter repoSystem should be provided by maven container.");
        this.notNull(this.mavenParameters.repoSession(), "Maven parameter repoSession should be provided by maven container.");
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact(artifact);
        request.setRepositories(this.mavenParameters.remoteRepos());
        try {
            this.log.debug((CharSequence)("Trying to resolve artifact: " + request));
            ArtifactResult resolutionResult = this.mavenParameters.repoSystem().resolveArtifact(this.mavenParameters.repoSession(), request);
            this.log.debug((CharSequence)("Resolved artifact: " + resolutionResult));
            if (resolutionResult != null) {
                if (resolutionResult.getExceptions() != null && !resolutionResult.getExceptions().isEmpty()) {
                    List exceptions = resolutionResult.getExceptions();
                    for (Exception exception : exceptions) {
                        this.log.debug((CharSequence)exception.getMessage(), (Throwable)exception);
                    }
                }
                if (resolutionResult.isMissing()) {
                    if (!this.ignoreMissingArtifact(configurationVersion)) {
                        throw new MojoFailureException("Could not resolve artifact " + request.getArtifact());
                    }
                    this.log.warn((CharSequence)("Ignoring missing artifact " + request.getArtifact()));
                    return new HashSet<org.eclipse.aether.artifact.Artifact>();
                }
                return new HashSet<org.eclipse.aether.artifact.Artifact>(Collections.singletonList(resolutionResult.getArtifact()));
            }
        }
        catch (ArtifactResolutionException e) {
            if (this.ignoreMissingArtifact(configurationVersion)) {
                this.log.warn((CharSequence)e.getMessage());
            }
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        return new HashSet<org.eclipse.aether.artifact.Artifact>();
    }

    private <T> void notNull(T value, String msg) throws MojoFailureException {
        if (value == null) {
            throw new MojoFailureException(msg);
        }
    }

    static enum ConfigurationVersion {
        OLD,
        NEW;

    }
}

