/*
 * Decompiled with CFR 0.152.
 */
package japicmp.maven;

import japicmp.config.Options;
import japicmp.maven.BreakBuild;
import japicmp.maven.ConfigParameters;
import japicmp.maven.Dependency;
import japicmp.maven.DependencyDescriptor;
import japicmp.maven.JApiCmpProcessor;
import japicmp.maven.MavenParameters;
import japicmp.maven.PluginParameters;
import japicmp.maven.SkipReport;
import japicmp.maven.Version;
import japicmp.output.html.HtmlOutput;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="cmp-report", defaultPhase=LifecyclePhase.SITE)
public class JApiCmpReport
extends AbstractMavenReport {
    @Parameter
    Version oldVersion;
    @Parameter
    List<DependencyDescriptor> oldVersions;
    @Parameter
    Version newVersion;
    @Parameter
    List<DependencyDescriptor> newVersions;
    @Parameter
    ConfigParameters parameter = new ConfigParameters();
    @Parameter
    List<Dependency> dependencies;
    @Parameter
    List<Dependency> oldClassPathDependencies;
    @Parameter
    List<Dependency> newClassPathDependencies;
    @Parameter(property="japicmp.skip", defaultValue="false")
    boolean skip;
    @Parameter(property="japicmp.skipDiffReport")
    boolean skipDiffReport;
    @Parameter(property="japicmp.skipHtmlReport")
    boolean skipHtmlReport;
    @Parameter(property="japicmp.skipMarkdownReport")
    boolean skipMarkdownReport;
    @Parameter(property="japicmp.skipXmlReport")
    boolean skipXmlReport;
    @Parameter(required=true, property="project.build.directory")
    File projectBuildDir;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    List<RemoteRepository> remoteProjectRepositories;
    @Parameter(defaultValue="(,${project.version})", readonly=true)
    String versionRangeWithProjectVersion;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    MojoExecution mojoExecution;
    @Component
    RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    List<RemoteRepository> remoteRepos;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    List<ArtifactRepository> artifactRepositories;
    MavenParameters mavenParameters;
    PluginParameters pluginParameters;
    JApiCmpProcessor processor;

    protected void executeReport(Locale locale) throws MavenReportException {
        this.mavenParameters = new MavenParameters(this.artifactRepositories, this.project, this.mojoExecution, this.versionRangeWithProjectVersion, this.repoSystem, this.repoSession, this.remoteProjectRepositories);
        this.pluginParameters = new PluginParameters(this.skip, this.newVersion, this.oldVersion, this.parameter, this.dependencies, this.projectBuildDir, this.outputDirectory, true, this.oldVersions, this.newVersions, this.oldClassPathDependencies, this.newClassPathDependencies, new SkipReport(this.skipDiffReport, this.skipHtmlReport, this.skipMarkdownReport, this.skipXmlReport), new BreakBuild());
        try {
            this.processor = new JApiCmpProcessor(this.pluginParameters, this.mavenParameters, this.getLog());
            Optional<HtmlOutput> htmlOutputOptional = this.processor.execute();
            if (htmlOutputOptional.isPresent()) {
                HtmlOutput htmlOutput = htmlOutputOptional.get();
                String htmlString = htmlOutput.getHtml();
                htmlString = JApiCmpReport.replaceHtmlTags(htmlString);
                this.writeToSink(htmlString);
            }
        }
        catch (Exception e) {
            String msg = "Failed to generate report: " + e.getMessage();
            Sink sink = this.getSink();
            sink.text(msg);
            sink.close();
            throw new MavenReportException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToSink(String htmlString) {
        try (Sink sink = this.getSink();){
            String htmlTitle = this.getHtmlTitle();
            if (htmlTitle != null) {
                sink.head();
                sink.title();
                sink.text(this.pluginParameters.parameter().getHtmlTitle());
                sink.title_();
                sink.head_();
            }
            sink.rawText(htmlString);
        }
    }

    private static String replaceHtmlTags(String html) {
        String newHtml = html.replaceAll("</?html>", "");
        newHtml = newHtml.replaceAll("</?body>", "");
        newHtml = newHtml.replaceAll("</?head>", "");
        newHtml = newHtml.replaceAll("<title>[^<]*</title>", "");
        newHtml = newHtml.replaceAll("<META[^>]*>", "");
        return newHtml;
    }

    private String getHtmlTitle() {
        String ret = null;
        if (this.parameter.getHtmlTitle() != null) {
            ret = this.pluginParameters.parameter().getHtmlTitle();
        }
        return ret;
    }

    public String getOutputName() {
        String ret = "japicmp";
        if (this.parameter.getReportLinkName() != null) {
            ret = this.parameter.getReportLinkName().replace(' ', '_');
        }
        return ret;
    }

    public String getName(Locale locale) {
        String ret = "japicmp";
        if (this.parameter.getReportLinkName() != null) {
            ret = this.parameter.getReportLinkName();
        }
        return ret;
    }

    public String getDescription(Locale locale) {
        Options options;
        if (this.skip || this.isPomModuleNeedingSkip()) {
            return "Skipping report";
        }
        try {
            options = this.processor.getOptions();
        }
        catch (MojoFailureException e) {
            return "failed report";
        }
        if (options == null) {
            return "failed report";
        }
        return options.getDifferenceDescription();
    }

    private boolean isPomModuleNeedingSkip() {
        return this.parameter.getSkipPomModules() && "pom".equalsIgnoreCase(this.project.getArtifact().getType());
    }
}

