/*
 * Decompiled with CFR 0.152.
 */
package japicmp.maven;

import japicmp.maven.ConfigParameters;
import japicmp.model.JApiClass;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class PostAnalysisScriptExecutor {
    public List<JApiClass> apply(ConfigParameters parameter, List<JApiClass> jApiClasses, Log log) throws MojoExecutionException {
        List<JApiClass> filteredList;
        block14: {
            filteredList = jApiClasses;
            String postAnalysisFilterScript = parameter.getPostAnalysisScript();
            if (postAnalysisFilterScript != null) {
                try {
                    InputStream inputStream = this.getInputStream(postAnalysisFilterScript);
                    if (inputStream != null) {
                        ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByName("groovy");
                        Bindings bindings = scriptEngine.createBindings();
                        bindings.put("jApiClasses", (Object)jApiClasses);
                        try (InputStreamReader fileReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                            Object returnValue = scriptEngine.eval((Reader)fileReader, bindings);
                            if (returnValue instanceof List) {
                                List returnedList = (List)returnValue;
                                filteredList = new ArrayList<JApiClass>(returnedList.size());
                                for (Object obj : returnedList) {
                                    if (!(obj instanceof JApiClass)) continue;
                                    JApiClass jApiClass = (JApiClass)obj;
                                    filteredList.add(jApiClass);
                                }
                                break block14;
                            }
                            throw new MojoExecutionException("Post-analysis script does not return a list.");
                        }
                        catch (ScriptException e) {
                            throw new MojoExecutionException("Execution of post-analysis script failed: " + e.getMessage(), (Exception)e);
                        }
                        catch (IOException e) {
                            throw new MojoExecutionException("Failed to load post-analysis script '" + postAnalysisFilterScript + ": " + e.getMessage(), (Exception)e);
                        }
                    }
                    throw new MojoExecutionException("Post-analysis script '" + postAnalysisFilterScript + "' does not exist.");
                }
                catch (FileNotFoundException e) {
                    throw new MojoExecutionException("Post-analysis script '" + postAnalysisFilterScript + " does not exist.", (Exception)e);
                }
            }
            log.debug((CharSequence)"No post-analysis script provided.");
        }
        return filteredList;
    }

    private InputStream getInputStream(String postAnalysisFilterScript) throws FileNotFoundException {
        if (Files.exists(Paths.get(postAnalysisFilterScript, new String[0]), new LinkOption[0])) {
            return new FileInputStream(postAnalysisFilterScript);
        }
        return PostAnalysisScriptExecutor.class.getClassLoader().getResourceAsStream(postAnalysisFilterScript);
    }
}

