/*
 * Decompiled with CFR 0.152.
 */
package japicmp.maven;

import com.google.common.base.Optional;
import japicmp.cmp.JarArchiveComparator;
import japicmp.cmp.JarArchiveComparatorOptions;
import japicmp.config.Options;
import japicmp.maven.ConfigurationFile;
import japicmp.maven.Dependency;
import japicmp.maven.MavenParameters;
import japicmp.maven.Parameter;
import japicmp.maven.PluginParameters;
import japicmp.maven.Version;
import japicmp.model.AccessModifier;
import japicmp.model.JApiChangeStatus;
import japicmp.model.JApiClass;
import japicmp.output.stdout.StdoutOutputGenerator;
import japicmp.output.xml.XmlOutput;
import japicmp.output.xml.XmlOutputGenerator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="cmp", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.VERIFY)
public class JApiCmpMojo
extends AbstractMojo {
    @org.apache.maven.plugins.annotations.Parameter(required=true)
    private Version oldVersion;
    @org.apache.maven.plugins.annotations.Parameter(required=true)
    private Version newVersion;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private Parameter parameter;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private List<Dependency> dependencies;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private String skip;
    @org.apache.maven.plugins.annotations.Parameter(property="project.build.directory", required=true)
    private File projectBuildDir;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private ArtifactResolver artifactResolver;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${localRepository}")
    private ArtifactRepository localRepository;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${project.remoteArtifactRepositories}")
    private List<ArtifactRepository> artifactRepositories;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${project}")
    private MavenProject mavenProject;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenParameters mavenParameters = new MavenParameters(this.artifactRepositories, this.artifactFactory, this.localRepository, this.artifactResolver, this.mavenProject);
        PluginParameters pluginParameters = new PluginParameters(this.skip, this.newVersion, this.oldVersion, this.parameter, this.dependencies, (Optional<File>)Optional.of((Object)this.projectBuildDir), (Optional<String>)Optional.absent(), true);
        this.executeWithParameters(pluginParameters, mavenParameters);
    }

    Optional<XmlOutput> executeWithParameters(PluginParameters pluginParameters, MavenParameters mavenParameters) throws MojoFailureException {
        if (Boolean.TRUE.toString().equalsIgnoreCase(pluginParameters.getSkipParam())) {
            this.getLog().info((CharSequence)"Skipping execution because parameter 'skip' was set to true.");
            return Optional.absent();
        }
        if (this.mavenProject != null && "pom".equals(this.mavenProject.getPackaging())) {
            String skipPomModulesAsString;
            boolean skipPomModules = true;
            Parameter parameterParam = pluginParameters.getParameterParam();
            if (parameterParam != null && (skipPomModulesAsString = parameterParam.getSkipPomModules()) != null) {
                skipPomModules = Boolean.valueOf(skipPomModulesAsString);
            }
            if (skipPomModules) {
                this.getLog().info((CharSequence)"Skipping execution because packaging of this module is 'pom'.");
                return Optional.absent();
            }
        }
        File newVersionFile = this.retrieveFileFromConfiguration(pluginParameters.getNewVersionParam(), "newVersion", mavenParameters);
        File oldVersionFile = this.retrieveFileFromConfiguration(pluginParameters.getOldVersionParam(), "oldVersion", mavenParameters);
        Options options = this.createOptions(pluginParameters.getParameterParam());
        List<JApiClass> jApiClasses = this.compareArchives(newVersionFile, oldVersionFile, options, pluginParameters.getDependenciesParam(), mavenParameters);
        try {
            File jApiCmpBuildDir = this.createJapiCmpBaseDir(pluginParameters);
            String diffOutput = this.generateDiffOutput(newVersionFile, oldVersionFile, jApiClasses, options);
            this.createFileAndWriteTo(diffOutput, jApiCmpBuildDir);
            XmlOutput xmlOutput = this.generateXmlOutput(newVersionFile, oldVersionFile, jApiClasses, jApiCmpBuildDir, options);
            if (pluginParameters.isWriteToFiles()) {
                XmlOutputGenerator.writeToFiles((Options)options, (XmlOutput)xmlOutput);
            }
            this.breakBuildIfNecessary(jApiClasses, pluginParameters.getParameterParam());
            return Optional.of((Object)xmlOutput);
        }
        catch (IOException e) {
            throw new MojoFailureException(String.format("Failed to construct output directory: %s", e.getMessage()), (Throwable)e);
        }
    }

    private void breakBuildIfNecessary(List<JApiClass> jApiClasses, Parameter parameterParam) throws MojoFailureException {
        if (this.breakBuildOnModificationsParameter(parameterParam)) {
            for (JApiClass jApiClass : jApiClasses) {
                if (jApiClass.getChangeStatus() == JApiChangeStatus.UNCHANGED) continue;
                throw new MojoFailureException(String.format("Breaking the build because there is at least one modified class: %s", jApiClass.getFullyQualifiedName()));
            }
        }
        if (this.breakBuildOnBinaryIncompatibleModifications(parameterParam)) {
            for (JApiClass jApiClass : jApiClasses) {
                if (jApiClass.getChangeStatus() == JApiChangeStatus.UNCHANGED || jApiClass.isBinaryCompatible()) continue;
                throw new MojoFailureException(String.format("Breaking the build because there is at least one modified class: %s", jApiClass.getFullyQualifiedName()));
            }
        }
    }

    private Options createOptions(Parameter parameterParam) throws MojoFailureException {
        Options options = new Options();
        if (parameterParam != null) {
            String ignoreMissingClassesString;
            String string;
            List<String> includes;
            List<String> excludes;
            String onlyModified;
            String onlyBinaryIncompatible;
            String accessModifierArg = parameterParam.getAccessModifier();
            if (accessModifierArg != null) {
                try {
                    AccessModifier accessModifier = AccessModifier.valueOf((String)accessModifierArg.toUpperCase());
                    options.setAccessModifier(accessModifier);
                }
                catch (IllegalArgumentException e) {
                    throw new MojoFailureException(String.format("Invalid value for option accessModifier: %s. Possible values are: %s.", accessModifierArg, AccessModifier.listOfAccessModifier()));
                }
            }
            if ((onlyBinaryIncompatible = parameterParam.getOnlyBinaryIncompatible()) != null) {
                Boolean booleanOnlyBinaryIncompatible = Boolean.valueOf(onlyBinaryIncompatible);
                options.setOutputOnlyBinaryIncompatibleModifications(booleanOnlyBinaryIncompatible.booleanValue());
            }
            if ((onlyModified = parameterParam.getOnlyModified()) != null) {
                Boolean booleanOnlyModified = Boolean.valueOf(onlyModified);
                options.setOutputOnlyModifications(booleanOnlyModified.booleanValue());
            }
            if ((excludes = parameterParam.getExcludes()) != null) {
                for (String string2 : excludes) {
                    options.addExcludeFromArgument(Optional.fromNullable((Object)string2));
                }
            }
            if ((includes = parameterParam.getIncludes()) != null) {
                for (String include : includes) {
                    options.addIncludeFromArgument(Optional.fromNullable((Object)include));
                }
            }
            if ((string = parameterParam.getIncludeSynthetic()) != null) {
                Boolean includeSynthetic = Boolean.valueOf(string);
                options.setIncludeSynthetic(includeSynthetic.booleanValue());
            }
            if ((ignoreMissingClassesString = parameterParam.getIgnoreMissingClasses()) != null) {
                Boolean ignoreMissingClasses = Boolean.valueOf(ignoreMissingClassesString);
                options.setIgnoreMissingClasses(ignoreMissingClasses.booleanValue());
            }
        }
        return options;
    }

    private boolean breakBuildOnModificationsParameter(Parameter parameterParam) {
        boolean retVal = false;
        if (parameterParam != null) {
            retVal = Boolean.valueOf(parameterParam.getBreakBuildOnModifications());
        }
        return retVal;
    }

    private boolean breakBuildOnBinaryIncompatibleModifications(Parameter parameterParam) {
        boolean retVal = false;
        if (parameterParam != null) {
            retVal = Boolean.valueOf(parameterParam.getBreakBuildOnBinaryIncompatibleModifications());
        }
        return retVal;
    }

    private void createFileAndWriteTo(String diffOutput, File jApiCmpBuildDir) throws IOException, MojoFailureException {
        File outputfile = new File(jApiCmpBuildDir.getCanonicalPath() + File.separator + "japicmp.diff");
        this.writeToFile(diffOutput, outputfile);
    }

    private File createJapiCmpBaseDir(PluginParameters pluginParameters) throws MojoFailureException {
        if (pluginParameters.getProjectBuildDirParam().isPresent()) {
            try {
                File projectBuildDirParam = (File)pluginParameters.getProjectBuildDirParam().get();
                if (projectBuildDirParam != null) {
                    File jApiCmpBuildDir = new File(projectBuildDirParam.getCanonicalPath() + File.separator + "japicmp");
                    boolean mkdirs = jApiCmpBuildDir.mkdirs();
                    if (mkdirs || jApiCmpBuildDir.isDirectory() && jApiCmpBuildDir.canWrite()) {
                        return jApiCmpBuildDir;
                    }
                    throw new MojoFailureException(String.format("Failed to create directory '%s'.", jApiCmpBuildDir.getAbsolutePath()));
                }
                throw new MojoFailureException("Maven parameter projectBuildDir is not set.");
            }
            catch (IOException e) {
                throw new MojoFailureException("Failed to create output directory: " + e.getMessage(), (Throwable)e);
            }
        }
        if (pluginParameters.getOutputDirectory().isPresent()) {
            String outputDirectory = (String)pluginParameters.getOutputDirectory().get();
            if (outputDirectory != null) {
                File outputDirFile = new File(outputDirectory);
                boolean mkdirs = outputDirFile.mkdirs();
                if (mkdirs || outputDirFile.isDirectory() && outputDirFile.canWrite()) {
                    return outputDirFile;
                }
                throw new MojoFailureException(String.format("Failed to create directory '%s'.", outputDirFile.getAbsolutePath()));
            }
            throw new MojoFailureException("Maven parameter outputDirectory is not set.");
        }
        throw new MojoFailureException("None of the two parameters projectBuildDir and outputDirectory are present");
    }

    private String generateDiffOutput(File newVersionFile, File oldVersionFile, List<JApiClass> jApiClasses, Options options) {
        StdoutOutputGenerator stdoutOutputGenerator = new StdoutOutputGenerator(options, jApiClasses, oldVersionFile, newVersionFile);
        String diffOutput = stdoutOutputGenerator.generate();
        this.getLog().info((CharSequence)diffOutput);
        return diffOutput;
    }

    private XmlOutput generateXmlOutput(File newVersionFile, File oldVersionFile, List<JApiClass> jApiClasses, File jApiCmpBuildDir, Options options) throws IOException, MojoFailureException {
        options.setXmlOutputFile(Optional.of((Object)(jApiCmpBuildDir.getCanonicalPath() + File.separator + "japicmp.xml")));
        options.setHtmlOutputFile(Optional.of((Object)(jApiCmpBuildDir.getCanonicalPath() + File.separator + "japicmp.html")));
        XmlOutputGenerator xmlGenerator = new XmlOutputGenerator(oldVersionFile.getAbsolutePath(), newVersionFile.getAbsolutePath(), jApiClasses, options, false);
        return xmlGenerator.generate();
    }

    private List<JApiClass> compareArchives(File newVersionFile, File oldVersionFile, Options options, List<Dependency> dependenciesParam, MavenParameters mavenParameters) throws MojoFailureException {
        JarArchiveComparatorOptions comparatorOptions = JarArchiveComparatorOptions.of((Options)options);
        this.setUpClassPath(comparatorOptions, dependenciesParam, mavenParameters);
        JarArchiveComparator jarArchiveComparator = new JarArchiveComparator(comparatorOptions);
        return jarArchiveComparator.compare(oldVersionFile, newVersionFile);
    }

    private void setUpClassPath(JarArchiveComparatorOptions comparatorOptions, List<Dependency> dependenciesParam, MavenParameters mavenParameters) throws MojoFailureException {
        if (dependenciesParam != null) {
            for (Dependency dependency : dependenciesParam) {
                File file = this.resolveDependencyToFile("dependencies", dependency, mavenParameters);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Resolved dependency " + dependency + " to file '" + file.getAbsolutePath() + "'."));
                }
                comparatorOptions.getClassPathEntries().add(file.getAbsolutePath());
            }
        }
        this.setUpClassPathUsingMavenProject(comparatorOptions, mavenParameters);
    }

    private void setUpClassPathUsingMavenProject(JarArchiveComparatorOptions comparatorOptions, MavenParameters mavenParameters) throws MojoFailureException {
        JApiCmpMojo.notNull(mavenParameters.getMavenProject(), "Maven parameter mavenProject should be provided by maven container.");
        Set dependencyArtifacts = mavenParameters.getMavenProject().getArtifacts();
        for (Artifact artifact : dependencyArtifacts) {
            String scope = artifact.getScope();
            if ("test".equals(scope)) continue;
            Optional<File> file = this.resolveArtifact(artifact, mavenParameters);
            if (file.isPresent()) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Adding to classpath: " + ((File)file.get()).getAbsolutePath() + "; scope: " + scope));
                }
                comparatorOptions.getClassPathEntries().add(((File)file.get()).getAbsolutePath());
                continue;
            }
            this.getLog().error((CharSequence)("Could not resolve artifact " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion()));
        }
    }

    private File retrieveFileFromConfiguration(Version version, String parameterName, MavenParameters mavenParameters) throws MojoFailureException {
        if (version != null) {
            Dependency dependency = version.getDependency();
            if (dependency != null) {
                return this.resolveDependencyToFile(parameterName, dependency, mavenParameters);
            }
            if (version.getFile() != null) {
                ConfigurationFile configurationFile = version.getFile();
                String path = configurationFile.getPath();
                if (path == null) {
                    throw new MojoFailureException(String.format("The path element in the configuration of the plugin is missing for %s.", parameterName));
                }
                File file = new File(path);
                if (!file.exists()) {
                    throw new MojoFailureException(String.format("The path '%s' does not point to an existing file.", path));
                }
                if (!file.isFile() || !file.canRead()) {
                    throw new MojoFailureException(String.format("The file given by path '%s' is either not a file or is not readable.", path));
                }
                return file;
            }
            throw new MojoFailureException(String.format("Missing configuration parameter 'dependency'.", new Object[0]));
        }
        throw new MojoFailureException(String.format("Missing configuration parameter: %s", parameterName));
    }

    private File resolveDependencyToFile(String parameterName, Dependency dependency, MavenParameters mavenParameters) throws MojoFailureException {
        File file;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Trying to resolve dependency '" + dependency + "' to file."));
        }
        if (dependency.getSystemPath() == null) {
            String descriptor = dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion();
            this.getLog().debug((CharSequence)(parameterName + ": " + descriptor));
            Optional<File> file2 = this.resolveArtifact(dependency, mavenParameters);
            if (!file2.isPresent()) {
                throw new MojoFailureException(String.format("Could not resolve dependency with descriptor '%s'.", descriptor));
            }
            return (File)file2.get();
        }
        String systemPath = dependency.getSystemPath();
        Pattern pattern = Pattern.compile("\\$\\{([^\\}])");
        Matcher matcher = pattern.matcher(systemPath);
        if (matcher.matches()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                String property = matcher.group(i);
                String propertyResolved = mavenParameters.getMavenProject().getProperties().getProperty(property);
                if (propertyResolved == null) {
                    throw new MojoFailureException("Could not resolve property '" + property + "'.");
                }
                systemPath = systemPath.replaceAll("${" + property + "}", propertyResolved);
            }
        }
        if (!(file = new File(systemPath)).exists()) {
            throw new MojoFailureException("File '" + file.getAbsolutePath() + "' does not exist.");
        }
        if (!file.canRead()) {
            throw new MojoFailureException("File '" + file.getAbsolutePath() + "' is not readable.");
        }
        return file;
    }

    private void writeToFile(String output, File outputfile) throws MojoFailureException, IOException {
        try (FileWriter fileWriter = null;){
            fileWriter = new FileWriter(outputfile);
            fileWriter.write(output);
        }
    }

    private Optional<File> resolveArtifact(Dependency dependency, MavenParameters mavenParameters) throws MojoFailureException {
        JApiCmpMojo.notNull(mavenParameters.getArtifactRepositories(), "Maven parameter artifactRepositories should be provided by maven container.");
        Artifact artifact = mavenParameters.getArtifactFactory().createBuildArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), "jar");
        return this.resolveArtifact(artifact, mavenParameters);
    }

    private Optional<File> resolveArtifact(Artifact artifact, MavenParameters mavenParameters) throws MojoFailureException {
        JApiCmpMojo.notNull(mavenParameters.getLocalRepository(), "Maven parameter localRepository should be provided by maven container.");
        JApiCmpMojo.notNull(mavenParameters.getArtifactResolver(), "Maven parameter artifactResolver should be provided by maven container.");
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        request.setLocalRepository(mavenParameters.getLocalRepository());
        request.setRemoteRepositories(mavenParameters.getArtifactRepositories());
        mavenParameters.getArtifactResolver().resolve(request);
        return Optional.fromNullable((Object)artifact.getFile());
    }

    private static <T> T notNull(T value, String msg) throws MojoFailureException {
        if (value == null) {
            throw new MojoFailureException(msg);
        }
        return value;
    }
}

