/*
 * Decompiled with CFR 0.152.
 */
package japicmp.maven;

import com.google.common.base.Optional;
import japicmp.cli.JApiCli;
import japicmp.cmp.JarArchiveComparator;
import japicmp.cmp.JarArchiveComparatorOptions;
import japicmp.config.Options;
import japicmp.filter.ClassFilter;
import japicmp.filter.Filter;
import japicmp.maven.ConfigurationFile;
import japicmp.maven.Dependency;
import japicmp.maven.DependencyDescriptor;
import japicmp.maven.MavenParameters;
import japicmp.maven.Parameter;
import japicmp.maven.PluginParameters;
import japicmp.maven.Version;
import japicmp.maven.VersionChange;
import japicmp.model.AccessModifier;
import japicmp.model.JApiAnnotation;
import japicmp.model.JApiBehavior;
import japicmp.model.JApiChangeStatus;
import japicmp.model.JApiClass;
import japicmp.model.JApiCompatibilityChange;
import japicmp.model.JApiConstructor;
import japicmp.model.JApiField;
import japicmp.model.JApiImplementedInterface;
import japicmp.model.JApiMethod;
import japicmp.model.JApiParameter;
import japicmp.model.JApiReturnType;
import japicmp.model.JApiSuperclass;
import japicmp.model.JApiType;
import japicmp.output.Filter;
import japicmp.output.semver.SemverOut;
import japicmp.output.stdout.StdoutOutputGenerator;
import japicmp.output.xml.XmlOutput;
import japicmp.output.xml.XmlOutputGenerator;
import japicmp.output.xml.XmlOutputGeneratorOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javassist.CtClass;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="cmp", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.VERIFY)
public class JApiCmpMojo
extends AbstractMojo {
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private Version oldVersion;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private List<DependencyDescriptor> oldVersions;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private Version newVersion;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private List<DependencyDescriptor> newVersions;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private Parameter parameter;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private List<Dependency> dependencies;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private List<Dependency> oldClassPathDependencies;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private List<Dependency> newClassPathDependencies;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private String skip;
    @org.apache.maven.plugins.annotations.Parameter(property="project.build.directory", required=true)
    private File projectBuildDir;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private ArtifactResolver artifactResolver;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${localRepository}")
    private ArtifactRepository localRepository;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${project.remoteArtifactRepositories}")
    private List<ArtifactRepository> artifactRepositories;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${project}")
    private MavenProject mavenProject;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${mojoExecution}", readonly=true)
    private MojoExecution mojoExecution;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="(,${project.version})", readonly=true)
    private String versionRangeWithProjectVersion;
    @Component
    private ArtifactMetadataSource metadataSource;
    private Options options;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenParameters mavenParameters = new MavenParameters(this.artifactRepositories, this.artifactFactory, this.localRepository, this.artifactResolver, this.mavenProject, this.mojoExecution, this.versionRangeWithProjectVersion, this.metadataSource);
        PluginParameters pluginParameters = new PluginParameters(this.skip, this.newVersion, this.oldVersion, this.parameter, this.dependencies, (Optional<File>)Optional.of((Object)this.projectBuildDir), (Optional<String>)Optional.absent(), true, this.oldVersions, this.newVersions, this.oldClassPathDependencies, this.newClassPathDependencies);
        this.executeWithParameters(pluginParameters, mavenParameters);
    }

    Optional<XmlOutput> executeWithParameters(PluginParameters pluginParameters, MavenParameters mavenParameters) throws MojoFailureException {
        if (Boolean.TRUE.toString().equalsIgnoreCase(pluginParameters.getSkipParam())) {
            this.getLog().info((CharSequence)"Skipping execution because parameter 'skip' was set to true.");
            return Optional.absent();
        }
        if (this.filterModule(pluginParameters, mavenParameters)) {
            return Optional.absent();
        }
        Options options = this.getOptions(pluginParameters, mavenParameters);
        JarArchiveComparatorOptions comparatorOptions = JarArchiveComparatorOptions.of((Options)options);
        this.setUpClassPath(comparatorOptions, pluginParameters, mavenParameters);
        JarArchiveComparator jarArchiveComparator = new JarArchiveComparator(comparatorOptions);
        List<JApiClass> jApiClasses = jarArchiveComparator.compare(options.getOldArchives(), options.getNewArchives());
        try {
            jApiClasses = this.applyPostAnalysisScript(pluginParameters.getParameterParam(), jApiClasses);
            File jApiCmpBuildDir = this.createJapiCmpBaseDir(pluginParameters);
            this.generateDiffOutput(mavenParameters, pluginParameters, options, jApiClasses, jApiCmpBuildDir);
            XmlOutput xmlOutput = this.generateXmlOutput(jApiClasses, jApiCmpBuildDir, options, mavenParameters, pluginParameters);
            if (pluginParameters.isWriteToFiles()) {
                List filesWritten = XmlOutputGenerator.writeToFiles((Options)options, (XmlOutput)xmlOutput);
                for (File file : filesWritten) {
                    this.getLog().info((CharSequence)("Written file '" + file.getAbsolutePath() + "'."));
                }
            }
            VersionChange versionChange = new VersionChange(options.getOldArchives(), options.getNewArchives());
            this.breakBuildIfNecessary(jApiClasses, pluginParameters.getParameterParam(), versionChange, options, jarArchiveComparator);
            return Optional.of((Object)xmlOutput);
        }
        catch (IOException e) {
            throw new MojoFailureException(String.format("Failed to construct output directory: %s", e.getMessage()), (Throwable)e);
        }
    }

    private List<JApiClass> applyPostAnalysisScript(Parameter parameter, List<JApiClass> jApiClasses) throws MojoFailureException {
        List<JApiClass> filteredList;
        block21: {
            filteredList = jApiClasses;
            if (parameter != null) {
                String postAnalysisFilterScript = parameter.getPostAnalysisScript();
                if (postAnalysisFilterScript != null) {
                    if (Files.exists(Paths.get(postAnalysisFilterScript, new String[0]), new LinkOption[0])) {
                        ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByName("groovy");
                        Bindings bindings = scriptEngine.createBindings();
                        bindings.put("jApiClasses", (Object)jApiClasses);
                        try (InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(postAnalysisFilterScript), Charset.forName("UTF-8"));){
                            Object returnValue = scriptEngine.eval((Reader)fileReader, bindings);
                            if (returnValue instanceof List) {
                                List returnedList = (List)returnValue;
                                filteredList = new ArrayList<JApiClass>(returnedList.size());
                                for (Object obj : returnedList) {
                                    if (!(obj instanceof JApiClass)) continue;
                                    JApiClass jApiClass = (JApiClass)obj;
                                    filteredList.add(jApiClass);
                                }
                                break block21;
                            }
                            throw new MojoFailureException("Post-analysis script does not return a list.");
                        }
                        catch (ScriptException e) {
                            throw new MojoFailureException("Execution of post-analysis script failed: " + e.getMessage(), (Throwable)e);
                        }
                        catch (FileNotFoundException e) {
                            throw new MojoFailureException("Post-analysis script '" + postAnalysisFilterScript + " does not exist.");
                        }
                        catch (IOException e) {
                            throw new MojoFailureException("Failed to load post-analysis script '" + postAnalysisFilterScript + ": " + e.getMessage(), (Throwable)e);
                        }
                    }
                    throw new MojoFailureException("Post-analysis script '" + postAnalysisFilterScript + " does not exist.");
                }
                this.getLog().debug((CharSequence)"No post-analysis script provided.");
            }
        }
        return filteredList;
    }

    private boolean filterModule(PluginParameters pluginParameters, MavenParameters mavenParameters) {
        MavenProject mavenProject = mavenParameters.getMavenProject();
        if (mavenProject != null && pluginParameters.getParameterParam() != null) {
            List<String> packagingSupporteds = pluginParameters.getParameterParam().getPackagingSupporteds();
            if (packagingSupporteds != null && !packagingSupporteds.isEmpty()) {
                if (!packagingSupporteds.contains(mavenProject.getPackaging())) {
                    this.getLog().info((CharSequence)"Filtered according to packagingFilter");
                    return true;
                }
            } else {
                this.getLog().debug((CharSequence)"No packaging support defined, no filtering");
            }
            if ("pom".equals(mavenProject.getPackaging())) {
                String skipPomModulesAsString;
                boolean skipPomModules = true;
                Parameter parameterParam = pluginParameters.getParameterParam();
                if (parameterParam != null && (skipPomModulesAsString = parameterParam.getSkipPomModules()) != null) {
                    skipPomModules = Boolean.valueOf(skipPomModulesAsString);
                }
                if (skipPomModules) {
                    this.getLog().info((CharSequence)"Skipping execution because packaging of this module is 'pom'.");
                    return true;
                }
            }
        }
        return false;
    }

    private Artifact getComparisonArtifact(MavenParameters mavenParameters, PluginParameters pluginParameters) throws MojoFailureException, MojoExecutionException {
        Artifact previousArtifact;
        VersionRange versionRange;
        try {
            versionRange = VersionRange.createFromVersionSpec((String)mavenParameters.getVersionRangeWithProjectVersion());
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoFailureException("Invalid version versionRange: " + e.getMessage(), (Throwable)e);
        }
        try {
            MavenProject project = mavenParameters.getMavenProject();
            previousArtifact = mavenParameters.getArtifactFactory().createDependencyArtifact(project.getGroupId(), project.getArtifactId(), versionRange, project.getPackaging(), null, "compile");
            if (!previousArtifact.getVersionRange().isSelectedVersionKnown(previousArtifact)) {
                this.getLog().debug((CharSequence)("Searching for versions in versionRange: " + previousArtifact.getVersionRange()));
                List availableVersions = mavenParameters.getMetadataSource().retrieveAvailableVersions(previousArtifact, mavenParameters.getLocalRepository(), project.getRemoteArtifactRepositories());
                this.filterSnapshots(availableVersions);
                this.filterVersionPattern(availableVersions, pluginParameters);
                ArtifactVersion version = versionRange.matchVersion(availableVersions);
                if (version != null) {
                    previousArtifact.selectVersion(version.toString());
                }
            }
        }
        catch (OverConstrainedVersionException e) {
            throw new MojoFailureException("Invalid comparison version: " + e.getMessage(), (Throwable)e);
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MojoExecutionException("Error determining previous version: " + e.getMessage(), (Exception)((Object)e));
        }
        if (previousArtifact.getVersion() == null) {
            this.getLog().info((CharSequence)"Unable to find a previous version of the project in the repository.");
        }
        return previousArtifact;
    }

    private void filterVersionPattern(List<ArtifactVersion> availableVersions, PluginParameters pluginParameters) throws MojoFailureException {
        if (pluginParameters.getParameterParam() != null && pluginParameters.getParameterParam().getOldVersionPattern() != null) {
            Pattern pattern;
            String versionPattern = pluginParameters.getParameterParam().getOldVersionPattern();
            try {
                pattern = Pattern.compile(versionPattern);
            }
            catch (PatternSyntaxException e) {
                throw new MojoFailureException("Could not compile provided versionPattern '" + versionPattern + "' as regular expression: " + e.getMessage(), (Throwable)e);
            }
            Iterator<ArtifactVersion> versionIterator = availableVersions.iterator();
            while (versionIterator.hasNext()) {
                ArtifactVersion version = versionIterator.next();
                Matcher matcher = pattern.matcher(version.toString());
                if (matcher.matches()) continue;
                versionIterator.remove();
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Filtering version '" + version.toString() + "' because it does not match configured versionPattern '" + versionPattern + "'."));
            }
        } else {
            this.getLog().debug((CharSequence)"Parameter <oldVersionPattern> not configured, i.e. no version filtered.");
        }
    }

    private void filterSnapshots(List versions) {
        Iterator versionIterator = versions.iterator();
        while (versionIterator.hasNext()) {
            ArtifactVersion version = (ArtifactVersion)versionIterator.next();
            if (!"SNAPSHOT".equals(version.getQualifier())) continue;
            versionIterator.remove();
        }
    }

    private void populateArchivesListsFromParameters(PluginParameters pluginParameters, MavenParameters mavenParameters, List<File> oldArchives, List<File> newArchives) throws MojoFailureException {
        String message;
        if (pluginParameters.getOldVersionParam() != null) {
            oldArchives.addAll(this.retrieveFileFromConfiguration(pluginParameters.getOldVersionParam(), "oldVersion", mavenParameters, pluginParameters, ConfigurationVersion.OLD));
        }
        if (pluginParameters.getOldVersionsParam() != null) {
            for (DependencyDescriptor dependencyDescriptor : pluginParameters.getOldVersionsParam()) {
                if (dependencyDescriptor == null) continue;
                oldArchives.addAll(this.retrieveFileFromConfiguration(dependencyDescriptor, "oldVersions", mavenParameters, pluginParameters, ConfigurationVersion.OLD));
            }
        }
        if (pluginParameters.getOldVersionParam() == null && pluginParameters.getOldVersionsParam() == null) {
            try {
                Artifact comparisonArtifact = this.getComparisonArtifact(mavenParameters, pluginParameters);
                if (comparisonArtifact.getVersion() != null) {
                    Set<Artifact> artifacts = this.resolveArtifact(comparisonArtifact, mavenParameters, false, pluginParameters, ConfigurationVersion.OLD);
                    for (Artifact artifact : artifacts) {
                        if (artifact.isOptional()) continue;
                        File file2 = artifact.getFile();
                        if (file2 != null) {
                            oldArchives.add(file2);
                            continue;
                        }
                        this.getLog().warn((CharSequence)("Artifact '" + artifact + " does not have a file."));
                    }
                }
            }
            catch (MojoExecutionException e) {
                throw new MojoFailureException("Computing and resolving comparison artifact failed: " + e.getMessage(), (Throwable)e);
            }
        }
        if (pluginParameters.getNewVersionParam() != null) {
            newArchives.addAll(this.retrieveFileFromConfiguration(pluginParameters.getNewVersionParam(), "newVersion", mavenParameters, pluginParameters, ConfigurationVersion.NEW));
        }
        if (pluginParameters.getNewVersionsParam() != null) {
            for (DependencyDescriptor dependencyDescriptor : pluginParameters.getNewVersionsParam()) {
                if (dependencyDescriptor == null) continue;
                newArchives.addAll(this.retrieveFileFromConfiguration(dependencyDescriptor, "newVersions", mavenParameters, pluginParameters, ConfigurationVersion.NEW));
            }
        }
        if (pluginParameters.getNewVersionParam() == null && pluginParameters.getNewVersionsParam() == null && mavenParameters.getMavenProject() != null && mavenParameters.getMavenProject().getArtifact() != null) {
            Artifact artifact = mavenParameters.getMavenProject().getArtifact();
            File file = artifact.getFile();
            if (file != null) {
                try {
                    Throwable throwable = null;
                    try (JarFile jarFile = new JarFile(file);){
                        this.getLog().debug((CharSequence)("Could open file '" + file.getAbsolutePath() + "' of artifact as jar archive: " + jarFile.getName()));
                        newArchives.add(file);
                    }
                    catch (Throwable file2) {
                        Throwable throwable2 = file2;
                        throw file2;
                    }
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)("No new version specified and file '" + file.getAbsolutePath() + "' of artifact could not be opened as jar archive: " + e.getMessage()));
                }
            } else if (artifact.getArtifactHandler() != null) {
                try {
                    VersionRange versionSpec = VersionRange.createFromVersionSpec((String)artifact.getVersion());
                    Artifact artifact2 = mavenParameters.getArtifactFactory().createDependencyArtifact(artifact.getGroupId(), artifact.getArtifactId(), versionSpec, artifact.getArtifactHandler().getExtension(), null, null);
                    Set<Artifact> artifacts = this.resolveArtifact(artifact2, mavenParameters, false, pluginParameters, ConfigurationVersion.NEW);
                    for (Artifact a : artifacts) {
                        file = a.getFile();
                        if (file == null) continue;
                        try {
                            JarFile jarFile = new JarFile(file);
                            Throwable throwable = null;
                            try {
                                this.getLog().debug((CharSequence)("Could open file '" + file.getAbsolutePath() + "' of artifact as jar archive: " + jarFile.getName()));
                                newArchives.add(file);
                            }
                            catch (Throwable throwable3) {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (jarFile == null) continue;
                                if (throwable != null) {
                                    try {
                                        jarFile.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                jarFile.close();
                            }
                        }
                        catch (IOException e) {
                            this.getLog().warn((CharSequence)("No new version specified and file '" + file.getAbsolutePath() + "' of artifact could not be opened as jar archive: " + e.getMessage()));
                        }
                    }
                }
                catch (InvalidVersionSpecificationException e) {
                    this.getLog().error((CharSequence)("Failed to obtain file for artifact " + artifact + ": " + e.getMessage()), (Throwable)e);
                }
            } else {
                this.getLog().warn((CharSequence)("Artifact " + artifact + " does not have an ArtifactHandler. Cannot resolve artifact automatically."));
            }
        }
        if (oldArchives.size() == 0) {
            message = "Please provide at least one resolvable old version using one of the configuration elements <oldVersion/> or <oldVersions/>.";
            if (this.ignoreNonResolvableArtifacts(pluginParameters) || this.ignoreMissingOldVersion(pluginParameters, ConfigurationVersion.OLD)) {
                this.getLog().warn((CharSequence)message);
            } else {
                throw new MojoFailureException(message);
            }
        }
        if (newArchives.size() == 0) {
            message = "Please provide at least one resolvable new version using one of the configuration elements <newVersion/> or <newVersions/>.";
            if (this.ignoreNonResolvableArtifacts(pluginParameters)) {
                this.getLog().warn((CharSequence)message);
            } else {
                throw new MojoFailureException(message);
            }
        }
    }

    private void breakBuildIfNecessary(List<JApiClass> jApiClasses, Parameter parameterParam, VersionChange versionChange, Options options, JarArchiveComparator jarArchiveComparator) throws MojoFailureException {
        if (this.breakBuildOnModificationsParameter(parameterParam)) {
            for (JApiClass jApiClass : jApiClasses) {
                if (jApiClass.getChangeStatus() == JApiChangeStatus.UNCHANGED) continue;
                throw new MojoFailureException(String.format("Breaking the build because there is at least one modified class: %s", jApiClass.getFullyQualifiedName()));
            }
        }
        this.breakBuildIfNecessary(jApiClasses, parameterParam, options, jarArchiveComparator);
        if (this.breakBuildBasedOnSemanticVersioning(parameterParam)) {
            VersionChange.ChangeType changeType = versionChange.computeChangeType();
            SemverOut semverOut = new SemverOut(options, jApiClasses);
            String semver = semverOut.generate();
            if (changeType == VersionChange.ChangeType.MINOR && semver.equals("1.0.0")) {
                throw new MojoFailureException("Versions of archives indicate a minor change but binary incompatible changes found.");
            }
            if (changeType == VersionChange.ChangeType.PATCH && semver.equals("1.0.0")) {
                throw new MojoFailureException("Versions of archives indicate a patch change but binary incompatible changes found.");
            }
            if (changeType == VersionChange.ChangeType.PATCH && semver.equals("0.1.0")) {
                throw new MojoFailureException("Versions of archives indicate a patch change but binary compatible changes found.");
            }
            if (changeType == VersionChange.ChangeType.UNCHANGED && semver.equals("1.0.0")) {
                throw new MojoFailureException("Versions of archives indicate no API changes but binary incompatible changes found.");
            }
            if (changeType == VersionChange.ChangeType.UNCHANGED && semver.equals("0.1.0")) {
                throw new MojoFailureException("Versions of archives indicate no API changes but binary compatible changes found.");
            }
            if (changeType == VersionChange.ChangeType.UNCHANGED && semver.equals("0.0.1")) {
                throw new MojoFailureException("Versions of archives indicate no API changes but found API changes.");
            }
        }
    }

    void breakBuildIfNecessary(List<JApiClass> jApiClasses, Parameter parameterParam, final Options options, final JarArchiveComparator jarArchiveComparator) throws MojoFailureException {
        final StringBuilder sb = new StringBuilder();
        final BreakBuildResult breakBuildResult = new BreakBuildResult(this.breakBuildOnBinaryIncompatibleModifications(parameterParam), this.breakBuildOnSourceIncompatibleModifications(parameterParam));
        final boolean breakBuildIfCausedByExclusion = parameterParam.isBreakBuildIfCausedByExclusion();
        japicmp.output.Filter.filter(jApiClasses, (Filter.FilterVisitor)new Filter.FilterVisitor(){

            public void visit(Iterator<JApiClass> iterator, JApiClass jApiClass) {
                for (JApiCompatibilityChange jApiCompatibilityChange : jApiClass.getCompatibilityChanges()) {
                    if (jApiCompatibilityChange.isBinaryCompatible() && jApiCompatibilityChange.isSourceCompatible()) continue;
                    if (!jApiCompatibilityChange.isBinaryCompatible()) {
                        breakBuildResult.binaryIncompatibleChanges = true;
                    }
                    if (!jApiCompatibilityChange.isSourceCompatible()) {
                        breakBuildResult.sourceIncompatibleChanges = true;
                    }
                    if (sb.length() > 1) {
                        sb.append(',');
                    }
                    sb.append(jApiClass.getFullyQualifiedName()).append(":").append(jApiCompatibilityChange.name());
                }
            }

            public void visit(Iterator<JApiMethod> iterator, JApiMethod jApiMethod) {
                for (JApiCompatibilityChange jApiCompatibilityChange : jApiMethod.getCompatibilityChanges()) {
                    if (jApiCompatibilityChange.isBinaryCompatible() && jApiCompatibilityChange.isSourceCompatible()) continue;
                    if (!jApiCompatibilityChange.isBinaryCompatible() && this.breakBuildIfCausedByExclusion(jApiMethod)) {
                        breakBuildResult.binaryIncompatibleChanges = true;
                    }
                    if (!jApiCompatibilityChange.isSourceCompatible() && this.breakBuildIfCausedByExclusion(jApiMethod)) {
                        breakBuildResult.sourceIncompatibleChanges = true;
                    }
                    if (sb.length() > 1) {
                        sb.append(',');
                    }
                    sb.append(jApiMethod.getjApiClass().getFullyQualifiedName()).append(".").append(jApiMethod.getName()).append("(").append(JApiCmpMojo.this.methodParameterToList((JApiBehavior)jApiMethod)).append(")").append(":").append(jApiCompatibilityChange.name());
                }
            }

            private boolean breakBuildIfCausedByExclusion(JApiMethod jApiMethod) {
                if (!breakBuildIfCausedByExclusion) {
                    JApiReturnType returnType = jApiMethod.getReturnType();
                    String oldType = returnType.getOldReturnType();
                    try {
                        Optional ctClassOptional = jarArchiveComparator.loadClass(JarArchiveComparator.ArchiveType.OLD, oldType);
                        if (ctClassOptional.isPresent() && this.classExcluded((CtClass)ctClassOptional.get())) {
                            return false;
                        }
                    }
                    catch (Exception e) {
                        JApiCmpMojo.this.getLog().warn((CharSequence)("Failed to load class " + oldType + ": " + e.getMessage()), (Throwable)e);
                    }
                    String newType = returnType.getNewReturnType();
                    try {
                        Optional ctClassOptional = jarArchiveComparator.loadClass(JarArchiveComparator.ArchiveType.NEW, newType);
                        if (ctClassOptional.isPresent() && this.classExcluded((CtClass)ctClassOptional.get())) {
                            return false;
                        }
                    }
                    catch (Exception e) {
                        JApiCmpMojo.this.getLog().warn((CharSequence)("Failed to load class " + newType + ": " + e.getMessage()), (Throwable)e);
                    }
                }
                return true;
            }

            public void visit(Iterator<JApiConstructor> iterator, JApiConstructor jApiConstructor) {
                for (JApiCompatibilityChange jApiCompatibilityChange : jApiConstructor.getCompatibilityChanges()) {
                    if (jApiCompatibilityChange.isBinaryCompatible() && jApiCompatibilityChange.isSourceCompatible()) continue;
                    if (!jApiCompatibilityChange.isBinaryCompatible()) {
                        breakBuildResult.binaryIncompatibleChanges = true;
                    }
                    if (!jApiCompatibilityChange.isSourceCompatible()) {
                        breakBuildResult.sourceIncompatibleChanges = true;
                    }
                    if (sb.length() > 1) {
                        sb.append(',');
                    }
                    sb.append(jApiConstructor.getjApiClass().getFullyQualifiedName()).append(".").append(jApiConstructor.getName()).append("(").append(JApiCmpMojo.this.methodParameterToList((JApiBehavior)jApiConstructor)).append(")").append(":").append(jApiCompatibilityChange.name());
                }
            }

            public void visit(Iterator<JApiImplementedInterface> iterator, JApiImplementedInterface jApiImplementedInterface) {
                for (JApiCompatibilityChange jApiCompatibilityChange : jApiImplementedInterface.getCompatibilityChanges()) {
                    if (jApiCompatibilityChange.isBinaryCompatible() && jApiCompatibilityChange.isSourceCompatible()) continue;
                    if (!jApiCompatibilityChange.isBinaryCompatible() && this.breakBuildIfCausedByExclusion(jApiImplementedInterface)) {
                        breakBuildResult.binaryIncompatibleChanges = true;
                    }
                    if (!jApiCompatibilityChange.isSourceCompatible() && this.breakBuildIfCausedByExclusion(jApiImplementedInterface)) {
                        breakBuildResult.sourceIncompatibleChanges = true;
                    }
                    if (sb.length() > 1) {
                        sb.append(',');
                    }
                    sb.append(jApiImplementedInterface.getFullyQualifiedName()).append("[").append(jApiImplementedInterface.getFullyQualifiedName()).append("]").append(":").append(jApiCompatibilityChange.name());
                }
            }

            private boolean breakBuildIfCausedByExclusion(JApiImplementedInterface jApiImplementedInterface) {
                CtClass ctClass;
                return breakBuildIfCausedByExclusion || !this.classExcluded(ctClass = jApiImplementedInterface.getCtClass());
            }

            public void visit(Iterator<JApiField> iterator, JApiField jApiField) {
                for (JApiCompatibilityChange jApiCompatibilityChange : jApiField.getCompatibilityChanges()) {
                    if (jApiCompatibilityChange.isBinaryCompatible() && jApiCompatibilityChange.isSourceCompatible()) continue;
                    if (!jApiCompatibilityChange.isBinaryCompatible() && this.breakBuildIfCausedByExclusion(jApiField)) {
                        breakBuildResult.binaryIncompatibleChanges = true;
                    }
                    if (!jApiCompatibilityChange.isSourceCompatible() && this.breakBuildIfCausedByExclusion(jApiField)) {
                        breakBuildResult.sourceIncompatibleChanges = true;
                    }
                    if (sb.length() > 1) {
                        sb.append(',');
                    }
                    sb.append(jApiField.getjApiClass().getFullyQualifiedName()).append(".").append(jApiField.getName()).append(":").append(jApiCompatibilityChange.name());
                }
            }

            private boolean breakBuildIfCausedByExclusion(JApiField jApiField) {
                if (!breakBuildIfCausedByExclusion) {
                    Optional newTypeOptional;
                    JApiType type = jApiField.getType();
                    Optional oldTypeOptional = type.getOldTypeOptional();
                    if (oldTypeOptional.isPresent()) {
                        String oldType = (String)oldTypeOptional.get();
                        try {
                            Optional ctClassOptional = jarArchiveComparator.loadClass(JarArchiveComparator.ArchiveType.OLD, oldType);
                            if (ctClassOptional.isPresent() && this.classExcluded((CtClass)ctClassOptional.get())) {
                                return false;
                            }
                        }
                        catch (Exception e) {
                            JApiCmpMojo.this.getLog().warn((CharSequence)("Failed to load class " + oldType + ": " + e.getMessage()), (Throwable)e);
                        }
                    }
                    if ((newTypeOptional = type.getNewTypeOptional()).isPresent()) {
                        String newType = (String)newTypeOptional.get();
                        try {
                            Optional ctClassOptional = jarArchiveComparator.loadClass(JarArchiveComparator.ArchiveType.NEW, newType);
                            if (ctClassOptional.isPresent() && this.classExcluded((CtClass)ctClassOptional.get())) {
                                return false;
                            }
                        }
                        catch (Exception e) {
                            JApiCmpMojo.this.getLog().warn((CharSequence)("Failed to load class " + newType + ": " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
                return true;
            }

            public void visit(Iterator<JApiAnnotation> iterator, JApiAnnotation jApiAnnotation) {
            }

            public void visit(JApiSuperclass jApiSuperclass) {
                for (JApiCompatibilityChange jApiCompatibilityChange : jApiSuperclass.getCompatibilityChanges()) {
                    if (jApiCompatibilityChange.isBinaryCompatible() && jApiCompatibilityChange.isSourceCompatible()) continue;
                    if (!jApiCompatibilityChange.isBinaryCompatible() && this.breakBuildIfCausedByExclusion(jApiSuperclass)) {
                        breakBuildResult.binaryIncompatibleChanges = true;
                    }
                    if (!jApiCompatibilityChange.isSourceCompatible() && this.breakBuildIfCausedByExclusion(jApiSuperclass)) {
                        breakBuildResult.sourceIncompatibleChanges = true;
                    }
                    if (sb.length() > 1) {
                        sb.append(',');
                    }
                    sb.append(jApiSuperclass.getJApiClassOwning().getFullyQualifiedName()).append(":").append(jApiCompatibilityChange.name());
                }
            }

            private boolean breakBuildIfCausedByExclusion(JApiSuperclass jApiSuperclass) {
                if (!breakBuildIfCausedByExclusion) {
                    CtClass ctClass;
                    CtClass ctClass2;
                    Optional oldSuperclassOptional = jApiSuperclass.getOldSuperclass();
                    if (oldSuperclassOptional.isPresent() && this.classExcluded(ctClass2 = (CtClass)oldSuperclassOptional.get())) {
                        return false;
                    }
                    Optional newSuperclassOptional = jApiSuperclass.getNewSuperclass();
                    if (newSuperclassOptional.isPresent() && this.classExcluded(ctClass = (CtClass)newSuperclassOptional.get())) {
                        return false;
                    }
                }
                return true;
            }

            private boolean classExcluded(CtClass ctClass) {
                List excludes = options.getExcludes();
                for (Filter exclude : excludes) {
                    ClassFilter classFilter;
                    if (!(exclude instanceof ClassFilter) || !(classFilter = (ClassFilter)exclude).matches(ctClass)) continue;
                    return true;
                }
                return false;
            }
        });
        if (breakBuildResult.breakTheBuild()) {
            throw new MojoFailureException(String.format("Breaking the build because there is at least one incompatibility: %s", sb.toString()));
        }
    }

    private String methodParameterToList(JApiBehavior jApiMethod) {
        StringBuilder sb = new StringBuilder();
        for (JApiParameter jApiParameter : jApiMethod.getParameters()) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(jApiParameter.getType());
        }
        return sb.toString();
    }

    Options getOptions(PluginParameters pluginParameters, MavenParameters mavenParameters) throws MojoFailureException {
        if (this.options != null) {
            return this.options;
        }
        this.options = Options.newDefault();
        this.populateArchivesListsFromParameters(pluginParameters, mavenParameters, this.options.getOldArchives(), this.options.getNewArchives());
        Parameter parameterParam = pluginParameters.getParameterParam();
        if (parameterParam != null) {
            String noAnnotationsString;
            String htmlStylesheet;
            List<String> ignoreMissingClassesByRegularExpressions;
            String ignoreMissingClassesString;
            String string;
            List<String> includes;
            List<String> excludes;
            String onlyModified;
            String onlyBinaryIncompatible;
            String accessModifierArg = parameterParam.getAccessModifier();
            if (accessModifierArg != null) {
                try {
                    AccessModifier accessModifier = AccessModifier.valueOf((String)accessModifierArg.toUpperCase());
                    this.options.setAccessModifier(accessModifier);
                }
                catch (IllegalArgumentException e) {
                    throw new MojoFailureException(String.format("Invalid value for option accessModifier: %s. Possible values are: %s.", accessModifierArg, AccessModifier.listOfAccessModifier()));
                }
            }
            if ((onlyBinaryIncompatible = parameterParam.getOnlyBinaryIncompatible()) != null) {
                Boolean booleanOnlyBinaryIncompatible = Boolean.valueOf(onlyBinaryIncompatible);
                this.options.setOutputOnlyBinaryIncompatibleModifications(booleanOnlyBinaryIncompatible.booleanValue());
            }
            if ((onlyModified = parameterParam.getOnlyModified()) != null) {
                Boolean booleanOnlyModified = Boolean.valueOf(onlyModified);
                this.options.setOutputOnlyModifications(booleanOnlyModified.booleanValue());
            }
            if ((excludes = parameterParam.getExcludes()) != null) {
                for (String string2 : excludes) {
                    this.options.addExcludeFromArgument(Optional.fromNullable((Object)string2));
                }
            }
            if ((includes = parameterParam.getIncludes()) != null) {
                for (String include : includes) {
                    this.options.addIncludeFromArgument(Optional.fromNullable((Object)include));
                }
            }
            if ((string = parameterParam.getIncludeSynthetic()) != null) {
                Boolean includeSynthetic = Boolean.valueOf(string);
                this.options.setIncludeSynthetic(includeSynthetic.booleanValue());
            }
            if ((ignoreMissingClassesString = parameterParam.getIgnoreMissingClasses()) != null) {
                Boolean ignoreMissingClasses = Boolean.valueOf(ignoreMissingClassesString);
                this.options.setIgnoreMissingClasses(ignoreMissingClasses.booleanValue());
            }
            if ((ignoreMissingClassesByRegularExpressions = parameterParam.getIgnoreMissingClassesByRegularExpressions()) != null) {
                for (String ignoreMissingClassRegularExpression : ignoreMissingClassesByRegularExpressions) {
                    this.options.addIgnoreMissingClassRegularExpression(ignoreMissingClassRegularExpression);
                }
            }
            if ((htmlStylesheet = parameterParam.getHtmlStylesheet()) != null) {
                this.options.setHtmlStylesheet(Optional.of((Object)htmlStylesheet));
            }
            if ((noAnnotationsString = parameterParam.getNoAnnotations()) != null) {
                Boolean noAnnotations = Boolean.valueOf(noAnnotationsString);
                this.options.setNoAnnotations(noAnnotations.booleanValue());
            }
        }
        return this.options;
    }

    private boolean breakBuildOnModificationsParameter(Parameter parameterParam) {
        boolean retVal = false;
        if (parameterParam != null) {
            retVal = Boolean.valueOf(parameterParam.getBreakBuildOnModifications());
        }
        return retVal;
    }

    private boolean breakBuildOnBinaryIncompatibleModifications(Parameter parameterParam) {
        boolean retVal = false;
        if (parameterParam != null) {
            retVal = Boolean.valueOf(parameterParam.getBreakBuildOnBinaryIncompatibleModifications());
        }
        return retVal;
    }

    private boolean breakBuildOnSourceIncompatibleModifications(Parameter parameter) {
        boolean retVal = false;
        if (parameter != null) {
            retVal = Boolean.valueOf(parameter.getBreakBuildOnSourceIncompatibleModifications());
        }
        return retVal;
    }

    private boolean breakBuildBasedOnSemanticVersioning(Parameter parameter) {
        boolean retVal = false;
        if (parameter != null) {
            retVal = Boolean.valueOf(parameter.getBreakBuildBasedOnSemanticVersioning());
        }
        return retVal;
    }

    private File createJapiCmpBaseDir(PluginParameters pluginParameters) throws MojoFailureException {
        if (pluginParameters.getProjectBuildDirParam().isPresent()) {
            try {
                File projectBuildDirParam = (File)pluginParameters.getProjectBuildDirParam().get();
                if (projectBuildDirParam != null) {
                    File jApiCmpBuildDir = new File(projectBuildDirParam.getCanonicalPath() + File.separator + "japicmp");
                    boolean mkdirs = jApiCmpBuildDir.mkdirs();
                    if (mkdirs || jApiCmpBuildDir.isDirectory() && jApiCmpBuildDir.canWrite()) {
                        return jApiCmpBuildDir;
                    }
                    throw new MojoFailureException(String.format("Failed to create directory '%s'.", jApiCmpBuildDir.getAbsolutePath()));
                }
                throw new MojoFailureException("Maven parameter projectBuildDir is not set.");
            }
            catch (IOException e) {
                throw new MojoFailureException("Failed to create output directory: " + e.getMessage(), (Throwable)e);
            }
        }
        if (pluginParameters.getOutputDirectory().isPresent()) {
            String outputDirectory = (String)pluginParameters.getOutputDirectory().get();
            if (outputDirectory != null) {
                File outputDirFile = new File(outputDirectory);
                boolean mkdirs = outputDirFile.mkdirs();
                if (mkdirs || outputDirFile.isDirectory() && outputDirFile.canWrite()) {
                    return outputDirFile;
                }
                throw new MojoFailureException(String.format("Failed to create directory '%s'.", outputDirFile.getAbsolutePath()));
            }
            throw new MojoFailureException("Maven parameter outputDirectory is not set.");
        }
        throw new MojoFailureException("None of the two parameters projectBuildDir and outputDirectory are present");
    }

    private void generateDiffOutput(MavenParameters mavenParameters, PluginParameters pluginParameters, Options options, List<JApiClass> jApiClasses, File jApiCmpBuildDir) throws IOException, MojoFailureException {
        boolean skipDiffReport = false;
        if (pluginParameters.getParameterParam() != null) {
            skipDiffReport = pluginParameters.getParameterParam().isSkipDiffReport();
        }
        if (!skipDiffReport) {
            StdoutOutputGenerator stdoutOutputGenerator = new StdoutOutputGenerator(options, jApiClasses);
            String diffOutput = stdoutOutputGenerator.generate();
            File output = new File(jApiCmpBuildDir.getCanonicalPath() + File.separator + this.createFilename(mavenParameters) + ".diff");
            this.writeToFile(diffOutput, output);
        }
    }

    private XmlOutput generateXmlOutput(List<JApiClass> jApiClasses, File jApiCmpBuildDir, Options options, MavenParameters mavenParameters, PluginParameters pluginParameters) throws IOException, MojoFailureException {
        String filename = this.createFilename(mavenParameters);
        if (!this.skipXmlReport(pluginParameters)) {
            options.setXmlOutputFile(Optional.of((Object)(jApiCmpBuildDir.getCanonicalPath() + File.separator + filename + ".xml")));
        }
        if (!this.skipHtmlReport(pluginParameters)) {
            options.setHtmlOutputFile(Optional.of((Object)(jApiCmpBuildDir.getCanonicalPath() + File.separator + filename + ".html")));
        }
        SemverOut semverOut = new SemverOut(options, jApiClasses);
        XmlOutputGeneratorOptions xmlOutputGeneratorOptions = new XmlOutputGeneratorOptions();
        xmlOutputGeneratorOptions.setCreateSchemaFile(true);
        xmlOutputGeneratorOptions.setSemanticVersioningInformation(semverOut.generate());
        if (pluginParameters.getParameterParam() != null) {
            xmlOutputGeneratorOptions.setTitle(pluginParameters.getParameterParam().getHtmlTitle());
        }
        XmlOutputGenerator xmlGenerator = new XmlOutputGenerator(jApiClasses, options, xmlOutputGeneratorOptions);
        return xmlGenerator.generate();
    }

    private boolean skipHtmlReport(PluginParameters pluginParameters) {
        boolean skipReport = false;
        if (pluginParameters.getParameterParam() != null) {
            skipReport = Boolean.valueOf(pluginParameters.getParameterParam().getSkipHtmlReport());
        }
        return skipReport;
    }

    private boolean skipXmlReport(PluginParameters pluginParameters) {
        boolean skipReport = false;
        if (pluginParameters.getParameterParam() != null) {
            skipReport = Boolean.valueOf(pluginParameters.getParameterParam().getSkipXmlReport());
        }
        return skipReport;
    }

    private String createFilename(MavenParameters mavenParameters) {
        String filename = "japicmp";
        String executionId = mavenParameters.getMojoExecution().getExecutionId();
        if (executionId != null && !"default".equals(executionId)) {
            filename = executionId;
        }
        return filename;
    }

    private void setUpClassPath(JarArchiveComparatorOptions comparatorOptions, PluginParameters pluginParameters, MavenParameters mavenParameters) throws MojoFailureException {
        if (pluginParameters != null) {
            if (pluginParameters.getDependenciesParam() != null) {
                if (pluginParameters.getOldClassPathDependencies() != null || pluginParameters.getNewClassPathDependencies() != null) {
                    throw new MojoFailureException("Please specify either a <dependencies/> element or the two elements <oldClassPathDependencies/> and <newClassPathDependencies/>. With <dependencies/> you can specify one common classpath for both versions and with <oldClassPathDependencies/> and <newClassPathDependencies/> a separate classpath for the new and old version.");
                }
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Element <dependencies/> found. Using " + JApiCli.ClassPathMode.ONE_COMMON_CLASSPATH));
                }
                for (Dependency dependency : pluginParameters.getDependenciesParam()) {
                    List<File> files = this.resolveDependencyToFile("dependencies", dependency, mavenParameters, true, pluginParameters, ConfigurationVersion.NEW);
                    for (File file : files) {
                        comparatorOptions.getClassPathEntries().add(file.getAbsolutePath());
                    }
                    comparatorOptions.setClassPathMode(JarArchiveComparatorOptions.ClassPathMode.ONE_COMMON_CLASSPATH);
                }
            } else if (pluginParameters.getOldClassPathDependencies() != null || pluginParameters.getNewClassPathDependencies() != null) {
                List<File> files;
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("At least one of the elements <oldClassPathDependencies/> or <newClassPathDependencies/> found. Using " + JApiCli.ClassPathMode.TWO_SEPARATE_CLASSPATHS));
                }
                if (pluginParameters.getOldClassPathDependencies() != null) {
                    for (Dependency dependency : pluginParameters.getOldClassPathDependencies()) {
                        files = this.resolveDependencyToFile("oldClassPathDependencies", dependency, mavenParameters, true, pluginParameters, ConfigurationVersion.OLD);
                        for (File file : files) {
                            comparatorOptions.getOldClassPath().add(file.getAbsolutePath());
                        }
                    }
                }
                if (pluginParameters.getNewClassPathDependencies() != null) {
                    for (Dependency dependency : pluginParameters.getNewClassPathDependencies()) {
                        files = this.resolveDependencyToFile("newClassPathDependencies", dependency, mavenParameters, true, pluginParameters, ConfigurationVersion.NEW);
                        for (File file : files) {
                            comparatorOptions.getNewClassPath().add(file.getAbsolutePath());
                        }
                    }
                }
                comparatorOptions.setClassPathMode(JarArchiveComparatorOptions.ClassPathMode.TWO_SEPARATE_CLASSPATHS);
            } else {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("None of the elements <oldClassPathDependencies/>, <newClassPathDependencies/> or <dependencies/> found. Using " + JApiCli.ClassPathMode.ONE_COMMON_CLASSPATH));
                }
                comparatorOptions.setClassPathMode(JarArchiveComparatorOptions.ClassPathMode.ONE_COMMON_CLASSPATH);
            }
        }
        this.setUpClassPathUsingMavenProject(comparatorOptions, mavenParameters, pluginParameters, ConfigurationVersion.NEW);
    }

    private void setUpClassPathUsingMavenProject(JarArchiveComparatorOptions comparatorOptions, MavenParameters mavenParameters, PluginParameters pluginParameters, ConfigurationVersion configurationVersion) throws MojoFailureException {
        JApiCmpMojo.notNull(mavenParameters.getMavenProject(), "Maven parameter mavenProject should be provided by maven container.");
        Set dependencyArtifacts = mavenParameters.getMavenProject().getArtifacts();
        HashSet<String> classPathEntries = new HashSet<String>();
        for (Artifact artifact : dependencyArtifacts) {
            String scope = artifact.getScope();
            if ("test".equals(scope) || artifact.isOptional()) continue;
            Set<Artifact> artifacts = this.resolveArtifact(artifact, mavenParameters, false, pluginParameters, configurationVersion);
            for (Artifact resolvedArtifact : artifacts) {
                String absolutePath;
                File resolvedFile = resolvedArtifact.getFile();
                if (resolvedFile == null || classPathEntries.contains(absolutePath = resolvedFile.getAbsolutePath())) continue;
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Adding to classpath: " + absolutePath + "; scope: " + scope));
                }
                classPathEntries.add(absolutePath);
            }
        }
        for (String classPathEntry : classPathEntries) {
            comparatorOptions.getClassPathEntries().add(classPathEntry);
        }
    }

    private List<File> retrieveFileFromConfiguration(DependencyDescriptor dependencyDescriptor, String parameterName, MavenParameters mavenParameters, PluginParameters pluginParameters, ConfigurationVersion configurationVersion) throws MojoFailureException {
        List<File> files;
        if (dependencyDescriptor instanceof Dependency) {
            Dependency dependency = (Dependency)dependencyDescriptor;
            files = this.resolveDependencyToFile(parameterName, dependency, mavenParameters, false, pluginParameters, configurationVersion);
        } else if (dependencyDescriptor instanceof ConfigurationFile) {
            ConfigurationFile configurationFile = (ConfigurationFile)dependencyDescriptor;
            files = this.resolveConfigurationFileToFile(parameterName, configurationFile, configurationVersion, pluginParameters);
        } else {
            throw new MojoFailureException("DependencyDescriptor is not of type <dependency/> nor of type <configurationFile/>.");
        }
        return files;
    }

    private List<File> retrieveFileFromConfiguration(Version version, String parameterName, MavenParameters mavenParameters, PluginParameters pluginParameters, ConfigurationVersion configurationVersion) throws MojoFailureException {
        if (version != null) {
            Dependency dependency = version.getDependency();
            if (dependency != null) {
                return this.resolveDependencyToFile(parameterName, dependency, mavenParameters, false, pluginParameters, configurationVersion);
            }
            if (version.getFile() != null) {
                ConfigurationFile configurationFile = version.getFile();
                return this.resolveConfigurationFileToFile(parameterName, configurationFile, configurationVersion, pluginParameters);
            }
            throw new MojoFailureException("Missing configuration parameter 'dependency'.");
        }
        throw new MojoFailureException(String.format("Missing configuration parameter: %s", parameterName));
    }

    private List<File> resolveConfigurationFileToFile(String parameterName, ConfigurationFile configurationFile, ConfigurationVersion configurationVersion, PluginParameters pluginParameters) throws MojoFailureException {
        String path = configurationFile.getPath();
        if (path == null) {
            throw new MojoFailureException(String.format("The path element in the configuration of the plugin is missing for %s.", parameterName));
        }
        File file = new File(path);
        if (!file.exists()) {
            if (configurationVersion == ConfigurationVersion.OLD && this.ignoreMissingOldVersion(pluginParameters)) {
                this.getLog().warn((CharSequence)("Could not find file, but ignoreMissingOldVersion is set tot true: " + file.getAbsolutePath()));
            } else {
                throw new MojoFailureException(String.format("The path '%s' does not point to an existing file.", path));
            }
        }
        if (!file.isFile() || !file.canRead()) {
            if (configurationVersion == ConfigurationVersion.OLD && this.ignoreMissingOldVersion(pluginParameters)) {
                this.getLog().warn((CharSequence)("The file given by path '" + file.getAbsolutePath() + "' is either not a file or is not readable, but ignoreMissingOldVersion is set tot true"));
            } else {
                throw new MojoFailureException(String.format("The file given by path '%s' is either not a file or is not readable.", path));
            }
        }
        return Collections.singletonList(file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<File> resolveDependencyToFile(String parameterName, Dependency dependency, MavenParameters mavenParameters, boolean transitively, PluginParameters pluginParameters, ConfigurationVersion configurationVersion) throws MojoFailureException {
        ArrayList<File> files = new ArrayList<File>();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Trying to resolve dependency '" + dependency + "' to file."));
        }
        if (dependency.getSystemPath() == null) {
            String descriptor = dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion();
            this.getLog().debug((CharSequence)(parameterName + ": " + descriptor));
            Set<Artifact> artifacts = this.resolveArtifact(dependency, mavenParameters, transitively, pluginParameters, configurationVersion);
            for (Artifact artifact : artifacts) {
                if (artifact.isOptional()) continue;
                File file = artifact.getFile();
                if (file == null) throw new MojoFailureException(String.format("Could not resolve dependency with descriptor '%s'.", descriptor));
                files.add(file);
            }
            if (files.size() != 0) return files;
            String message = String.format("Could not resolve dependency with descriptor '%s'.", descriptor);
            if (!this.ignoreNonResolvableArtifacts(pluginParameters) && !this.ignoreMissingOldVersion(pluginParameters, configurationVersion)) throw new MojoFailureException(message);
            this.getLog().warn((CharSequence)message);
            return files;
        } else {
            String systemPath = dependency.getSystemPath();
            Pattern pattern = Pattern.compile("\\$\\{([^\\}])");
            Matcher matcher = pattern.matcher(systemPath);
            if (matcher.matches()) {
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    String property = matcher.group(i);
                    String propertyResolved = mavenParameters.getMavenProject().getProperties().getProperty(property);
                    if (propertyResolved == null) {
                        throw new MojoFailureException("Could not resolve property '" + property + "'.");
                    }
                    systemPath = systemPath.replaceAll("${" + property + "}", propertyResolved);
                }
            }
            File file = new File(systemPath);
            boolean addFile = true;
            if (!file.exists()) {
                if (configurationVersion != ConfigurationVersion.OLD || !this.ignoreMissingOldVersion(pluginParameters)) {
                    throw new MojoFailureException("File '" + file.getAbsolutePath() + "' does not exist.");
                }
                this.getLog().warn((CharSequence)("Could not find file, but ignoreMissingOldVersion is set tot true: " + file.getAbsolutePath()));
                addFile = false;
            }
            if (!file.canRead()) {
                if (configurationVersion != ConfigurationVersion.OLD || !this.ignoreMissingOldVersion(pluginParameters)) {
                    throw new MojoFailureException("File '" + file.getAbsolutePath() + "' is not readable.");
                }
                this.getLog().warn((CharSequence)("File is not readable, but ignoreMissingOldVersion is set tot true: " + file.getAbsolutePath()));
                addFile = false;
            }
            if (!addFile) return files;
            files.add(file);
        }
        return files;
    }

    private boolean ignoreMissingOldVersion(PluginParameters pluginParameters) {
        boolean ignoreMissingOldVersion = false;
        if (pluginParameters.getParameterParam() != null) {
            ignoreMissingOldVersion = Boolean.valueOf(pluginParameters.getParameterParam().getIgnoreMissingOldVersion());
        }
        return ignoreMissingOldVersion;
    }

    private void writeToFile(String output, File outputfile) throws MojoFailureException, IOException {
        try (OutputStreamWriter fileWriter = null;){
            fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(outputfile), Charset.forName("UTF-8"));
            fileWriter.write(output);
            this.getLog().info((CharSequence)("Written file '" + outputfile.getAbsolutePath() + "'."));
        }
    }

    private Set<Artifact> resolveArtifact(Dependency dependency, MavenParameters mavenParameters, boolean transitively, PluginParameters pluginParameters, ConfigurationVersion configurationVersion) throws MojoFailureException {
        JApiCmpMojo.notNull(mavenParameters.getArtifactRepositories(), "Maven parameter artifactRepositories should be provided by maven container.");
        Artifact artifact = mavenParameters.getArtifactFactory().createArtifactWithClassifier(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType(), dependency.getClassifier());
        return this.resolveArtifact(artifact, mavenParameters, transitively, pluginParameters, configurationVersion);
    }

    private Set<Artifact> resolveArtifact(Artifact artifact, MavenParameters mavenParameters, boolean transitively, PluginParameters pluginParameters, ConfigurationVersion configurationVersion) throws MojoFailureException {
        Set artifacts;
        String message;
        ArtifactResolutionResult resolutionResult;
        JApiCmpMojo.notNull(mavenParameters.getLocalRepository(), "Maven parameter localRepository should be provided by maven container.");
        JApiCmpMojo.notNull(mavenParameters.getArtifactResolver(), "Maven parameter artifactResolver should be provided by maven container.");
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        request.setLocalRepository(mavenParameters.getLocalRepository());
        request.setRemoteRepositories(mavenParameters.getArtifactRepositories());
        request.setResolutionFilter(new ArtifactFilter(){

            public boolean include(Artifact artifact) {
                boolean include = true;
                if (artifact != null && artifact.isOptional()) {
                    include = false;
                }
                return include;
            }
        });
        if (transitively) {
            request.setResolveTransitively(true);
        }
        if ((resolutionResult = mavenParameters.getArtifactResolver().resolve(request)).hasExceptions()) {
            List exceptions = resolutionResult.getExceptions();
            message = "Could not resolve " + artifact;
            if (this.ignoreNonResolvableArtifacts(pluginParameters) || this.ignoreMissingOldVersion(pluginParameters, configurationVersion)) {
                this.getLog().warn((CharSequence)message);
            } else {
                throw new MojoFailureException(message, (Throwable)exceptions.get(0));
            }
        }
        if ((artifacts = resolutionResult.getArtifacts()).size() == 0) {
            message = "Could not resolve " + artifact;
            if (this.ignoreNonResolvableArtifacts(pluginParameters) || this.ignoreMissingOldVersion(pluginParameters, configurationVersion)) {
                this.getLog().warn((CharSequence)message);
            } else {
                throw new MojoFailureException(message);
            }
        }
        return artifacts;
    }

    private boolean ignoreMissingOldVersion(PluginParameters pluginParameters, ConfigurationVersion configurationVersion) {
        return configurationVersion == ConfigurationVersion.OLD && this.ignoreMissingOldVersion(pluginParameters);
    }

    private boolean ignoreNonResolvableArtifacts(PluginParameters pluginParameters) {
        boolean ignoreNonResolvableArtifacts = false;
        Parameter parameterParam = pluginParameters.getParameterParam();
        if (parameterParam != null) {
            String ignoreNonResolvableArtifactsAsString = parameterParam.getIgnoreNonResolvableArtifacts();
            if (Boolean.TRUE.toString().equalsIgnoreCase(ignoreNonResolvableArtifactsAsString)) {
                ignoreNonResolvableArtifacts = true;
            }
        }
        return ignoreNonResolvableArtifacts;
    }

    private static <T> T notNull(T value, String msg) throws MojoFailureException {
        if (value == null) {
            throw new MojoFailureException(msg);
        }
        return value;
    }

    private static class BreakBuildResult {
        private final boolean breakBuildOnBinaryIncompatibleModifications;
        private final boolean breakBuildOnSourceIncompatibleModifications;
        boolean binaryIncompatibleChanges = false;
        boolean sourceIncompatibleChanges = false;

        public BreakBuildResult(boolean breakBuildOnBinaryIncompatibleModifications, boolean breakBuildOnSourceIncompatibleModifications) {
            this.breakBuildOnBinaryIncompatibleModifications = breakBuildOnBinaryIncompatibleModifications;
            this.breakBuildOnSourceIncompatibleModifications = breakBuildOnSourceIncompatibleModifications;
        }

        public boolean breakTheBuild() {
            return this.binaryIncompatibleChanges && this.breakBuildOnBinaryIncompatibleModifications || this.sourceIncompatibleChanges && this.breakBuildOnSourceIncompatibleModifications;
        }
    }

    private static enum ConfigurationVersion {
        OLD,
        NEW;

    }
}

