/*
 * Decompiled with CFR 0.152.
 */
package japicmp.maven;

import com.google.common.base.Optional;
import japicmp.config.Options;
import japicmp.maven.Dependency;
import japicmp.maven.DependencyDescriptor;
import japicmp.maven.JApiCmpMojo;
import japicmp.maven.MavenParameters;
import japicmp.maven.Parameter;
import japicmp.maven.PluginParameters;
import japicmp.maven.Version;
import japicmp.output.xml.XmlOutput;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.List;
import java.util.Locale;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;

@Mojo(name="cmp-report", defaultPhase=LifecyclePhase.SITE)
public class JApiCmpReport
extends AbstractMavenReport {
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private Version oldVersion;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private List<DependencyDescriptor> oldVersions;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private Version newVersion;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private List<DependencyDescriptor> newVersions;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private Parameter parameter;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private List<Dependency> dependencies;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private List<Dependency> oldClassPathDependencies;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private List<Dependency> newClassPathDependencies;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private String skip;
    @org.apache.maven.plugins.annotations.Parameter(required=true, readonly=true, property="project.reporting.outputDirectory")
    private String outputDirectory;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private ArtifactResolver artifactResolver;
    @org.apache.maven.plugins.annotations.Parameter(required=true, defaultValue="${localRepository}")
    private ArtifactRepository localRepository;
    @org.apache.maven.plugins.annotations.Parameter(required=true, defaultValue="${project.remoteArtifactRepositories}")
    private List<ArtifactRepository> artifactRepositories;
    @org.apache.maven.plugins.annotations.Parameter(required=true, defaultValue="${project}")
    private MavenProject mavenProject;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${mojoExecution}", readonly=true)
    private MojoExecution mojoExecution;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="(,${project.version})", readonly=true)
    private String versionRangeWithProjectVersion;
    @Component
    private ArtifactMetadataSource metadataSource;
    private JApiCmpMojo mojo;
    private MavenParameters mavenParameters;
    private PluginParameters pluginParameters;

    protected void executeReport(Locale locale) throws MavenReportException {
        try {
            XmlOutput xmlOutput;
            JApiCmpMojo mojo = this.getMojo();
            Optional<XmlOutput> xmlOutputOptional = mojo.executeWithParameters(this.pluginParameters, this.mavenParameters);
            if (xmlOutputOptional.isPresent() && (xmlOutput = (XmlOutput)xmlOutputOptional.get()).getHtmlOutputStream().isPresent()) {
                ByteArrayOutputStream htmlOutputStream = (ByteArrayOutputStream)xmlOutput.getHtmlOutputStream().get();
                String htmlString = htmlOutputStream.toString("UTF-8");
                htmlString = htmlString.replaceAll("</?html>", "");
                htmlString = htmlString.replaceAll("</?body>", "");
                htmlString = htmlString.replaceAll("</?head>", "");
                htmlString = htmlString.replaceAll("<title>[^<]*</title>", "");
                htmlString = htmlString.replaceAll("<META[^>]*>", "");
                Sink sink = this.getSink();
                sink.rawText(htmlString);
                sink.close();
            }
        }
        catch (Exception e) {
            String msg = "Failed to generate report: " + e.getMessage();
            Sink sink = this.getSink();
            sink.text(msg);
            sink.close();
            throw new MavenReportException(msg, e);
        }
    }

    private JApiCmpMojo getMojo() throws MojoFailureException {
        if (this.mojo != null) {
            return this.mojo;
        }
        this.mojo = new JApiCmpMojo();
        this.mavenParameters = new MavenParameters(this.artifactRepositories, this.artifactFactory, this.localRepository, this.artifactResolver, this.mavenProject, this.mojoExecution, this.versionRangeWithProjectVersion, this.metadataSource);
        this.pluginParameters = new PluginParameters(this.skip, this.newVersion, this.oldVersion, this.parameter, this.dependencies, (Optional<File>)Optional.absent(), (Optional<String>)Optional.of((Object)this.outputDirectory), false, this.oldVersions, this.newVersions, this.oldClassPathDependencies, this.newClassPathDependencies);
        return this.mojo;
    }

    private Options getOptions() {
        try {
            return this.getMojo().getOptions(this.pluginParameters, this.mavenParameters);
        }
        catch (MojoFailureException ignore) {
            return null;
        }
    }

    public String getOutputName() {
        return "japicmp";
    }

    public String getName(Locale locale) {
        return "japicmp";
    }

    public String getDescription(Locale locale) {
        Options options = this.getOptions();
        if (options == null) {
            return "failed report";
        }
        StringBuilder sb = new StringBuilder().append(options.isOutputOnlyBinaryIncompatibleModifications() ? "Binary" : "Source").append(" compatibility of");
        this.appendList(sb, options.getNewArchives());
        sb.append(" against");
        this.appendList(sb, options.getOldArchives());
        return sb.toString();
    }

    private void appendList(StringBuilder sb, List<File> archives) {
        int sep = 32;
        for (File archive : archives) {
            sb.append((char)sep).append(archive.getName());
            sep = 59;
        }
    }
}

