/*
 * Decompiled with CFR 0.152.
 */
package japicmp.maven;

import com.google.common.base.Optional;
import japicmp.maven.Parameter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoFailureException;

public class VersionChange {
    private static final Pattern versionPattern = Pattern.compile(".*([0-9]+)\\.([0-9]+)\\.([0-9]+).*");
    private final List<File> oldArchives;
    private final List<File> newArchives;
    private final Parameter parameter;

    public VersionChange(List<File> oldArchives, List<File> newArchives, Parameter parameter) {
        this.oldArchives = oldArchives;
        this.newArchives = newArchives;
        this.parameter = parameter;
    }

    public Optional<ChangeType> computeChangeType() throws MojoFailureException {
        if (this.oldArchives.isEmpty()) {
            if (!"true".equalsIgnoreCase(this.parameter != null ? this.parameter.getIgnoreMissingOldVersion() : "false")) {
                throw new MojoFailureException("Please provide at least one old version.");
            }
            return Optional.absent();
        }
        if (this.newArchives.isEmpty()) {
            if (!"true".equalsIgnoreCase(this.parameter != null ? this.parameter.getIgnoreMissingNewVersion() : "false")) {
                throw new MojoFailureException("Please provide at least one new version.");
            }
            return Optional.absent();
        }
        ArrayList<SemanticVersion> oldVersions = new ArrayList<SemanticVersion>();
        ArrayList<SemanticVersion> newVersions = new ArrayList<SemanticVersion>();
        for (File file : this.oldArchives) {
            oldVersions.add(this.getVersion(file));
        }
        for (File file : this.newArchives) {
            newVersions.add(this.getVersion(file));
        }
        if (this.allVersionsTheSame(oldVersions) && this.allVersionsTheSame(newVersions)) {
            SemanticVersion oldVersion = (SemanticVersion)oldVersions.get(0);
            SemanticVersion newVersion = (SemanticVersion)newVersions.get(0);
            return oldVersion.computeChangeType(newVersion);
        }
        if (oldVersions.size() != newVersions.size()) {
            throw new MojoFailureException("Cannot compare versions because the number of old versions is different than the number of new versions.");
        }
        ArrayList<Object> changeTypes = new ArrayList<Object>();
        for (int i = 0; i < oldVersions.size(); ++i) {
            SemanticVersion semanticVersion;
            SemanticVersion oldVersion = (SemanticVersion)oldVersions.get(i);
            Optional<ChangeType> changeTypeOptional = oldVersion.computeChangeType(semanticVersion = (SemanticVersion)newVersions.get(i));
            if (!changeTypeOptional.isPresent()) continue;
            changeTypes.add(changeTypeOptional.get());
        }
        ChangeType maxRank = ChangeType.UNCHANGED;
        for (ChangeType changeType : changeTypes) {
            if (changeType.getRank() <= maxRank.getRank()) continue;
            maxRank = changeType;
        }
        return Optional.fromNullable((Object)((Object)maxRank));
    }

    private boolean allVersionsTheSame(List<SemanticVersion> versions) {
        boolean allVersionsTheSame = true;
        if (versions.size() > 1) {
            SemanticVersion firstVersion = versions.get(0);
            for (int i = 1; i < versions.size(); ++i) {
                SemanticVersion version = versions.get(i);
                if (firstVersion.equals(version)) continue;
                allVersionsTheSame = false;
                break;
            }
        }
        return allVersionsTheSame;
    }

    private SemanticVersion getVersion(File file) throws MojoFailureException {
        String name = file.getName();
        Matcher matcher = versionPattern.matcher(name);
        if (matcher.matches()) {
            if (matcher.groupCount() >= 3) {
                try {
                    int major = Integer.parseInt(matcher.group(1));
                    int minor = Integer.parseInt(matcher.group(2));
                    int patch = Integer.parseInt(matcher.group(3));
                    return new SemanticVersion(major, minor, patch);
                }
                catch (NumberFormatException e) {
                    throw new MojoFailureException(String.format("Could not convert version into three digits for file name: %s", name), (Throwable)e);
                }
            }
            throw new MojoFailureException(String.format("Could not find three digits separated by a point in file name: %s", name));
        }
        throw new MojoFailureException(String.format("Could not find three digits separated by a point in file name: %s", name));
    }

    private static class SemanticVersion {
        private final int major;
        private final int minor;
        private final int patch;

        public SemanticVersion(int major, int minor, int patch) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public int getPatch() {
            return this.patch;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SemanticVersion that = (SemanticVersion)o;
            return this.major == that.major && this.minor == that.minor && this.patch == that.patch;
        }

        public Optional<ChangeType> computeChangeType(SemanticVersion version) {
            if (this.major != version.major) {
                return Optional.of((Object)((Object)ChangeType.MAJOR));
            }
            if (this.minor != version.minor) {
                return Optional.of((Object)((Object)ChangeType.MINOR));
            }
            if (this.patch != version.patch) {
                return Optional.of((Object)((Object)ChangeType.PATCH));
            }
            return Optional.of((Object)((Object)ChangeType.UNCHANGED));
        }

        public int hashCode() {
            int result = this.major;
            result = 31 * result + this.minor;
            result = 31 * result + this.patch;
            return result;
        }
    }

    public static enum ChangeType {
        MAJOR(3),
        MINOR(2),
        PATCH(1),
        UNCHANGED(0);

        private final int rank;

        private ChangeType(int rank) {
            this.rank = rank;
        }

        public int getRank() {
            return this.rank;
        }
    }
}

