/*
 * Decompiled with CFR 0.152.
 */
package com.github.siroshun09.messages.minimessage.base;

import com.github.siroshun09.messages.api.base.ComponentMessageBase;
import com.github.siroshun09.messages.minimessage.base.BaseImpls;
import com.github.siroshun09.messages.minimessage.base.TagResolverBase;
import com.github.siroshun09.messages.minimessage.source.MiniMessageSource;
import java.util.Objects;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface MiniMessageBase
extends ComponentMessageBase<MiniMessageSource> {
    @Contract(value="_ -> new")
    @NotNull
    public static MiniMessageBase messageKey(@NotNull String messageKey) {
        return new BaseImpls.MessageKey(Objects.requireNonNull(messageKey));
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MiniMessageBase withTagResolver(@NotNull String messageKey, @NotNull TagResolver resolver) {
        return new BaseImpls.WithTagResolver1(Objects.requireNonNull(messageKey), Objects.requireNonNull(resolver));
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MiniMessageBase withTagResolver(@NotNull String messageKey, TagResolver ... resolvers) {
        return switch (resolvers.length) {
            case 0 -> MiniMessageBase.messageKey(messageKey);
            case 1 -> MiniMessageBase.withTagResolver(messageKey, resolvers[0]);
            default -> new BaseImpls.WithTagResolverN(Objects.requireNonNull(messageKey), Objects.requireNonNull(resolvers));
        };
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MiniMessageBase withTagResolverBase(@NotNull String messageKey, @NotNull TagResolverBase resolverBase) {
        return new BaseImpls.WithTagResolverBase1(Objects.requireNonNull(messageKey), Objects.requireNonNull(resolverBase));
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MiniMessageBase withTagResolverBase(@NotNull String messageKey, TagResolverBase ... resolverBases) {
        return switch (resolverBases.length) {
            case 0 -> MiniMessageBase.messageKey(messageKey);
            case 1 -> MiniMessageBase.withTagResolverBase(messageKey, resolverBases[0]);
            default -> new BaseImpls.WithTagResolverBaseN(Objects.requireNonNull(messageKey), Objects.requireNonNull(resolverBases));
        };
    }
}

