/*
 * Decompiled with CFR 0.152.
 */
package com.github.siroshun09.messages.minimessage.builder;

import com.github.siroshun09.messages.api.builder.MessageBuilder;
import com.github.siroshun09.messages.minimessage.source.MiniMessageSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.TagPattern;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MiniMessageBuilder
implements MessageBuilder<Component, MiniMessageBuilder> {
    private final MiniMessageSource source;
    private final List<TagResolver> tagResolvers = new ArrayList<TagResolver>();
    private String key;

    @Contract(value="_ -> new")
    @NotNull
    public static MiniMessageBuilder create(@NotNull MiniMessageSource source) {
        return new MiniMessageBuilder(source);
    }

    private MiniMessageBuilder(@NotNull MiniMessageSource source) {
        this.source = Objects.requireNonNull(source);
    }

    @Contract(value="_ -> this")
    @NotNull
    public MiniMessageBuilder key(@NotNull String key) {
        this.key = Objects.requireNonNull(key);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public MiniMessageBuilder tagResolver(@NotNull TagResolver tagResolver) {
        this.tagResolvers.add(Objects.requireNonNull(tagResolver));
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public MiniMessageBuilder tagResolvers(TagResolver ... tagResolvers) {
        Objects.requireNonNull(tagResolvers);
        for (TagResolver tagResolver : tagResolvers) {
            this.tagResolver(tagResolver);
        }
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public MiniMessageBuilder tagResolvers(@NotNull Collection<? extends TagResolver> tagResolvers) {
        Objects.requireNonNull(tagResolvers).forEach(this::tagResolver);
        return this;
    }

    @NotNull
    public Component build() {
        Objects.requireNonNull(this.key, "key is not set");
        if (this.tagResolvers.isEmpty()) {
            return (Component)this.source.getMessage(this.key);
        }
        if (this.tagResolvers.size() == 1) {
            return this.source.getMessage(this.key, this.tagResolvers.get(0));
        }
        return this.source.getMessage(this.key, (TagResolver[])this.tagResolvers.toArray(TagResolver[]::new));
    }

    @Contract(value="_ -> new")
    @NotNull
    public TagResolver asPlaceholder(@TagPattern @NotNull String placeholder) {
        return Placeholder.component((String)Objects.requireNonNull(placeholder), (ComponentLike)this.build());
    }

    public void send(@NotNull Audience target) {
        Objects.requireNonNull(target);
        target.sendMessage(this.build());
    }
}

