/*
 * Decompiled with CFR 0.152.
 */
package com.github.siroshun09.messages.minimessage.localization;

import com.github.siroshun09.messages.api.localize.AbstractLocalization;
import com.github.siroshun09.messages.api.source.MessageSource;
import com.github.siroshun09.messages.minimessage.source.FallingBackMiniMessageSource;
import com.github.siroshun09.messages.minimessage.source.MiniMessageSource;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.ParsingException;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.translation.Translator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MiniMessageLocalization
extends AbstractLocalization<Component, MiniMessageSource, FallingBackMiniMessageSource> {
    private final Function<@Nullable Object, @Nullable Locale> localeGetter;

    public MiniMessageLocalization(@NotNull MiniMessageSource defaultSource) {
        this(defaultSource, obj -> null);
    }

    public MiniMessageLocalization(@NotNull MiniMessageSource defaultSource, @NotNull Function<@Nullable Object, @Nullable Locale> localeGetter) {
        super((MessageSource)defaultSource);
        this.localeGetter = localeGetter;
    }

    @NotNull
    public FallingBackMiniMessageSource findSource(@NotNull Locale locale) {
        MiniMessageSource source = Objects.requireNonNullElse((MiniMessageSource)this.getSource(locale), (MiniMessageSource)this.defaultSource());
        return new FallingBackMiniMessageSource(source, (MiniMessageSource)this.defaultSource());
    }

    @NotNull
    public FallingBackMiniMessageSource findSource(@Nullable Object obj) {
        Locale locale = this.localeGetter.apply(obj);
        return locale != null ? this.findSource(locale) : new FallingBackMiniMessageSource((MiniMessageSource)this.defaultSource(), (MiniMessageSource)this.defaultSource());
    }

    @ApiStatus.Experimental
    @NotNull
    public Translator toTranslator(@NotNull Key key) {
        return new TranslatorImpl(key, this);
    }

    private record TranslatorImpl(@NotNull Key name, @NotNull MiniMessageLocalization localization) implements Translator
    {
        private static final boolean HAS_ARGUMENTS_METHOD;

        @NotNull
        private static List<? extends ComponentLike> getArguments(@NotNull TranslatableComponent component) {
            return HAS_ARGUMENTS_METHOD ? component.arguments() : component.args();
        }

        @Nullable
        public MessageFormat translate(@NotNull String key, @NotNull Locale locale) {
            FallingBackMiniMessageSource source = this.localization.findSource(locale);
            return source.hasMessage(key) ? new MessageFormat(source.getRawMessage(key), locale) : null;
        }

        @Nullable
        public Component translate(@NotNull TranslatableComponent component, @NotNull Locale locale) {
            String key;
            FallingBackMiniMessageSource source = this.localization.findSource(locale);
            return source.hasMessage(key = component.key()) ? this.render(source, key, component) : null;
        }

        private Component render(@NotNull MiniMessageSource source, @NotNull String key, @NotNull TranslatableComponent component) {
            List<? extends ComponentLike> arguments = TranslatorImpl.getArguments(component);
            Component result = arguments.isEmpty() ? (Component)source.getMessage(key) : source.getMessage(key, (TagResolver)new ArgumentTag(arguments));
            return component.children().isEmpty() ? result : result.children(component.children());
        }

        static {
            boolean hasArgumentsMethod;
            try {
                TranslatableComponent.class.getDeclaredMethod("arguments", new Class[0]);
                hasArgumentsMethod = true;
            }
            catch (NoSuchMethodException ignored) {
                hasArgumentsMethod = false;
            }
            HAS_ARGUMENTS_METHOD = hasArgumentsMethod;
        }

        private record ArgumentTag(List<? extends ComponentLike> arguments) implements TagResolver
        {
            private static final String ARGUMENT_NAME = "argument";
            private static final String ARG_NAME = "arg";

            @NotNull
            public Tag resolve(@NotNull String name, @NotNull ArgumentQueue arguments, @NotNull Context ctx) throws ParsingException {
                int index = arguments.popOr("No argument number provided").asInt().orElseThrow(() -> ctx.newException("Invalid argument number", arguments));
                if (index < 0 || index >= this.arguments.size()) {
                    throw ctx.newException("Invalid argument number", arguments);
                }
                return Tag.inserting((ComponentLike)this.arguments.get(index));
            }

            public boolean has(@NotNull String name) {
                return name.equals(ARGUMENT_NAME) || name.equals(ARG_NAME);
            }
        }
    }
}

