/*
 * Decompiled with CFR 0.152.
 */
package com.github.siroshun09.messages.minimessage.source;

import com.github.siroshun09.messages.api.source.FallingBackMessageSource;
import com.github.siroshun09.messages.minimessage.source.MiniMessageSource;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;

public final class FallingBackMiniMessageSource
extends Record
implements MiniMessageSource,
FallingBackMessageSource<Component, MiniMessageSource> {
    @NotNull
    private final MiniMessageSource primarySource;
    @NotNull
    private final MiniMessageSource fallbackSource;

    public FallingBackMiniMessageSource(@NotNull MiniMessageSource primarySource, @NotNull MiniMessageSource fallbackSource) {
        Objects.requireNonNull(primarySource);
        Objects.requireNonNull(fallbackSource);
        this.primarySource = primarySource;
        this.fallbackSource = fallbackSource;
    }

    @Override
    @NotNull
    public Component getMessage(@NotNull String key, @NotNull TagResolver tagResolver) {
        if (this.primarySource.hasMessage(key)) {
            return this.primarySource.getMessage(key, tagResolver);
        }
        return this.fallbackSource.getMessage(key, tagResolver);
    }

    @Override
    @NotNull
    public Component getMessage(@NotNull String key, TagResolver ... tagResolvers) {
        if (this.primarySource.hasMessage(key)) {
            return this.primarySource.getMessage(key, tagResolvers);
        }
        return this.fallbackSource.getMessage(key, tagResolvers);
    }

    @NotNull
    public String getRawMessage(@NotNull String key) {
        if (this.primarySource.hasMessage(key)) {
            return (String)this.primarySource.getRawMessage(key);
        }
        return (String)this.fallbackSource.getRawMessage(key);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{FallingBackMiniMessageSource.class, "primarySource;fallbackSource", "primarySource", "fallbackSource"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FallingBackMiniMessageSource.class, "primarySource;fallbackSource", "primarySource", "fallbackSource"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FallingBackMiniMessageSource.class, "primarySource;fallbackSource", "primarySource", "fallbackSource"}, this, o);
    }

    @NotNull
    public MiniMessageSource primarySource() {
        return this.primarySource;
    }

    @NotNull
    public MiniMessageSource fallbackSource() {
        return this.fallbackSource;
    }
}

