/*
 * Decompiled with CFR 0.152.
 */
package com.github.siroshun09.messages.minimessage.source;

import com.github.siroshun09.messages.api.source.StringMessageSource;
import com.github.siroshun09.messages.minimessage.source.MiniMessageSource;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;

class MiniMessageSourceImpl
implements MiniMessageSource {
    private final StringMessageSource source;
    private final MiniMessage deserializer;

    MiniMessageSourceImpl(@NotNull StringMessageSource source, @NotNull MiniMessage deserializer) {
        this.source = Objects.requireNonNull(source);
        this.deserializer = Objects.requireNonNull(deserializer);
    }

    public boolean hasMessage(@NotNull String key) {
        return this.source.hasMessage(key);
    }

    @NotNull
    public Component getMessage(@NotNull String key) {
        return this.deserializer.deserialize((Object)((String)this.source.getMessage(key)));
    }

    @Override
    @NotNull
    public Component getMessage(@NotNull String key, @NotNull TagResolver tagResolver) {
        Objects.requireNonNull(tagResolver);
        return this.deserializer.deserialize((String)this.source.getMessage(key), tagResolver);
    }

    @Override
    @NotNull
    public Component getMessage(@NotNull String key, TagResolver ... tagResolvers) {
        Objects.requireNonNull(tagResolvers);
        return this.deserializer.deserialize((String)this.source.getMessage(key), tagResolvers);
    }

    @NotNull
    public String getRawMessage(@NotNull String key) {
        return (String)this.source.getMessage(key);
    }
}

