/*
 * Decompiled with CFR 0.152.
 */
package com.github.sisyphsu.dateparser;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public final class DateBuilder {
    private static final ZoneId UTC_ZONE_ID = ZoneId.of("UTC");
    private static final ZoneOffset DEFAULT_OFFSET = OffsetDateTime.now().getOffset();
    int week;
    int year;
    int month;
    int day;
    int hour;
    int minute;
    int second;
    int ns;
    long unixsecond;
    boolean zoneOffsetSetted;
    int zoneOffset;
    TimeZone zone;
    boolean am;
    boolean pm;

    void reset() {
        this.week = 1;
        this.year = 0;
        this.month = 1;
        this.day = 1;
        this.hour = 0;
        this.minute = 0;
        this.second = 0;
        this.ns = 0;
        this.unixsecond = 0L;
        this.am = false;
        this.pm = false;
        this.zoneOffsetSetted = false;
        this.zoneOffset = 0;
        this.zone = null;
    }

    Date toDate() {
        if (!this.zoneOffsetSetted) {
            return this.toCalendar().getTime();
        }
        return Date.from(this.toOffsetDateTime().toInstant());
    }

    Calendar toCalendar() {
        this.prepare();
        Calendar calendar = Calendar.getInstance();
        if (this.unixsecond != 0L) {
            calendar.setTimeInMillis(this.unixsecond * 1000L + (long)(this.ns / 1000000));
            return calendar;
        }
        if (this.zone != null) {
            calendar.setTimeZone(this.zone);
        }
        if (this.zoneOffsetSetted) {
            String[] ids = TimeZone.getAvailableIDs(this.zoneOffset * 60000);
            if (ids.length == 0) {
                throw new DateTimeException("Can't build Calendar, because the zoneOffset[" + this.zoneOffset + "] can't be converted to an valid TimeZone.");
            }
            calendar.setTimeZone(TimeZone.getTimeZone(ids[0]));
        }
        calendar.set(1, this.year);
        calendar.set(2, this.month - 1);
        calendar.set(5, this.day);
        calendar.set(11, this.hour);
        calendar.set(12, this.minute);
        calendar.set(13, this.second);
        calendar.set(14, this.ns / 1000000);
        return calendar;
    }

    LocalDateTime toLocalDateTime() {
        this.prepare();
        if (this.unixsecond > 0L) {
            return LocalDateTime.ofEpochSecond(this.unixsecond, this.ns, ZoneOffset.UTC);
        }
        LocalDateTime dateTime = LocalDateTime.of(this.year, this.month, this.day, this.hour, this.minute, this.second, this.ns);
        int zoneSecond = 0;
        if (this.zone != null) {
            zoneSecond = (TimeZone.getDefault().getRawOffset() - this.zone.getRawOffset()) / 1000;
        }
        if (this.zoneOffsetSetted) {
            zoneSecond = TimeZone.getDefault().getRawOffset() / 1000 - this.zoneOffset * 60;
        }
        return zoneSecond == 0 ? dateTime : dateTime.plusSeconds(zoneSecond);
    }

    OffsetDateTime toOffsetDateTime() {
        this.prepare();
        if (this.unixsecond > 0L) {
            return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.unixsecond, this.ns), UTC_ZONE_ID);
        }
        LocalDateTime dateTime = LocalDateTime.of(this.year, this.month, this.day, this.hour, this.minute, this.second, this.ns);
        if (this.zoneOffsetSetted) {
            ZoneOffset offset = ZoneOffset.ofHoursMinutes(this.zoneOffset / 60, this.zoneOffset % 60);
            return dateTime.atOffset(offset);
        }
        if (this.zone != null) {
            return dateTime.atZone(this.zone.toZoneId()).toOffsetDateTime();
        }
        return dateTime.atZone(ZoneOffset.ofHoursMinutes(0, 0)).toOffsetDateTime();
    }

    private void prepare() {
        if (this.am && this.hour == 12) {
            this.hour = 0;
        }
        if (this.pm && this.hour != 12) {
            this.hour += 12;
        }
    }

    public int getWeek() {
        return this.week;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public int getNs() {
        return this.ns;
    }

    public long getUnixsecond() {
        return this.unixsecond;
    }

    public boolean isZoneOffsetSetted() {
        return this.zoneOffsetSetted;
    }

    public int getZoneOffset() {
        return this.zoneOffset;
    }

    public TimeZone getZone() {
        return this.zone;
    }

    public boolean isAm() {
        return this.am;
    }

    public boolean isPm() {
        return this.pm;
    }

    public void setWeek(int week) {
        this.week = week;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public void setMinute(int minute) {
        this.minute = minute;
    }

    public void setSecond(int second) {
        this.second = second;
    }

    public void setNs(int ns) {
        this.ns = ns;
    }

    public void setUnixsecond(long unixsecond) {
        this.unixsecond = unixsecond;
    }

    public void setZoneOffsetSetted(boolean zoneOffsetSetted) {
        this.zoneOffsetSetted = zoneOffsetSetted;
    }

    public void setZoneOffset(int zoneOffset) {
        this.zoneOffset = zoneOffset;
    }

    public void setZone(TimeZone zone) {
        this.zone = zone;
    }

    public void setAm(boolean am) {
        this.am = am;
    }

    public void setPm(boolean pm) {
        this.pm = pm;
    }
}

