/*
 * Decompiled with CFR 0.152.
 */
package com.github.sisyphsu.retree;

import com.github.sisyphsu.retree.Node;
import com.github.sisyphsu.retree.ReMatcher;
import java.util.ArrayList;
import java.util.List;

public final class BranchNode
extends Node {
    final List<Node> branches = new ArrayList<Node>(2);

    public BranchNode(List<Node> branches) {
        this.branches.addAll(branches);
    }

    public BranchNode(Node next, Node first, Node second) {
        this.next = next;
        this.add(first);
        this.add(second);
    }

    @Override
    public void study() {
        if (this.minInput < 0) {
            this.minInput = 0;
            int min = Integer.MAX_VALUE;
            for (Node branch : this.branches) {
                int currMin;
                if (branch == null) {
                    this.next.study();
                    currMin = this.next.minInput;
                } else {
                    branch.study();
                    currMin = branch.minInput;
                }
                min = Math.min(min, currMin);
            }
            this.minInput = min;
        }
    }

    @Override
    public boolean match(ReMatcher matcher, CharSequence input, int cursor) {
        int rest = matcher.to - cursor;
        for (Node branch : this.branches) {
            Node node;
            Node node2 = node = branch == null ? this.next : branch;
            if (rest < node.minInput || !node.match(matcher, input, cursor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean alike(Node node) {
        if (node instanceof BranchNode) {
            if (this.branches.size() != ((BranchNode)node).branches.size()) {
                return false;
            }
            for (int i = 0; i < this.branches.size(); ++i) {
                Node node1 = this.branches.get(i);
                Node node2 = ((BranchNode)node).branches.get(i);
                if (node1 == null && node2 == null || node1 != null && node2 != null && node1.alike(node2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void add(Node node) {
        this.branches.add(node);
    }
}

