/*
 * Decompiled with CFR 0.152.
 */
package com.github.sisyphsu.retree;

import com.github.sisyphsu.retree.Node;
import com.github.sisyphsu.retree.ReMatcher;

public final class CharRefNode
extends Node {
    private final int refGroupIndex;
    private final int refStartOffset;
    private final int refEndOffset;

    public CharRefNode(int refIndex) {
        this.refGroupIndex = refIndex;
        this.refStartOffset = refIndex * 2;
        this.refEndOffset = refIndex * 2 + 1;
    }

    @Override
    public boolean match(ReMatcher matcher, CharSequence input, int cursor) {
        int groupEnd = matcher.groupVars[this.refEndOffset];
        int groupStart = matcher.groupVars[this.refStartOffset];
        int groupLen = groupEnd - groupStart;
        if (matcher.to - cursor < groupLen) {
            return false;
        }
        if (groupLen > 0) {
            for (int i = 0; i < groupLen; ++i) {
                if (input.charAt(groupStart + i) == input.charAt(cursor++)) continue;
                return false;
            }
        }
        if (this.next == null) {
            matcher.last = cursor;
            return true;
        }
        return this.next.match(matcher, input, cursor);
    }

    @Override
    public boolean alike(Node node) {
        if (node instanceof CharRefNode) {
            return this.refGroupIndex == ((CharRefNode)node).refGroupIndex;
        }
        return false;
    }
}

