/*
 * Decompiled with CFR 0.152.
 */
package com.github.sisyphsu.retree;

import com.github.sisyphsu.retree.Node;
import com.github.sisyphsu.retree.ReMatcher;
import java.util.Arrays;

public class CurlyNode
extends Node {
    private final int type;
    private final int minTimes;
    private final int maxTimes;
    Node body;

    public CurlyNode(int type, int minTimes, int maxTimes, Node body, Node next) {
        this.type = type;
        this.minTimes = minTimes;
        this.maxTimes = maxTimes;
        this.body = body;
        this.next = next;
    }

    @Override
    public void study() {
        if (this.minInput < 0) {
            this.minInput = 0;
            this.body.study();
            this.next.study();
            this.minInput = this.next.minInput + this.body.minInput * this.minTimes;
        }
    }

    @Override
    public boolean alike(Node node) {
        if (node instanceof CurlyNode) {
            if (this.type != ((CurlyNode)node).type) {
                return false;
            }
            if (this.minTimes != ((CurlyNode)node).minTimes) {
                return false;
            }
            if (this.maxTimes != ((CurlyNode)node).maxTimes) {
                return false;
            }
            return this.body.alike(((CurlyNode)node).body);
        }
        return false;
    }

    @Override
    public boolean match(ReMatcher matcher, CharSequence input, int cursor) {
        boolean result;
        int times;
        for (times = 0; times < this.minTimes; ++times) {
            if (matcher.to - cursor < this.body.minInput || !this.body.match(matcher, input, cursor)) {
                return false;
            }
            cursor = matcher.last;
        }
        int backCount = 0;
        switch (this.type) {
            case 1: {
                while (true) {
                    if (this.next.match(matcher, input, cursor)) {
                        return true;
                    }
                    if (times >= this.maxTimes) {
                        return false;
                    }
                    if (matcher.to - cursor < this.body.minInput || !this.body.match(matcher, input, cursor)) {
                        return false;
                    }
                    cursor = matcher.last;
                    ++times;
                }
            }
            case 2: {
                while (times < this.maxTimes && matcher.to - cursor >= this.body.minInput && this.body.match(matcher, input, cursor)) {
                    cursor = matcher.last;
                    ++times;
                }
                break;
            }
            default: {
                while (times < this.maxTimes && matcher.to - cursor >= this.body.minInput && this.body.match(matcher, input, cursor)) {
                    if (matcher.backs.length <= backCount) {
                        matcher.backs = Arrays.copyOf(matcher.backs, matcher.backs.length * 2);
                    }
                    matcher.backs[backCount++] = cursor;
                    cursor = matcher.last;
                    ++times;
                }
                break block0;
            }
        }
        while (!(result = this.next.match(matcher, input, cursor)) && backCount != 0) {
            cursor = matcher.backs[--backCount];
        }
        return result;
    }
}

