/*
 * Decompiled with CFR 0.152.
 */
package com.github.siyamed.shapeimageview.mask;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import com.github.siyamed.shapeimageview.mask.PorterImageView;

public class PorterCircularImageView
extends PorterImageView {
    private final RectF rect = new RectF();

    public PorterCircularImageView(Context context) {
        super(context);
        this.setup();
    }

    public PorterCircularImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setup();
    }

    public PorterCircularImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setup();
    }

    private final void setup() {
        this.setSquare(true);
    }

    @Override
    protected void paintMaskCanvas(Canvas maskCanvas, Paint maskPaint, int width, int height) {
        float radius = (float)Math.min(width, height) / 2.0f;
        this.rect.set(0.0f, 0.0f, (float)width, (float)height);
        maskCanvas.drawCircle(this.rect.centerX(), this.rect.centerY(), radius, maskPaint);
    }
}

