/*
 * Decompiled with CFR 0.152.
 */
package com.github.siyamed.shapeimageview.path.parser;

import android.util.Log;
import com.github.siyamed.shapeimageview.path.parser.ParseUtil;
import com.github.siyamed.shapeimageview.path.parser.SvgParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class IdHandler {
    private static final String TAG = SvgParser.TAG;
    HashMap<String, String> idXml = new HashMap();
    Stack<IdRecording> idRecordingStack = new Stack();
    private XmlPullParser atts;

    IdHandler(XmlPullParser atts) {
        this.atts = atts;
    }

    public void processIds() throws XmlPullParserException, IOException {
        int eventType = this.atts.getEventType();
        do {
            if (eventType == 0 || eventType == 1) continue;
            if (eventType == 2) {
                this.startElement();
                continue;
            }
            if (eventType == 3) {
                this.endElement();
                continue;
            }
            if (eventType != 4) continue;
        } while ((eventType = this.atts.next()) != 1);
    }

    private void appendElementString(StringBuilder sb, String namespaceURI, String localName, String qName, XmlPullParser atts) {
        sb.append("<");
        sb.append(localName);
        for (int i = 0; i < atts.getAttributeCount(); ++i) {
            sb.append(" ");
            sb.append(atts.getAttributeName(i));
            sb.append("='");
            sb.append(ParseUtil.escape(atts.getAttributeValue(i)));
            sb.append("'");
        }
        sb.append(">");
    }

    public void startElement() {
        IdRecording ir;
        String localName = this.atts.getName();
        String id = ParseUtil.getStringAttr("id", this.atts);
        if (id != null) {
            ir = new IdRecording(id);
            this.idRecordingStack.push(ir);
        }
        if (this.idRecordingStack.size() > 0) {
            ir = (IdRecording)this.idRecordingStack.lastElement();
            ++ir.level;
            this.appendElementString(ir.sb, this.atts.getNamespace(), localName, this.atts.getName(), this.atts);
        }
    }

    public void endElement() {
        String localName = this.atts.getName();
        if (this.idRecordingStack.size() > 0) {
            IdRecording ir = (IdRecording)this.idRecordingStack.lastElement();
            ir.sb.append("</");
            ir.sb.append(localName);
            ir.sb.append(">");
            --ir.level;
            if (ir.level == 0) {
                String xml = ir.sb.toString();
                this.idXml.put(ir.id, xml);
                this.idRecordingStack.pop();
                if (this.idRecordingStack.size() > 0) {
                    ((IdRecording)this.idRecordingStack.lastElement()).sb.append(xml);
                }
                Log.w((String)TAG, (String)xml);
            }
        }
    }

    class IdRecording {
        String id;
        int level;
        StringBuilder sb;

        public IdRecording(String id) {
            this.id = id;
            this.level = 0;
            this.sb = new StringBuilder();
        }
    }
}

