/*
 * Decompiled with CFR 0.152.
 */
package com.github.siyamed.shapeimageview.path.parser;

import org.xmlpull.v1.XmlPullParser;

public class ParseUtil {
    static final String escape(String s) {
        return s.replaceAll("\"", "&quot;").replaceAll("'", "&apos").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("&", "&amp;");
    }

    static final String getStringAttr(String name, XmlPullParser attributes) {
        int n = attributes.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            if (!attributes.getAttributeName(i).equals(name)) continue;
            return attributes.getAttributeValue(i);
        }
        return null;
    }

    static final Float convertUnits(String name, XmlPullParser atts, float dpi, float width, float height) {
        String value = ParseUtil.getStringAttr(name, atts);
        if (value == null) {
            return null;
        }
        if (value.endsWith("px")) {
            return Float.valueOf(Float.parseFloat(value.substring(0, value.length() - 2)));
        }
        if (value.endsWith("pt")) {
            return Float.valueOf(Float.valueOf(value.substring(0, value.length() - 2)).floatValue() * dpi / 72.0f);
        }
        if (value.endsWith("pc")) {
            return Float.valueOf(Float.valueOf(value.substring(0, value.length() - 2)).floatValue() * dpi / 6.0f);
        }
        if (value.endsWith("cm")) {
            return Float.valueOf(Float.valueOf(value.substring(0, value.length() - 2)).floatValue() * dpi / 2.54f);
        }
        if (value.endsWith("mm")) {
            return Float.valueOf(Float.valueOf(value.substring(0, value.length() - 2)).floatValue() * dpi / 254.0f);
        }
        if (value.endsWith("in")) {
            return Float.valueOf(Float.valueOf(value.substring(0, value.length() - 2)).floatValue() * dpi);
        }
        if (value.endsWith("%")) {
            Float result = Float.valueOf(value.substring(0, value.length() - 1));
            float mult = name.indexOf("x") >= 0 || name.equals("width") ? width / 100.0f : (name.indexOf("y") >= 0 || name.equals("height") ? height / 100.0f : (height + width) / 2.0f);
            return Float.valueOf(result.floatValue() * mult);
        }
        return Float.valueOf(value);
    }
}

