/*
 * Decompiled with CFR 0.152.
 */
package com.github.siyamed.shapeimageview.path.parser;

import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.RectF;

public class PathInfo {
    private float width;
    private float height;
    private Path path;
    private RectF bounds = new RectF();

    PathInfo(Path path, float width, float height) {
        this.path = path;
        this.width = width;
        this.height = height;
        path.computeBounds(this.bounds, true);
        if (width <= 0.0f && height <= 0.0f) {
            this.width = (float)Math.ceil(this.bounds.width());
            this.height = (float)Math.ceil(this.bounds.height());
            path.offset(-1.0f * (float)Math.floor(this.bounds.left), -1.0f * (float)Math.round(this.bounds.top));
        }
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public Path getPath() {
        return this.path;
    }

    public void transform(Matrix matrix, Path dst) {
        this.path.transform(matrix, dst);
    }
}

