/*
 * Decompiled with CFR 0.152.
 */
package com.github.siyamed.shapeimageview.path.parser;

import com.github.siyamed.shapeimageview.path.parser.ParseUtil;
import com.github.siyamed.shapeimageview.path.parser.StyleSet;
import org.xmlpull.v1.XmlPullParser;

class Properties {
    StyleSet styles = null;
    XmlPullParser atts;

    Properties(XmlPullParser atts) {
        this.atts = atts;
        String styleAttr = ParseUtil.getStringAttr("style", atts);
        if (styleAttr != null) {
            this.styles = new StyleSet(styleAttr);
        }
    }

    public String getAttr(String name) {
        String v = null;
        if (this.styles != null) {
            v = this.styles.getStyle(name);
        }
        if (v == null) {
            v = ParseUtil.getStringAttr(name, this.atts);
        }
        return v;
    }

    public String getString(String name) {
        return this.getAttr(name);
    }

    public Float getFloat(String name, float defaultValue) {
        Float v = this.getFloat(name);
        if (v == null) {
            return Float.valueOf(defaultValue);
        }
        return v;
    }

    public Float getFloat(String name) {
        String v = this.getAttr(name);
        if (v == null) {
            return null;
        }
        try {
            return Float.valueOf(Float.parseFloat(v));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }
}

