/*
 * Decompiled with CFR 0.152.
 */
package com.github.siyamed.shapeimageview.path.parser;

import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.Log;
import com.github.siyamed.shapeimageview.path.parser.CopyInputStream;
import com.github.siyamed.shapeimageview.path.parser.IdHandler;
import com.github.siyamed.shapeimageview.path.parser.NumberParse;
import com.github.siyamed.shapeimageview.path.parser.ParseUtil;
import com.github.siyamed.shapeimageview.path.parser.PathInfo;
import com.github.siyamed.shapeimageview.path.parser.PathParser;
import com.github.siyamed.shapeimageview.path.parser.TransformParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class SvgParser {
    static final String TAG = SvgParser.class.getSimpleName();
    static float DPI = 72.0f;
    private static final Matrix IDENTITY_MATRIX = new Matrix();
    private HashMap<String, String> idXml = new HashMap();
    private XmlPullParser atts;
    private RectF rect = new RectF();
    private float dpi = DPI;
    private boolean hidden = false;
    private int hiddenLevel = 0;
    private boolean inDefsElement = false;
    private Deque<Path> pathStack = new LinkedList<Path>();
    private Deque<Matrix> matrixStack = new LinkedList<Matrix>();
    private float width;
    private float height;
    private Path path;
    private PathInfo pathInfo = null;

    public static PathInfo getSVGFromInputStream(InputStream inputStream) {
        return SvgParser.parse(inputStream, true, DPI);
    }

    public static PathInfo getSVGFromString(String svgString) {
        return SvgParser.parse(new ByteArrayInputStream(svgString.getBytes()), false, DPI);
    }

    public static PathInfo getSVGFromResource(Resources resources, int resId) {
        return SvgParser.parse(resources.openRawResource(resId), false, DPI);
    }

    public static PathInfo getSVGFromAsset(AssetManager assetMngr, String path) throws IOException {
        InputStream inputStream = assetMngr.open(path);
        PathInfo result = SvgParser.getSVGFromInputStream(inputStream);
        return result;
    }

    private static PathInfo parse(InputStream in, boolean ignoreDefs, float dpi) {
        try {
            KXmlParser xr = new KXmlParser();
            SvgParser svgHandler = new SvgParser((XmlPullParser)xr);
            svgHandler.setDpi(dpi);
            if (ignoreDefs) {
                xr.setInput((Reader)new InputStreamReader(in));
                svgHandler.processSvg();
            } else {
                CopyInputStream cin = new CopyInputStream(in);
                KXmlParser ids = new KXmlParser();
                ids.setInput((Reader)new InputStreamReader(cin.getCopy()));
                IdHandler idHandler = new IdHandler((XmlPullParser)ids);
                idHandler.processIds();
                svgHandler.idXml = idHandler.idXml;
                xr.setInput((Reader)new InputStreamReader(cin.getCopy()));
                svgHandler.processSvg();
            }
            PathInfo result = svgHandler.pathInfo;
            return result;
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("Parse error: " + e));
            throw new RuntimeException(e);
        }
    }

    private SvgParser(XmlPullParser atts) {
        this.atts = atts;
    }

    public void setDpi(float dpi) {
        this.dpi = dpi;
    }

    public void processSvg() throws XmlPullParserException, IOException {
        int eventType = this.atts.getEventType();
        do {
            switch (eventType) {
                case 0: 
                case 1: 
                case 4: {
                    break;
                }
                case 2: {
                    this.startElement();
                    break;
                }
                case 3: {
                    this.endElement();
                }
            }
        } while ((eventType = this.atts.next()) != 1);
    }

    private void pushTransform(XmlPullParser atts) {
        String transform = ParseUtil.getStringAttr("transform", atts);
        Matrix matrix = transform == null ? IDENTITY_MATRIX : TransformParser.parseTransform(transform);
        this.matrixStack.push(matrix);
    }

    private void pushTransform(Matrix pMatrix) {
        Matrix matrix = pMatrix == null ? IDENTITY_MATRIX : pMatrix;
        this.matrixStack.push(matrix);
    }

    private Matrix popTransform() {
        return this.matrixStack.pop();
    }

    private final void pushPath() {
        Path path;
        this.path = path = new Path();
        this.pathStack.add(path);
    }

    private final Path popPath() {
        Path poppedPath = this.pathStack.pop();
        this.path = this.pathStack.peek();
        return poppedPath;
    }

    public void startElement() {
        String localName = this.atts.getName();
        if (this.inDefsElement) {
            return;
        }
        if (localName.equals("svg")) {
            this.width = Math.round(this.getFloatAttr("width", this.atts, Float.valueOf(0.0f)).floatValue());
            this.height = Math.round(this.getFloatAttr("height", this.atts, Float.valueOf(0.0f)).floatValue());
            NumberParse viewbox = NumberParse.getNumberParseAttr("viewBox", this.atts);
            this.pushPath();
            Matrix matrix = IDENTITY_MATRIX;
            if (viewbox != null && viewbox.numbers != null && viewbox.numbers.size() == 4) {
                if (this.width < 0.1f || this.height < -0.1f) {
                    this.width = viewbox.numbers.get(2).floatValue() - viewbox.numbers.get(0).floatValue();
                    this.width = viewbox.numbers.get(3).floatValue() - viewbox.numbers.get(3).floatValue();
                } else {
                    float sx = this.width / (viewbox.numbers.get(2).floatValue() - viewbox.numbers.get(0).floatValue());
                    float sy = this.height / (viewbox.numbers.get(3).floatValue() - viewbox.numbers.get(1).floatValue());
                    matrix.setScale(sx, sy);
                }
            }
            this.pushTransform(matrix);
        } else if (localName.equals("defs")) {
            this.inDefsElement = true;
        } else if (localName.equals("use")) {
            String href = ParseUtil.getStringAttr("xlink:href", this.atts);
            String attTransform = ParseUtil.getStringAttr("transform", this.atts);
            String attX = ParseUtil.getStringAttr("x", this.atts);
            String attY = ParseUtil.getStringAttr("y", this.atts);
            StringBuilder sb = new StringBuilder();
            sb.append("<g");
            sb.append(" xmlns='http://www.w3.org/2000/svg' ");
            sb.append(" xmlns:xlink='http://www.w3.org/1999/xlink' ");
            sb.append(" xmlns:sodipodi='http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd' ");
            sb.append(" xmlns:inkscape='http://www.inkscape.org/namespaces/inkscape' version='1.1'");
            if (attTransform != null || attX != null || attY != null) {
                sb.append(" transform='");
                if (attTransform != null) {
                    sb.append(ParseUtil.escape(attTransform));
                }
                if (attX != null || attY != null) {
                    sb.append("translate(");
                    sb.append(attX != null ? ParseUtil.escape(attX) : "0");
                    sb.append(",");
                    sb.append(attY != null ? ParseUtil.escape(attY) : "0");
                    sb.append(")");
                }
                sb.append("'");
            }
            for (int i = 0; i < this.atts.getAttributeCount(); ++i) {
                String attrQName = this.atts.getAttributeName(i);
                if ("x".equals(attrQName) || "y".equals(attrQName) || "width".equals(attrQName) || "height".equals(attrQName) || "xlink:href".equals(attrQName) || "transform".equals(attrQName)) continue;
                sb.append(" ");
                sb.append(attrQName);
                sb.append("='");
                sb.append(ParseUtil.escape(this.atts.getAttributeValue(i)));
                sb.append("'");
            }
            sb.append(">");
            sb.append(this.idXml.get(href.substring(1)));
            sb.append("</g>");
        } else if (localName.equals("g")) {
            if (this.hidden) {
                ++this.hiddenLevel;
            }
            if ("none".equals(ParseUtil.getStringAttr("display", this.atts)) && !this.hidden) {
                this.hidden = true;
                this.hiddenLevel = 1;
            }
            this.pushTransform(this.atts);
            this.pushPath();
        } else if (!this.hidden && localName.equals("rect")) {
            Float x = this.getFloatAttr("x", this.atts, Float.valueOf(0.0f));
            Float y = this.getFloatAttr("y", this.atts, Float.valueOf(0.0f));
            Float width = this.getFloatAttr("width", this.atts);
            Float height = this.getFloatAttr("height", this.atts);
            Float rx = this.getFloatAttr("rx", this.atts, Float.valueOf(0.0f));
            Float ry = this.getFloatAttr("ry", this.atts, Float.valueOf(0.0f));
            Path p = new Path();
            if (rx.floatValue() <= 0.0f && ry.floatValue() <= 0.0f) {
                p.addRect(x.floatValue(), y.floatValue(), x.floatValue() + width.floatValue(), y.floatValue() + height.floatValue(), Path.Direction.CW);
            } else {
                this.rect.set(x.floatValue(), y.floatValue(), x.floatValue() + width.floatValue(), y.floatValue() + height.floatValue());
                p.addRoundRect(this.rect, rx.floatValue(), ry.floatValue(), Path.Direction.CW);
            }
            this.pushTransform(this.atts);
            Matrix matrix = this.popTransform();
            p.transform(matrix);
            this.path.addPath(p);
        } else if (!this.hidden && localName.equals("line")) {
            Float x1 = this.getFloatAttr("x1", this.atts);
            Float x2 = this.getFloatAttr("x2", this.atts);
            Float y1 = this.getFloatAttr("y1", this.atts);
            Float y2 = this.getFloatAttr("y2", this.atts);
            Path p = new Path();
            p.moveTo(x1.floatValue(), y1.floatValue());
            p.lineTo(x2.floatValue(), y2.floatValue());
            this.pushTransform(this.atts);
            Matrix matrix = this.popTransform();
            p.transform(matrix);
            this.path.addPath(p);
        } else if (!this.hidden && localName.equals("circle")) {
            Float centerX = this.getFloatAttr("cx", this.atts);
            Float centerY = this.getFloatAttr("cy", this.atts);
            Float radius = this.getFloatAttr("r", this.atts);
            if (centerX != null && centerY != null && radius != null) {
                Path p = new Path();
                p.addCircle(centerX.floatValue(), centerY.floatValue(), radius.floatValue(), Path.Direction.CW);
                this.pushTransform(this.atts);
                Matrix matrix = this.popTransform();
                p.transform(matrix);
                this.path.addPath(p);
            }
        } else if (!this.hidden && localName.equals("ellipse")) {
            Float centerX = this.getFloatAttr("cx", this.atts);
            Float centerY = this.getFloatAttr("cy", this.atts);
            Float radiusX = this.getFloatAttr("rx", this.atts);
            Float radiusY = this.getFloatAttr("ry", this.atts);
            if (centerX != null && centerY != null && radiusX != null && radiusY != null) {
                this.rect.set(centerX.floatValue() - radiusX.floatValue(), centerY.floatValue() - radiusY.floatValue(), centerX.floatValue() + radiusX.floatValue(), centerY.floatValue() + radiusY.floatValue());
                Path p = new Path();
                p.addOval(this.rect, Path.Direction.CW);
                this.pushTransform(this.atts);
                Matrix matrix = this.popTransform();
                p.transform(matrix);
                this.path.addPath(p);
            }
        } else if (!this.hidden && (localName.equals("polygon") || localName.equals("polyline"))) {
            NumberParse numbers = NumberParse.getNumberParseAttr("points", this.atts);
            if (numbers != null) {
                Path p = new Path();
                ArrayList<Float> points = numbers.numbers;
                if (points.size() > 1) {
                    p.moveTo(points.get(0).floatValue(), points.get(1).floatValue());
                    for (int i = 2; i < points.size(); i += 2) {
                        float x = points.get(i).floatValue();
                        float y = points.get(i + 1).floatValue();
                        p.lineTo(x, y);
                    }
                    if (localName.equals("polygon")) {
                        p.close();
                    }
                    this.pushTransform(this.atts);
                    Matrix matrix = this.popTransform();
                    p.transform(matrix);
                    this.path.addPath(p);
                }
            }
        } else if (!this.hidden && localName.equals("path")) {
            Path p = PathParser.doPath(ParseUtil.getStringAttr("d", this.atts));
            this.pushTransform(this.atts);
            Matrix matrix = this.popTransform();
            p.transform(matrix);
            this.path.addPath(p);
        } else if (!(!this.hidden && localName.equals("metadata") || this.hidden)) {
            Log.d((String)TAG, (String)String.format("Unrecognized tag: %s (%s)", localName, this.showAttributes(this.atts)));
        }
    }

    private void showBounds(String text, Path p) {
        RectF b = new RectF();
        p.computeBounds(b, true);
        Log.d((String)TAG, (String)(text + " bounds: " + b.left + "," + b.bottom + " to " + b.right + "," + b.top));
    }

    private String showAttributes(XmlPullParser a) {
        String result = "";
        for (int i = 0; i < a.getAttributeCount(); ++i) {
            result = result + " " + a.getAttributeName(i) + "='" + a.getAttributeValue(i) + "'";
        }
        return result;
    }

    public void endElement() {
        String localName = this.atts.getName();
        if (this.inDefsElement) {
            if (localName.equals("defs")) {
                this.inDefsElement = false;
            }
            return;
        }
        if (localName.equals("svg")) {
            Path p = this.popPath();
            Matrix matrix = this.popTransform();
            p.transform(matrix);
            this.pathInfo = new PathInfo(p, this.width, this.height);
        } else if (localName.equals("g")) {
            if (this.hidden) {
                --this.hiddenLevel;
                if (this.hiddenLevel == 0) {
                    this.hidden = false;
                }
            }
            Path p = this.popPath();
            Matrix matrix = this.popTransform();
            p.transform(matrix);
            this.path.addPath(p);
        }
    }

    final Float getFloatAttr(String name, XmlPullParser attributes) {
        return this.getFloatAttr(name, attributes, null);
    }

    final Float getFloatAttr(String name, XmlPullParser attributes, Float defaultValue) {
        Float result = ParseUtil.convertUnits(name, attributes, this.dpi, this.width, this.height);
        return result == null ? defaultValue : result;
    }
}

