/*
 * Decompiled with CFR 0.152.
 */
package com.github.siyamed.shapeimageview.shader;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import com.github.siyamed.shapeimageview.R;
import com.github.siyamed.shapeimageview.shader.ShaderHelper;

public class RoundedShader
extends ShaderHelper {
    private final RectF borderRect = new RectF();
    private final RectF imageRect = new RectF();
    private int radius = 0;
    private int bitmapRadius;

    @Override
    public void init(Context context, AttributeSet attrs, int defStyle) {
        super.init(context, attrs, defStyle);
        this.borderPaint.setStrokeWidth((float)(this.borderWidth * 2));
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ShaderImageView, defStyle, 0);
            this.radius = typedArray.getDimensionPixelSize(9, this.radius);
            typedArray.recycle();
        }
    }

    @Override
    public void draw(Canvas canvas, Paint imagePaint, Paint borderPaint) {
        canvas.drawRoundRect(this.borderRect, (float)this.radius, (float)this.radius, borderPaint);
        canvas.save();
        canvas.concat(this.matrix);
        canvas.drawRoundRect(this.imageRect, (float)this.bitmapRadius, (float)this.bitmapRadius, imagePaint);
        canvas.restore();
    }

    @Override
    public void onSizeChanged(int width, int height) {
        super.onSizeChanged(width, height);
        this.borderRect.set((float)this.borderWidth, (float)this.borderWidth, (float)(this.viewWidth - this.borderWidth), (float)(this.viewHeight - this.borderWidth));
    }

    @Override
    public void calculate(int bitmapWidth, int bitmapHeight, float width, float height, float scale, float translateX, float translateY) {
        this.imageRect.set(-translateX, -translateY, (float)bitmapWidth + translateX, (float)bitmapHeight + translateY);
        this.bitmapRadius = Math.round((float)this.radius / scale);
    }

    @Override
    public void reset() {
        this.imageRect.set(0.0f, 0.0f, 0.0f, 0.0f);
        this.bitmapRadius = 0;
    }
}

