/*
 * Decompiled with CFR 0.152.
 */
package com.github.siyamed.shapeimageview.shader;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import com.github.siyamed.shapeimageview.R;
import com.github.siyamed.shapeimageview.path.SvgUtil;
import com.github.siyamed.shapeimageview.path.parser.PathInfo;
import com.github.siyamed.shapeimageview.shader.ShaderHelper;

public class SvgShader
extends ShaderHelper {
    public static final int BORDER_TYPE_DEFAULT = 0;
    public static final int BORDER_TYPE_FILL = 1;
    public static final int STROKE_CAP_DEFAULT = -1;
    public static final int STROKE_CAP_BUTT = 0;
    public static final int STROKE_CAP_ROUND = 1;
    public static final int STROKE_CAP_SQUARE = 2;
    public static final int STROKE_JOIN_DEFAULT = -1;
    public static final int STROKE_JOIN_BEVEL = 0;
    public static final int STROKE_JOIN_MITER = 1;
    public static final int STROKE_JOIN_ROUND = 2;
    private PathInfo shapePath;
    private Path path = new Path();
    private Path borderPath = new Path();
    private Matrix pathMatrix = new Matrix();
    private float[] pathDimensions = new float[2];
    private int resId = -1;
    private int borderType = 0;
    private int strokeCap = -1;
    private int strokeJoin = -1;
    private int strokeMiter = 0;

    public SvgShader() {
    }

    public SvgShader(int resId) {
        this.resId = resId;
    }

    public SvgShader(int resId, int borderType) {
        this.resId = resId;
        this.borderType = borderType;
    }

    @Override
    public void init(Context context, AttributeSet attrs, int defStyle) {
        super.init(context, attrs, defStyle);
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ShaderImageView, defStyle, 0);
            this.resId = typedArray.getResourceId(11, this.resId);
            this.borderType = typedArray.getInt(11, this.borderType);
            this.strokeCap = typedArray.getInt(2, this.strokeCap);
            this.strokeJoin = typedArray.getInt(3, this.strokeJoin);
            this.strokeMiter = typedArray.getDimensionPixelSize(12, this.strokeMiter);
            typedArray.recycle();
        }
        if (this.resId == -1) {
            throw new RuntimeException("No resource is defined as shape");
        }
        this.shapePath = SvgUtil.readSvg(context, this.resId);
        this.setBorderType(this.borderType);
        this.setStrokeCap(this.strokeCap);
        this.setStrokeJoin(this.strokeJoin);
        this.setStrokeMiter(this.strokeMiter);
    }

    public void setStrokeMiter(int strokeMiter) {
        this.strokeMiter = strokeMiter;
        if (strokeMiter > 0) {
            this.borderPaint.setStrokeMiter((float)strokeMiter);
        }
    }

    public void setStrokeCap(int strokeCap) {
        this.strokeCap = strokeCap;
        switch (strokeCap) {
            case 0: {
                this.borderPaint.setStrokeCap(Paint.Cap.BUTT);
                break;
            }
            case 1: {
                this.borderPaint.setStrokeCap(Paint.Cap.ROUND);
                break;
            }
            case 2: {
                this.borderPaint.setStrokeCap(Paint.Cap.SQUARE);
                break;
            }
        }
    }

    public void setStrokeJoin(int strokeJoin) {
        this.strokeJoin = strokeJoin;
        switch (strokeJoin) {
            case 0: {
                this.borderPaint.setStrokeJoin(Paint.Join.BEVEL);
                break;
            }
            case 1: {
                this.borderPaint.setStrokeJoin(Paint.Join.MITER);
                break;
            }
            case 2: {
                this.borderPaint.setStrokeJoin(Paint.Join.ROUND);
                break;
            }
        }
    }

    public void setBorderType(int borderType) {
        this.borderType = borderType;
        switch (borderType) {
            case 1: {
                this.borderPaint.setStyle(Paint.Style.FILL);
                break;
            }
            default: {
                this.borderPaint.setStyle(Paint.Style.STROKE);
            }
        }
    }

    @Override
    public void draw(Canvas canvas, Paint imagePaint, Paint borderPaint) {
        canvas.save();
        canvas.drawPath(this.borderPath, borderPaint);
        canvas.concat(this.matrix);
        canvas.drawPath(this.path, imagePaint);
        canvas.restore();
    }

    @Override
    public void calculate(int bitmapWidth, int bitmapHeight, float width, float height, float scale, float translateX, float translateY) {
        this.path.reset();
        this.borderPath.reset();
        this.pathDimensions[0] = this.shapePath.getWidth();
        this.pathDimensions[1] = this.shapePath.getHeight();
        this.pathMatrix.reset();
        scale = Math.min(width / this.pathDimensions[0], height / this.pathDimensions[1]);
        translateX = Math.round((width - this.pathDimensions[0] * scale) * 0.5f);
        translateY = Math.round((height - this.pathDimensions[1] * scale) * 0.5f);
        this.pathMatrix.setScale(scale, scale);
        this.pathMatrix.postTranslate(translateX, translateY);
        this.shapePath.transform(this.pathMatrix, this.path);
        this.path.offset((float)this.borderWidth, (float)this.borderWidth);
        if (this.borderWidth > 0) {
            float d;
            float newHeight;
            float newWidth;
            this.pathMatrix.reset();
            if (this.borderType == 0) {
                newWidth = this.viewWidth - this.borderWidth;
                newHeight = this.viewHeight - this.borderWidth;
                d = (float)this.borderWidth / 2.0f;
            } else {
                newWidth = this.viewWidth;
                newHeight = this.viewHeight;
                d = 0.0f;
            }
            scale = Math.min(newWidth / this.pathDimensions[0], newHeight / this.pathDimensions[1]);
            translateX = Math.round((newWidth - this.pathDimensions[0] * scale) * 0.5f + d);
            translateY = Math.round((newHeight - this.pathDimensions[1] * scale) * 0.5f + d);
            this.pathMatrix.setScale(scale, scale);
            this.pathMatrix.postTranslate(translateX, translateY);
            this.shapePath.transform(this.pathMatrix, this.borderPath);
        }
        this.pathMatrix.reset();
        this.matrix.invert(this.pathMatrix);
        this.path.transform(this.pathMatrix);
    }

    @Override
    public void reset() {
        this.path.reset();
        this.borderPath.reset();
    }
}

