/*
 * Decompiled with CFR 0.152.
 */
package com.github.siyamed.shapeimageview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.github.siyamed.shapeimageview.shader.ShaderHelper;

public abstract class ShaderImageView
extends ImageView {
    private static final boolean DEBUG = false;
    private ShaderHelper pathHelper;

    public ShaderImageView(Context context) {
        super(context);
        this.setup(context, null, 0);
    }

    public ShaderImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setup(context, attrs, 0);
    }

    public ShaderImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setup(context, attrs, defStyle);
    }

    private void setup(Context context, AttributeSet attrs, int defStyle) {
        this.getPathHelper().init(context, attrs, defStyle);
    }

    protected ShaderHelper getPathHelper() {
        if (this.pathHelper == null) {
            this.pathHelper = this.createImageViewHelper();
        }
        return this.pathHelper;
    }

    protected abstract ShaderHelper createImageViewHelper();

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.getPathHelper().isSquare()) {
            int width = this.getMeasuredWidth();
            int height = this.getMeasuredHeight();
            int dimen = Math.min(width, height);
            this.setMeasuredDimension(dimen, dimen);
        }
    }

    public void setImageBitmap(Bitmap bm) {
        super.setImageBitmap(bm);
        this.getPathHelper().onImageDrawableReset(this.getDrawable());
    }

    public void setImageDrawable(Drawable drawable) {
        super.setImageDrawable(drawable);
        this.getPathHelper().onImageDrawableReset(this.getDrawable());
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
        this.getPathHelper().onImageDrawableReset(this.getDrawable());
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.getPathHelper().onSizeChanged(w, h);
    }

    public void onDraw(Canvas canvas) {
        if (!this.getPathHelper().onDraw(canvas)) {
            super.onDraw(canvas);
        }
    }
}

