/*
 * Decompiled with CFR 0.152.
 */
package com.github.siyamed.shapeimageview.path.parser;

import android.graphics.Matrix;
import android.util.Log;
import com.github.siyamed.shapeimageview.path.parser.NumberParse;
import com.github.siyamed.shapeimageview.path.parser.SvgToPath;

class TransformParser {
    private static final String TAG = SvgToPath.class.getSimpleName();

    TransformParser() {
    }

    static Matrix parseTransform(String s) {
        Matrix matrix = new Matrix();
        while (true) {
            TransformParser.parseTransformItem(s, matrix);
            int rparen = s.indexOf(")");
            if (rparen <= 0 || s.length() <= rparen + 1) break;
            s = s.substring(rparen + 1).replaceFirst("[\\s,]*", "");
        }
        return matrix;
    }

    private static void parseTransformItem(String s, Matrix matrix) {
        if (s.startsWith("matrix(")) {
            NumberParse np = NumberParse.parseNumbers(s.substring("matrix(".length()));
            if (np.numbers.size() == 6) {
                Matrix mat = new Matrix();
                mat.setValues(new float[]{np.numbers.get(0).floatValue(), np.numbers.get(2).floatValue(), np.numbers.get(4).floatValue(), np.numbers.get(1).floatValue(), np.numbers.get(3).floatValue(), np.numbers.get(5).floatValue(), 0.0f, 0.0f, 1.0f});
                matrix.preConcat(mat);
            }
        } else if (s.startsWith("translate(")) {
            NumberParse np = NumberParse.parseNumbers(s.substring("translate(".length()));
            if (np.numbers.size() > 0) {
                float tx = np.numbers.get(0).floatValue();
                float ty = 0.0f;
                if (np.numbers.size() > 1) {
                    ty = np.numbers.get(1).floatValue();
                }
                matrix.preTranslate(tx, ty);
            }
        } else if (s.startsWith("scale(")) {
            NumberParse np = NumberParse.parseNumbers(s.substring("scale(".length()));
            if (np.numbers.size() > 0) {
                float sx;
                float sy = sx = np.numbers.get(0).floatValue();
                if (np.numbers.size() > 1) {
                    sy = np.numbers.get(1).floatValue();
                }
                matrix.preScale(sx, sy);
            }
        } else if (s.startsWith("skewX(")) {
            NumberParse np = NumberParse.parseNumbers(s.substring("skewX(".length()));
            if (np.numbers.size() > 0) {
                float angle = np.numbers.get(0).floatValue();
                matrix.preSkew((float)Math.tan(angle), 0.0f);
            }
        } else if (s.startsWith("skewY(")) {
            NumberParse np = NumberParse.parseNumbers(s.substring("skewY(".length()));
            if (np.numbers.size() > 0) {
                float angle = np.numbers.get(0).floatValue();
                matrix.preSkew(0.0f, (float)Math.tan(angle));
            }
        } else if (s.startsWith("rotate(")) {
            NumberParse np = NumberParse.parseNumbers(s.substring("rotate(".length()));
            if (np.numbers.size() > 0) {
                float angle = np.numbers.get(0).floatValue();
                float cx = 0.0f;
                float cy = 0.0f;
                if (np.numbers.size() > 2) {
                    cx = np.numbers.get(1).floatValue();
                    cy = np.numbers.get(2).floatValue();
                }
                matrix.preTranslate(cx, cy);
                matrix.preRotate(angle);
                matrix.preTranslate(-cx, -cy);
            }
        } else {
            Log.w((String)TAG, (String)("Invalid transform (" + s + ")"));
        }
    }
}

