/*
 * Decompiled with CFR 0.152.
 */
package com.github.siyamed.shapeimageview.shader;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import com.github.siyamed.shapeimageview.R;
import com.github.siyamed.shapeimageview.shader.ShaderHelper;

public class BubbleShader
extends ShaderHelper {
    private static final int DEFAULT_HEIGHT_DP = 10;
    private final Path path = new Path();
    private int triangleHeightPx;
    private ArrowPosition arrowPosition = ArrowPosition.LEFT;

    @Override
    public void init(Context context, AttributeSet attrs, int defStyle) {
        super.init(context, attrs, defStyle);
        this.borderWidth = 0;
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ShaderImageView, defStyle, 0);
            this.triangleHeightPx = typedArray.getDimensionPixelSize(10, 0);
            int arrowPositionInt = typedArray.getInt(0, ArrowPosition.LEFT.ordinal());
            this.arrowPosition = ArrowPosition.values()[arrowPositionInt];
            typedArray.recycle();
        }
        if (this.triangleHeightPx == 0) {
            this.triangleHeightPx = this.dpToPx(context.getResources().getDisplayMetrics(), 10);
        }
    }

    @Override
    public void draw(Canvas canvas, Paint imagePaint, Paint borderPaint) {
        canvas.save();
        canvas.concat(this.matrix);
        canvas.drawPath(this.path, imagePaint);
        canvas.restore();
    }

    @Override
    public void calculate(int bitmapWidth, int bitmapHeight, float width, float height, float scale, float translateX, float translateY) {
        this.path.reset();
        float x = -translateX;
        float y = -translateY;
        float scaledTriangleHeight = (float)this.triangleHeightPx / scale;
        float resultWidth = (float)bitmapWidth + 2.0f * translateX;
        float resultHeight = (float)bitmapHeight + 2.0f * translateY;
        float centerY = resultHeight / 2.0f + y;
        this.path.setFillType(Path.FillType.EVEN_ODD);
        switch (this.arrowPosition) {
            case LEFT: {
                float rectLeft = scaledTriangleHeight + x;
                float rectRight = resultWidth + rectLeft;
                this.path.addRect(rectLeft, y, rectRight, resultHeight + y, Path.Direction.CW);
                this.path.moveTo(x, centerY);
                this.path.lineTo(rectLeft, centerY - scaledTriangleHeight);
                this.path.lineTo(rectLeft, centerY + scaledTriangleHeight);
                this.path.lineTo(x, centerY);
                break;
            }
            case RIGHT: {
                float rectLeft = x;
                float imgRight = resultWidth + rectLeft;
                float rectRight = imgRight - scaledTriangleHeight;
                this.path.addRect(rectLeft, y, rectRight, resultHeight + y, Path.Direction.CW);
                this.path.moveTo(imgRight, centerY);
                this.path.lineTo(rectRight, centerY - scaledTriangleHeight);
                this.path.lineTo(rectRight, centerY + scaledTriangleHeight);
                this.path.lineTo(imgRight, centerY);
            }
        }
    }

    @Override
    public void reset() {
        this.path.reset();
    }

    private static enum ArrowPosition {
        LEFT,
        RIGHT;

    }
}

