/*
 * Decompiled with CFR 0.152.
 */
package com.github.siyamed.shapeimageview.shader;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import com.github.siyamed.shapeimageview.R;

public abstract class ShaderHelper {
    private static final int ALPHA_MAX = 255;
    protected int viewWidth;
    protected int viewHeight;
    protected int borderColor = -16777216;
    protected int borderWidth = 0;
    protected float borderAlpha = 1.0f;
    protected boolean square = false;
    protected final Paint borderPaint;
    protected final Paint imagePaint;
    protected BitmapShader shader;
    protected Drawable drawable;
    protected final Matrix matrix = new Matrix();

    public ShaderHelper() {
        this.borderPaint = new Paint();
        this.borderPaint.setStyle(Paint.Style.STROKE);
        this.borderPaint.setAntiAlias(true);
        this.imagePaint = new Paint();
        this.imagePaint.setAntiAlias(true);
    }

    public abstract void draw(Canvas var1, Paint var2, Paint var3);

    public abstract void reset();

    public abstract void calculate(int var1, int var2, float var3, float var4, float var5, float var6, float var7);

    protected final int dpToPx(DisplayMetrics displayMetrics, int dp) {
        return Math.round((float)dp * (displayMetrics.xdpi / 160.0f));
    }

    public boolean isSquare() {
        return this.square;
    }

    public void init(Context context, AttributeSet attrs, int defStyle) {
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ShaderImageView, defStyle, 0);
            this.borderColor = typedArray.getColor(5, this.borderColor);
            this.borderWidth = typedArray.getDimensionPixelSize(6, this.borderWidth);
            this.borderAlpha = typedArray.getFloat(7, this.borderAlpha);
            this.square = typedArray.getBoolean(4, this.square);
            typedArray.recycle();
        }
        this.borderPaint.setColor(this.borderColor);
        this.borderPaint.setAlpha(Float.valueOf(this.borderAlpha * 255.0f).intValue());
        this.borderPaint.setStrokeWidth((float)this.borderWidth);
    }

    public boolean onDraw(Canvas canvas) {
        if (this.shader == null) {
            this.createShader();
        }
        if (this.shader != null && this.viewWidth > 0 && this.viewHeight > 0) {
            this.draw(canvas, this.imagePaint, this.borderPaint);
            return true;
        }
        return false;
    }

    public void onSizeChanged(int width, int height) {
        this.viewWidth = width;
        this.viewHeight = height;
        if (this.isSquare()) {
            this.viewWidth = this.viewHeight = Math.min(width, height);
        }
        if (this.shader != null) {
            this.calculateDrawableSizes();
        }
    }

    public Bitmap calculateDrawableSizes() {
        Bitmap bitmap = this.getBitmap();
        if (bitmap != null) {
            int bitmapWidth = bitmap.getWidth();
            int bitmapHeight = bitmap.getHeight();
            if (bitmapWidth > 0 && bitmapHeight > 0) {
                float scale;
                float width = Math.round((float)this.viewWidth - 2.0f * (float)this.borderWidth);
                float height = Math.round((float)this.viewHeight - 2.0f * (float)this.borderWidth);
                float translateX = 0.0f;
                float translateY = 0.0f;
                if ((float)bitmapWidth * height > width * (float)bitmapHeight) {
                    scale = height / (float)bitmapHeight;
                    translateX = Math.round((width / scale - (float)bitmapWidth) / 2.0f);
                } else {
                    scale = width / (float)bitmapWidth;
                    translateY = Math.round((height / scale - (float)bitmapHeight) / 2.0f);
                }
                this.matrix.setScale(scale, scale);
                this.matrix.preTranslate(translateX, translateY);
                this.matrix.postTranslate((float)this.borderWidth, (float)this.borderWidth);
                this.calculate(bitmapWidth, bitmapHeight, width, height, scale, translateX, translateY);
                return bitmap;
            }
        }
        this.reset();
        return null;
    }

    public final void onImageDrawableReset(Drawable drawable) {
        this.drawable = drawable;
        this.shader = null;
        this.imagePaint.setShader(null);
    }

    protected void createShader() {
        Bitmap bitmap = this.calculateDrawableSizes();
        if (bitmap != null && bitmap.getWidth() > 0 && bitmap.getHeight() > 0) {
            this.shader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            this.imagePaint.setShader((Shader)this.shader);
        }
    }

    protected Bitmap getBitmap() {
        Bitmap bitmap = null;
        if (this.drawable != null && this.drawable instanceof BitmapDrawable) {
            bitmap = ((BitmapDrawable)this.drawable).getBitmap();
        }
        return bitmap;
    }
}

