/*
 * Decompiled with CFR 0.152.
 */
package com.github.siyamed.shapeimageview.mask;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import com.github.siyamed.shapeimageview.R;
import com.github.siyamed.shapeimageview.mask.PorterImageView;

public class PorterShapeImageView
extends PorterImageView {
    private Drawable shape;
    private Matrix matrix;
    private Matrix drawMatrix;

    public PorterShapeImageView(Context context) {
        super(context);
        this.setup(context, null, 0);
    }

    public PorterShapeImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setup(context, attrs, 0);
    }

    public PorterShapeImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setup(context, attrs, defStyle);
    }

    private void setup(Context context, AttributeSet attrs, int defStyle) {
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ShaderImageView, defStyle, 0);
            this.shape = typedArray.getDrawable(R.styleable.ShaderImageView_siShape);
            typedArray.recycle();
        }
        this.matrix = new Matrix();
    }

    @Override
    protected void paintMaskCanvas(Canvas maskCanvas, Paint maskPaint, int width, int height) {
        if (this.shape != null) {
            if (this.shape instanceof BitmapDrawable) {
                this.configureBitmapBounds(width, height);
                if (this.drawMatrix != null) {
                    int drawableSaveCount = maskCanvas.getSaveCount();
                    maskCanvas.save();
                    maskCanvas.concat(this.matrix);
                    this.shape.draw(maskCanvas);
                    maskCanvas.restoreToCount(drawableSaveCount);
                    return;
                }
            }
            this.shape.setBounds(0, 0, width, height);
            this.shape.draw(maskCanvas);
        }
    }

    private void configureBitmapBounds(int viewWidth, int viewHeight) {
        boolean fits;
        this.drawMatrix = null;
        int drawableWidth = this.shape.getIntrinsicWidth();
        int drawableHeight = this.shape.getIntrinsicHeight();
        boolean bl = fits = viewWidth == drawableWidth && viewHeight == drawableHeight;
        if (drawableWidth > 0 && drawableHeight > 0 && !fits) {
            this.shape.setBounds(0, 0, drawableWidth, drawableHeight);
            float widthRatio = (float)viewWidth / (float)drawableWidth;
            float heightRatio = (float)viewHeight / (float)drawableHeight;
            float scale = Math.min(widthRatio, heightRatio);
            float dx = (int)(((float)viewWidth - (float)drawableWidth * scale) * 0.5f + 0.5f);
            float dy = (int)(((float)viewHeight - (float)drawableHeight * scale) * 0.5f + 0.5f);
            this.matrix.setScale(scale, scale);
            this.matrix.postTranslate(dx, dy);
        }
    }
}

