/*
 * Decompiled with CFR 0.152.
 */
package com.github.siyamed.shapeimageview.path.parser;

import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;

class NumberParse {
    final ArrayList<Float> numbers;
    private final int nextCmd;

    private NumberParse(ArrayList<Float> numbers, int nextCmd) {
        this.numbers = numbers;
        this.nextCmd = nextCmd;
    }

    public int getNextCmd() {
        return this.nextCmd;
    }

    public float getNumber(int index) {
        return this.numbers.get(index).floatValue();
    }

    static final NumberParse getNumberParseAttr(String name, XmlPullParser attributes) {
        int n = attributes.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            if (!attributes.getAttributeName(i).equals(name)) continue;
            return NumberParse.parseNumbers(attributes.getAttributeValue(i));
        }
        return null;
    }

    static NumberParse parseNumbers(String s) {
        int n = s.length();
        int p = 0;
        ArrayList<Float> numbers = new ArrayList<Float>();
        boolean skipChar = false;
        block6: for (int i = 1; i < n; ++i) {
            if (skipChar) {
                skipChar = false;
                continue;
            }
            char c = s.charAt(i);
            switch (c) {
                case ')': 
                case 'A': 
                case 'C': 
                case 'H': 
                case 'L': 
                case 'M': 
                case 'Q': 
                case 'S': 
                case 'T': 
                case 'V': 
                case 'Z': 
                case 'a': 
                case 'c': 
                case 'h': 
                case 'l': 
                case 'm': 
                case 'q': 
                case 's': 
                case 't': 
                case 'v': 
                case 'z': {
                    Float f;
                    String str = s.substring(p, i);
                    if (str.trim().length() > 0) {
                        f = Float.valueOf(Float.parseFloat(str));
                        numbers.add(f);
                    }
                    p = i;
                    return new NumberParse(numbers, p);
                }
                case '\t': 
                case '\n': 
                case ' ': 
                case ',': {
                    Float f;
                    String str = s.substring(p, i);
                    if (str.trim().length() > 0) {
                        f = Float.valueOf(Float.parseFloat(str));
                        numbers.add(f);
                        if (c == '-') {
                            p = i;
                            continue block6;
                        }
                        p = i + 1;
                        skipChar = true;
                        continue block6;
                    }
                    ++p;
                    continue block6;
                }
            }
        }
        String last = s.substring(p);
        if (last.length() > 0) {
            try {
                numbers.add(Float.valueOf(Float.parseFloat(last)));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            p = s.length();
        }
        return new NumberParse(numbers, p);
    }
}

