/*
 * Decompiled with CFR 0.152.
 */
package com.github.siyamed.shapeimageview.shader;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import com.github.siyamed.shapeimageview.shader.ShaderHelper;

public class CircleShader
extends ShaderHelper {
    private float center;
    private float bitmapCenterX;
    private float bitmapCenterY;
    private float borderRadius;
    private int bitmapRadius;

    @Override
    public void init(Context context, AttributeSet attrs, int defStyle) {
        super.init(context, attrs, defStyle);
        this.square = true;
    }

    @Override
    public void draw(Canvas canvas, Paint imagePaint, Paint borderPaint) {
        canvas.drawCircle(this.center, this.center, this.borderRadius, borderPaint);
        canvas.save();
        canvas.concat(this.matrix);
        canvas.drawCircle(this.bitmapCenterX, this.bitmapCenterY, (float)this.bitmapRadius, imagePaint);
        canvas.restore();
    }

    @Override
    public void onSizeChanged(int width, int height) {
        super.onSizeChanged(width, height);
        this.center = Math.round((float)this.viewWidth / 2.0f);
        this.borderRadius = Math.round((float)(this.viewWidth - this.borderWidth) / 2.0f);
    }

    @Override
    public void calculate(int bitmapWidth, int bitmapHeight, float width, float height, float scale, float translateX, float translateY) {
        this.bitmapCenterX = Math.round((float)bitmapWidth / 2.0f);
        this.bitmapCenterY = Math.round((float)bitmapHeight / 2.0f);
        this.bitmapRadius = Math.round(width / scale / 2.0f + 0.5f);
    }

    @Override
    public void reset() {
        this.bitmapRadius = 0;
        this.bitmapCenterX = 0.0f;
        this.bitmapCenterY = 0.0f;
    }

    public final float getBorderRadius() {
        return this.borderRadius;
    }

    public final void setBorderRadius(float borderRadius) {
        this.borderRadius = borderRadius;
    }
}

