/*
 * Decompiled with CFR 0.152.
 */
package com.github.siyamed.shapeimageview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import com.github.siyamed.shapeimageview.R;
import com.github.siyamed.shapeimageview.ShaderHelper;

public class BubbleShader
extends ShaderHelper {
    private static final int DEFAULT_HEIGHT_DP = 10;
    Path path = new Path();
    private int triangleHeightPx;
    private ArrowPosition arrowPosition = ArrowPosition.LEFT;

    @Override
    public void init(Context context, AttributeSet attrs, int defStyle) {
        super.init(context, attrs, defStyle);
        this.borderWidth = 0;
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ShaderImageView, defStyle, 0);
            this.triangleHeightPx = typedArray.getDimensionPixelSize(7, 0);
            int arrowPositionInt = typedArray.getInt(0, ArrowPosition.LEFT.ordinal());
            this.arrowPosition = ArrowPosition.values()[arrowPositionInt];
            typedArray.recycle();
        }
        if (this.triangleHeightPx == 0) {
            this.triangleHeightPx = this.dpToPx(context.getResources().getDisplayMetrics(), 10);
        }
    }

    @Override
    public void draw(Canvas canvas, Paint imagePaint, Paint borderPaint) {
        canvas.save();
        canvas.concat(this.matrix);
        canvas.drawPath(this.path, imagePaint);
        canvas.restore();
    }

    @Override
    public Bitmap calculateDrawableSizes() {
        Bitmap bitmap = this.getBitmap();
        if (bitmap != null) {
            int bitmapWidth = bitmap.getWidth();
            int bitmapHeight = bitmap.getHeight();
            if (bitmapWidth > 0 && bitmapHeight > 0) {
                float width = Math.round((float)this.viewWidth - 2.0f * (float)this.borderWidth);
                float height = Math.round((float)this.viewHeight - 2.0f * (float)this.borderWidth);
                float scale = 1.0f;
                float translateX = 0.0f;
                float translateY = 0.0f;
                if ((float)bitmapWidth * height > width * (float)bitmapHeight) {
                    scale = height / (float)bitmapHeight;
                    translateX = Math.round((width / scale - (float)bitmapWidth) / 2.0f);
                } else {
                    scale = width / (float)bitmapWidth;
                    translateY = Math.round((height / scale - (float)bitmapHeight) / 2.0f);
                }
                this.matrix.setScale(scale, scale);
                this.matrix.preTranslate(translateX, translateY);
                this.matrix.postTranslate((float)this.borderWidth, (float)this.borderWidth);
                this.path.reset();
                float x = -translateX;
                float y = -translateY;
                float scaledTriangleHeight = (float)this.triangleHeightPx / scale;
                float resultWidth = (float)bitmapWidth + 2.0f * translateX;
                float resultHeight = (float)bitmapHeight + 2.0f * translateY;
                float centerY = resultHeight / 2.0f + y;
                float triangle = scaledTriangleHeight;
                this.path.setFillType(Path.FillType.EVEN_ODD);
                switch (this.arrowPosition) {
                    case LEFT: {
                        float rectLeft = scaledTriangleHeight + x;
                        float rectRight = resultWidth + rectLeft;
                        this.path.addRect(rectLeft, y, rectRight, resultHeight + y, Path.Direction.CW);
                        this.path.moveTo(x, centerY);
                        this.path.lineTo(rectLeft, centerY - triangle);
                        this.path.lineTo(rectLeft, centerY + triangle);
                        this.path.lineTo(x, centerY);
                        break;
                    }
                    case RIGHT: {
                        float rectLeft = x;
                        float imgRight = resultWidth + rectLeft;
                        float rectRight = imgRight - scaledTriangleHeight;
                        this.path.addRect(rectLeft, y, rectRight, resultHeight + y, Path.Direction.CW);
                        this.path.moveTo(imgRight, centerY);
                        this.path.lineTo(rectRight, centerY - triangle);
                        this.path.lineTo(rectRight, centerY + triangle);
                        this.path.lineTo(imgRight, centerY);
                    }
                }
                return bitmap;
            }
        }
        return null;
    }

    private static enum ArrowPosition {
        LEFT,
        RIGHT;

    }
}

