/*
 * Decompiled with CFR 0.152.
 */
package com.github.siyamed.shapeimageview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import com.github.siyamed.shapeimageview.ShaderHelper;

public class CircleShader
extends ShaderHelper {
    float center;
    float bitmapCenterX;
    float bitmapCenterY;
    float borderRadius;
    int bitmapRadius;

    @Override
    public void init(Context context, AttributeSet attrs, int defStyle) {
        super.init(context, attrs, defStyle);
        this.square = true;
    }

    @Override
    public void draw(Canvas canvas, Paint imagePaint, Paint borderPaint) {
        canvas.drawCircle(this.center, this.center, this.borderRadius, borderPaint);
        canvas.save();
        canvas.concat(this.matrix);
        canvas.drawCircle(this.bitmapCenterX, this.bitmapCenterY, (float)this.bitmapRadius, imagePaint);
        canvas.restore();
    }

    @Override
    public void onSizeChanged(int width, int height) {
        super.onSizeChanged(width, height);
        this.center = Math.round((float)this.viewWidth / 2.0f);
        this.borderRadius = Math.round((float)(this.viewWidth - this.borderWidth) / 2.0f);
    }

    @Override
    public Bitmap calculateDrawableSizes() {
        Bitmap bitmap = this.getBitmap();
        if (bitmap != null) {
            int bitmapWidth = bitmap.getWidth();
            int bitmapHeight = bitmap.getHeight();
            if (bitmapWidth > 0 && bitmapHeight > 0) {
                float width = Math.round((float)this.viewWidth - 2.0f * (float)this.borderWidth);
                float height = Math.round((float)this.viewHeight - 2.0f * (float)this.borderWidth);
                float scale = 1.0f;
                float translateX = 0.0f;
                float translateY = 0.0f;
                if ((float)bitmapWidth * height > width * (float)bitmapHeight) {
                    scale = height / (float)bitmapHeight;
                    translateX = Math.round((width / scale - (float)bitmapWidth) / 2.0f);
                } else {
                    scale = width / (float)bitmapWidth;
                    translateY = Math.round((height / scale - (float)bitmapHeight) / 2.0f);
                }
                this.matrix.setScale(scale, scale);
                this.matrix.preTranslate(translateX, translateY);
                this.matrix.postTranslate((float)this.borderWidth, (float)this.borderWidth);
                this.bitmapCenterX = Math.round((float)bitmapWidth / 2.0f);
                this.bitmapCenterY = Math.round((float)bitmapHeight / 2.0f);
                this.bitmapRadius = Math.round(width / scale / 2.0f + 0.5f);
                return bitmap;
            }
        }
        return null;
    }
}

