/*
 * Decompiled with CFR 0.152.
 */
package com.github.siyamed.shapeimageview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import com.github.siyamed.shapeimageview.R;
import com.github.siyamed.shapeimageview.ShaderHelper;

public class RoundedShader
extends ShaderHelper {
    private RectF borderRect = new RectF();
    private RectF imageRect = new RectF();
    private int radius = 0;
    private int bitmapRadius;

    @Override
    public void init(Context context, AttributeSet attrs, int defStyle) {
        super.init(context, attrs, defStyle);
        this.borderPaint.setStrokeWidth((float)(this.borderWidth * 2));
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ShaderImageView, defStyle, 0);
            this.radius = typedArray.getDimensionPixelSize(6, this.radius);
            typedArray.recycle();
        }
    }

    @Override
    public void draw(Canvas canvas, Paint imagePaint, Paint borderPaint) {
        canvas.drawRoundRect(this.borderRect, (float)this.radius, (float)this.radius, borderPaint);
        canvas.save();
        canvas.concat(this.matrix);
        canvas.drawRoundRect(this.imageRect, (float)this.bitmapRadius, (float)this.bitmapRadius, imagePaint);
        canvas.restore();
    }

    @Override
    public void onSizeChanged(int width, int height) {
        super.onSizeChanged(width, height);
        this.borderRect.set((float)this.borderWidth, (float)this.borderWidth, (float)(this.viewWidth - this.borderWidth), (float)(this.viewHeight - this.borderWidth));
    }

    @Override
    public Bitmap calculateDrawableSizes() {
        Bitmap bitmap = this.getBitmap();
        if (bitmap != null) {
            int bitmapWidth = bitmap.getWidth();
            int bitmapHeight = bitmap.getHeight();
            if (bitmapWidth > 0 && bitmapHeight > 0) {
                float width = Math.round((float)this.viewWidth - 2.0f * (float)this.borderWidth);
                float height = Math.round((float)this.viewHeight - 2.0f * (float)this.borderWidth);
                float scale = 1.0f;
                float translateX = 0.0f;
                float translateY = 0.0f;
                if ((float)bitmapWidth * height > width * (float)bitmapHeight) {
                    scale = height / (float)bitmapHeight;
                    translateX = Math.round((width / scale - (float)bitmapWidth) / 2.0f);
                } else {
                    scale = width / (float)bitmapWidth;
                    translateY = Math.round((height / scale - (float)bitmapHeight) / 2.0f);
                }
                this.matrix.setScale(scale, scale);
                this.matrix.preTranslate(translateX, translateY);
                this.matrix.postTranslate((float)this.borderWidth, (float)this.borderWidth);
                this.imageRect.set(-translateX, -translateY, (float)bitmapWidth + translateX, (float)bitmapHeight + translateY);
                this.bitmapRadius = Math.round((float)this.radius / scale);
                return bitmap;
            }
        }
        return null;
    }
}

