/*
 * Decompiled with CFR 0.152.
 */
package com.github.siyamed.shapeimageview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import com.github.siyamed.shapeimageview.R;

public abstract class ShaderHelper {
    private static int ALPHA_MAX = 255;
    protected int viewWidth;
    protected int viewHeight;
    protected int borderColor = -16777216;
    protected int borderWidth = 0;
    protected float borderAlpha = 1.0f;
    protected boolean square = false;
    protected Paint borderPaint;
    protected Paint imagePaint;
    protected BitmapShader shader;
    protected Drawable drawable;
    protected Matrix matrix = new Matrix();

    public ShaderHelper() {
        this.borderPaint = new Paint();
        this.borderPaint.setStyle(Paint.Style.STROKE);
        this.borderPaint.setAntiAlias(true);
        this.imagePaint = new Paint();
        this.imagePaint.setAntiAlias(true);
    }

    public abstract void draw(Canvas var1, Paint var2, Paint var3);

    public abstract Bitmap calculateDrawableSizes();

    protected final int dpToPx(DisplayMetrics displayMetrics, int dp) {
        int px = Math.round((float)dp * (displayMetrics.xdpi / 160.0f));
        return px;
    }

    public boolean isSquare() {
        return this.square;
    }

    public void init(Context context, AttributeSet attrs, int defStyle) {
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ShaderImageView, defStyle, 0);
            this.borderColor = typedArray.getColor(2, this.borderColor);
            this.borderWidth = typedArray.getDimensionPixelSize(3, this.borderWidth);
            this.borderAlpha = typedArray.getFloat(4, this.borderAlpha);
            this.square = typedArray.getBoolean(1, this.square);
            typedArray.recycle();
        }
        this.borderPaint.setColor(this.borderColor);
        this.borderPaint.setAlpha(Float.valueOf(this.borderAlpha * (float)ALPHA_MAX).intValue());
        this.borderPaint.setStrokeWidth((float)this.borderWidth);
    }

    public boolean onDraw(Canvas canvas) {
        if (this.shader == null) {
            this.createShader();
        }
        if (this.shader != null && this.viewWidth > 0 && this.viewHeight > 0) {
            this.draw(canvas, this.imagePaint, this.borderPaint);
            return true;
        }
        return false;
    }

    public void onSizeChanged(int width, int height) {
        this.viewWidth = width;
        this.viewHeight = height;
        if (this.isSquare()) {
            this.viewWidth = this.viewHeight = Math.min(width, height);
        }
        if (this.shader != null) {
            this.calculateDrawableSizes();
        }
    }

    public final void onImageDrawableReset(Drawable drawable) {
        this.drawable = drawable;
        this.shader = null;
        this.imagePaint.setShader(null);
    }

    protected void createShader() {
        Bitmap bitmap = this.calculateDrawableSizes();
        if (bitmap != null && bitmap.getWidth() > 0 && bitmap.getHeight() > 0) {
            this.shader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            this.imagePaint.setShader((Shader)this.shader);
        }
    }

    protected Bitmap getBitmap() {
        Bitmap bitmap = null;
        if (this.drawable != null && this.drawable instanceof BitmapDrawable) {
            bitmap = ((BitmapDrawable)this.drawable).getBitmap();
        }
        return bitmap;
    }
}

