/*
 * Decompiled with CFR 0.152.
 */
package com.github.skjolber.jackson.jsh;

import com.github.skjolber.jackson.jsh.AnsiSyntaxHighlight;
import com.github.skjolber.jackson.jsh.SyntaxHighlighter;
import java.math.BigDecimal;
import java.math.BigInteger;

public class DefaultSyntaxHighlighter
implements SyntaxHighlighter {
    protected String fieldName;
    protected String binaryValue;
    protected String booleanValue;
    protected String nullValue;
    protected String numberValue;
    protected String stringValue;
    protected String curlyBrackets;
    protected String squareBrackets;
    protected String colon;
    protected String whitespace;
    protected String comma;

    public static Builder newBuilder() {
        return new Builder();
    }

    public DefaultSyntaxHighlighter() {
        this(DefaultSyntaxHighlighter.newBuilder());
    }

    public DefaultSyntaxHighlighter(String fieldValue, String binaryValue, String booleanValue, String nullValue, String numberValue, String stringValue, String curlyBrackets, String squareBrackets, String colon, String whitespace, String comma) {
        this.fieldName = fieldValue;
        this.binaryValue = binaryValue;
        this.booleanValue = booleanValue;
        this.nullValue = nullValue;
        this.numberValue = numberValue;
        this.stringValue = stringValue;
        this.curlyBrackets = curlyBrackets;
        this.squareBrackets = squareBrackets;
        this.colon = colon;
        this.whitespace = whitespace;
        this.comma = comma;
    }

    public DefaultSyntaxHighlighter(Builder builder) {
        this(builder.build(builder.fieldName), builder.build(builder.binaryValue), builder.build(builder.booleanValue), builder.build(builder.nullValue), builder.build(builder.numberValue), builder.build(builder.stringValue), builder.build(builder.curlyBrackets), builder.build(builder.squareBrackets), builder.build(builder.colon), builder.build(builder.whitespace), builder.build(builder.comma));
    }

    @Override
    public String forFieldName(String value) {
        return this.fieldName;
    }

    @Override
    public String forNumber(int value) {
        return this.numberValue;
    }

    @Override
    public String forNumber(long value) {
        return this.numberValue;
    }

    @Override
    public String forNumber(double value) {
        return this.numberValue;
    }

    @Override
    public String forString(String string) {
        return this.stringValue;
    }

    @Override
    public String forBinary() {
        return this.binaryValue;
    }

    @Override
    public String forBoolean(boolean value) {
        return this.booleanValue;
    }

    @Override
    public String forNull() {
        return this.nullValue;
    }

    @Override
    public String forCurlyBrackets() {
        return this.curlyBrackets;
    }

    @Override
    public String forSquareBrackets() {
        return this.squareBrackets;
    }

    @Override
    public String forColon() {
        return this.colon;
    }

    @Override
    public String forWhitespace() {
        return this.whitespace;
    }

    @Override
    public String forComma() {
        return this.comma;
    }

    @Override
    public String forNumber(BigInteger v) {
        return this.numberValue;
    }

    @Override
    public String forNumber(BigDecimal v) {
        return this.numberValue;
    }

    @Override
    public String forNumber(String encodedValue) {
        return this.numberValue;
    }

    public static class Builder {
        protected String[] fieldName;
        protected String[] binaryValue;
        protected String[] booleanValue;
        protected String[] nullValue;
        protected String[] numberValue;
        protected String[] stringValue;
        protected String[] curlyBrackets;
        protected String[] squareBrackets;
        protected String[] colon;
        protected String[] whitespace;
        protected String[] comma;
        protected String background;

        protected String build(String[] colors) {
            if (this.background == null) {
                return AnsiSyntaxHighlight.build(colors);
            }
            if (colors == null || colors.length == 0) {
                return AnsiSyntaxHighlight.build(this.background);
            }
            for (String c : colors) {
                if (!AnsiSyntaxHighlight.isBackground(c)) continue;
                return AnsiSyntaxHighlight.build(colors);
            }
            String[] colorsWithBackground = new String[colors.length + 1];
            System.arraycopy(colors, 0, colorsWithBackground, 0, colors.length);
            colorsWithBackground[colors.length] = this.background;
            return AnsiSyntaxHighlight.build(colorsWithBackground);
        }

        public Builder withComma(String ... value) {
            this.comma = value;
            return this;
        }

        public Builder withCurlyBrackets(String ... value) {
            this.curlyBrackets = value;
            return this;
        }

        public Builder withSquareBrackets(String ... value) {
            this.squareBrackets = value;
            return this;
        }

        public Builder withColon(String ... value) {
            this.colon = value;
            return this;
        }

        public Builder withWhitespace(String ... value) {
            this.whitespace = value;
            return this;
        }

        public Builder withField(String ... value) {
            this.fieldName = value;
            return this;
        }

        public Builder withBinary(String ... values) {
            this.binaryValue = values;
            return this;
        }

        public Builder withBoolean(String ... values) {
            this.booleanValue = values;
            return this;
        }

        public Builder withNull(String ... values) {
            this.nullValue = values;
            return this;
        }

        public Builder withNumber(String ... values) {
            this.numberValue = values;
            return this;
        }

        public Builder withString(String ... values) {
            this.stringValue = values;
            return this;
        }

        public Builder withBackground(String value) {
            this.background = value;
            return this;
        }

        public DefaultSyntaxHighlighter build() {
            return new DefaultSyntaxHighlighter(this);
        }
    }
}

